// ---------
// fdlibml.h
// ---------
# if ! defined FDLIBML_H
#	define FDLIBML_H

#ifdef __cplusplus
extern "C" {
#endif
#undef __STRICT_ANSI__
/*
Adapted from fdlibm.h for DJGPP/GCC by KB Williams,
kbwms@aol.com, December 2001 & December 2003
*/
#include <math.h>

typedef long	 double		LDBL;
typedef long	 long		LLONG;
typedef unsigned char		UCHAR;
typedef unsigned int		UINT;
typedef unsigned long		ULONG;
typedef unsigned long long	ULLONG;
typedef unsigned short		USHORT;

typedef int			int32_t;
typedef LLONG			int64_t;
typedef UINT			u_int32_t;
typedef ULLONG			u_int64_t;
#define weak_alias(a,b)
#define strong_alias(a,b)

#define INFINITYL	(LDBL)(HUGE_VALL)
#define NANL		(LDBL)(0.0L/0.0L)

#define LOGE2L	6.9314718055994530941723E-1L	// log(2)
						// 2^-64
#define MACHEPL 5.42101086242752217003726400434970855712890625E-20L
#define MAXLOGL 1.1356523406294143949492E4L	/* log(MAXNUML) */
#define MAXNUML LDBL_MAX
#define MINLOGL -1.1355137111933024058873E4L	/* log(LDBL_MIN) */

#define PIL	3.1415926535897932384626L	// pi
#define PIO2L	1.5707963267948966192313L	// pi/2
#define PIO4L	7.8539816339744830961566E-1L	// pi/4

#define ROUND_TO_INT(Arg, Retval)	\
    __asm__ __volatile__ ("FRNDINT" : "=t" (Retval) : "0" (Arg))

#define SQRTH	7.07106781186547524401E-1L	// sqrt(.5)
#define SQRT2L	1.41421356237309504880L		// sqrt(2)

#define TWO_31	2147483648.0L			// 2^31
#define TWO_32	4294967296.0L			// 2^32
#define TWO_33	8589934592.0L			// 2^33
#define TWO_34	17179869184.0L			// 2^34
#define TWO_63	(TWO_31*TWO_32)			// 2^63

#include <machine/endian.h>
#include <float.h>
#include <limits.h>

// The following two macros, FP_ILOGB0 and FP_ILOGBNAN,
// expand to integer constant expressions whose values
// are returned by ilogbl(x) if x is zero or NaN,
// respectively. (ISO C99)

#define FP_ILOGB0	INT_MIN
#define FP_ILOGBNAN	INT_MAX

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
/* *INDENT-OFF* */


#define __fp_raise_except(Excepts)		\
{						\
    if (math_errhandling & MATH_ERREXCEPT)	\
    {						\
	feraiseexcept(Excepts); \
    }						\
}
#define __math_set_errno(ErrVal)		\
{						\
    if (math_errhandling & MATH_ERRNO)		\
    {						\
	errno = ErrVal;				\
    }						\
}

int	__set_math_errhandling(int);

int	DlAddDbl(double, double, double, double, double *,double *);
int	DlAddFlt(float, float, float, float, float *,float *);

int	DlAddLdbl(long double, long double, long double, long double,
		  long double *,long double *);

void	MpyUll(ULLONG, ULLONG, ULLONG *, ULLONG *);

int	SlMpyDbl(double, double, double *, double *);
int	SlMpyFlt(float, float, float *, float *);
void	SlMpyLdbl(long double, long double, long double *, long double *);

int	SplitDbl(double, int *, double *, double *);
int	SplitFlt(float, int *, float *, float *);
int	SplitLdbl(long double, int *, long double *, long double *);

long double	_infinityl	(void);
int		isfinited	(double);
int		isfinitef	(float);
int		isfinitel	(long double);
int		isinfd		(double);
int		isinfl		(long double);
int		isnand		(double);
int		isnanl		(long double);
double		_nan		(void);
float		_nanf		(void);
long double	_nanl		(void);
int		signbitd	(double);
int		signbitf	(float);
int		signbitl	(long double);

/* *INDENT-ON* */


/* A union that enables us to convert from a long double
   to three 32-bit ints, or to a 32-bit int and a 64-bit
   long long int.
*/

# if BYTE_ORDER == BIG_ENDIAN

typedef union
{
  LDBL Arg;
  struct
  {
    short Sign_and_Exp:16;
    USHORT Unused:16;
    ULONG Msw_;
    ULONG Lsw_;
  } Parts;
  struct
  {
    short Sign_and_Exp:16;
    USHORT Unused:16;
    ULLONG FracBits;
  } Parts_2;
} LDBL_UNION;

#endif

# if BYTE_ORDER == LITTLE_ENDIAN

typedef union
{
  LDBL Arg;
  struct
  {
    ULONG Lsw_;
    ULONG Msw_;
    short Sign_and_Exp:16;
    USHORT Unused:16;
  } Parts;
  struct
  {
    ULLONG FracBits;
    short Sign_and_Exp:16;
    USHORT Unused:16;
  } Parts_2;
} LDBL_UNION;

#endif

#define COPY_SIGNL(Tgt, To_Arg, From_Arg)			\
do {								\
  ULONG	 Exp_From, Exp_To;					\
  ULLONG FracBits_To;						\
  GET64_LDOUBLE(Exp_To, FracBits_To,  To_Arg);			\
  GET_LDOUBLE_EXP(Exp_From, From_Arg);				\
  SET64_LDOUBLE(Tgt,(Exp_To & 0x7fff)|(Exp_From & 0x8000),	\
	 FracBits_To);						\
   } while (0)

/* Get three 32-bit ints from a long double.  */

#define GET_LDOUBLE_WORDS(Exp,Msw,Lsw,Tgt)			\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Arg = (Tgt);					\
  (Exp) = Tgt_Union.Parts.Sign_and_Exp;				\
  (Msw) = Tgt_Union.Parts.Msw_;					\
  (Lsw) = Tgt_Union.Parts.Lsw_;					\
} while (0)

/* Get Exponent and 64-bit Fraction from long double.  */

#define GET64_LDOUBLE(Exp,Frac,Tgt)				\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Arg = (Tgt);					\
  (Exp)	 = Tgt_Union.Parts_2.Sign_and_Exp;			\
  (Frac) = Tgt_Union.Parts_2.FracBits;				\
} while (0)

/* Set Long Double Using Exponent and 64-bit Fraction */

#define SET64_LDOUBLE(Tgt,Exp,Frac)				\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Parts_2.Sign_and_Exp = (Exp);			\
  Tgt_Union.Parts_2.FracBits	 = (Frac);			\
  (Tgt) = Tgt_Union.Arg;					\
} while (0)

/* Set a double from three 32-bit ints.	 */

#define SET_LDOUBLE_WORDS(Tgt,Exp,Msw,Lsw)			\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Parts.Sign_and_Exp = (Exp);				\
  Tgt_Union.Parts.Msw_ = (Msw);					\
  Tgt_Union.Parts.Lsw_ = (Lsw);					\
  (Tgt) = Tgt_Union.Arg;					\
} while (0)

/* Get the more significant 32 bits of a long double fraction. */

#define GET_LDOUBLE_MSW(Val,Tgt)				\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Arg = (Tgt);					\
  (Val) = Tgt_Union.Parts.Msw_;					\
} while (0)

/* Set the more significant 32 bits of
   a long double fraction from an int.	*/

#define SET_LDOUBLE_MSW(Tgt,Val)				\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Arg = (Tgt);					\
  Tgt_Union.Parts.Msw_ = (Val);					\
  (Tgt) = Tgt_Union.Arg;					\
} while (0)

/* Get exponent of a long double.  */

#define GET_LDOUBLE_EXP(Exp,Tgt)				\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Arg = (Tgt);					\
  (Exp) = Tgt_Union.Parts.Sign_and_Exp;				\
} while (0)

/* Set exponent of a long double.  */

#define SET_LDOUBLE_EXP(Tgt,Exp)				\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Arg = (Tgt);					\
  Tgt_Union.Parts.Sign_and_Exp = (Exp);				\
  (Tgt) = Tgt_Union.Arg;					\
} while (0)

/* Get significand of a long double.  */

#define GET_LDOUBLE_SIG(Sig,Tgt)				\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Arg = (Tgt);					\
  (Sig) = Tgt_Union.Parts_2.FracBits;				\
} while (0)

/* Set significand of a long double.  */

#define SET_LDOUBLE_SIG(Tgt,Sig)				\
do {								\
  LDBL_UNION Tgt_Union;						\
  Tgt_Union.Arg = (Tgt);					\
  Tgt_Union.Parts_2.FracBits = (Sig);				\
  (Tgt) = Tgt_Union.Arg;					\
} while (0)

#ifdef __cplusplus
}
#endif
# endif // FDLIBML_H
