// ------------
// fegetround.c
// ------------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
// Function fegetround()
//
// Synopsis
//
//     #include <fenv.h>
//     int fegetround(void);
//
// Description
//
// Function fegetround() gets the current rounding direction.
//
// Returns
//
// Function fegetround() returns the value of the macro
// representing the current rounding direction.
//

#include <fenv.h>
#include <fdlibml.h>

#define AV	__asm__ __volatile__

typedef struct	CTRL_WRD_STRU
  {
	UINT	Exceptions:6;
	UINT	Unused:2;
	UINT	Precision:2;
	UINT	Rounding:2;
	UINT	InfCtrl:2;
	UINT	Vacant:2;
  }  Fctrl_t;

static int RndCtrl[] =
	{ FE_TONEAREST,
	  FE_DOWNWARD,
	  FE_UPWARD,
	  FE_TOWARDZERO,
	};

int
fegetround (void)
{
    Fctrl_t  CtrlWrd;

    AV ("FSTCW	%0" : "=m" (*&CtrlWrd));

    return RndCtrl[CtrlWrd.Rounding];
}
