// -------------
// feholdexcpt.c
// -------------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
// Function feholdexcept
//
// Synopsis
//
//
//	#include <fenv.h>
//	int feholdexcept(fenv_t *envp);
//
// Description
//
// The feholdexcept function saves the current floating-point
// environment in the object pointed to by envp, clears the
// exception flags, and then installs a non-stop (continue on
// exceptions) mode, if available, for all exceptions.
//
// Returns
//
// The feholdexcept function returns zero if and only if
// non-stop exception handling was successfully installed.

#include <fenv.h>

#define AV	__asm__ __volatile__

#define FE_HOLD_EX(EP)					\
    {							\
	unsigned int NewCtrlWrd;			\
	/* Save environment */				\
	AV ("FSTENV %0" : "=m" (*EP));			\
	/* Clear all exception bits */			\
	AV ("FCLEX");					\
	/* Mask all exceptions */			\
	NewCtrlWrd = EP->Control_Word | FE_ALL_EXCEPT;	\
	/* Load new Control Word */			\
	AV ("FLDCW %0" : : "m" (*&NewCtrlWrd));		\
    }

int
feholdexcept(fenv_t * EnvPtr)
{
    int		 Retval;

    // Must have non-null pointer
    if (EnvPtr)
    {
	Retval = 0;		// No errors
	FE_HOLD_EX(EnvPtr)
    }
    else
    {
	Retval = -1;		// Null memory pointer
    }

    return Retval;
}
