// ------------------------------------------------------------------
// fmaxl.c - returns the maximum numeric value of a pair of arguments
// ------------------------------------------------------------------
//
//  Synopsis:
//
//	#include <math.h>
//
//	long double x, y, z, fmaxl()
//
//	z = fmaxl(x, y);
//
//  If just one argument is a NaN, return the other argument
//  If both arguments are NaNs, return a NaN
//
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, October 2003
//
//
#include <fdlibml.h>

long double  fmaxl(long double x, long double y)
{
    long double    Retval;

    if (isnanl(x) || isnanl(y))
    {
	Retval = isnanl(y) ? x : y;
    }
    else if (x == 0.0L && y == 0.0L)
    {
	int	Sign = signbitl(x);	// extract sign bit
					// return +0 if signs differ
	Retval = (Sign) ? y : x;
    }
    else
    {
	Retval = (x > y) ? x : y;
    }
    return Retval;
}
