/* frexpl.c -- long double version of s_frexp.c.
 * Conversion to long double by KB Williams, kbwms@aol.com
 */

/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

/*
 * For non-zero arg,
 *	x = frexpl(arg,&exp);
 * returns a long double quantity x such that 0.5 <= |x| < 1.0
 * and a corresponding binary exponent "exp" such that
 *	arg = x*2^exp.
 * If arg is 0.0, Inf or NaN, frexpl() returns arg with *exp=0.
 */
#include <fdlibml.h>
#define NORMALIZER  (LDBL)36893488147419103232.0L	/* 2^65 */
# if defined __STDC__
long double frexpl(long double Arg, int *ExpPtr)
# else
long double frexpl(Arg, ExpPtr)
long double Arg;
int    *ExpPtr;
# endif
{
    int	    Base, Exp;
    LDBL    Retval;
    ULLONG  FracBits;
    USHORT  Exp_and_Sign;

    GET64_LDOUBLE(Exp_and_Sign, FracBits, Arg);

    Exp = Exp_and_Sign & 0x7fff;

    if ((FracBits == 0) || (Exp == 0x7fff))
    {					// Zero, Inf, NaN
	Base = 0;
	Retval = Arg;
    }
    else
    {
	if (Exp)			// Normal case
	{
	    Base = 0;
	    Retval = Arg;
	}
	else				// Handle denormal case
	{
	    Retval = Arg * NORMALIZER;
	    GET_LDOUBLE_EXP(Exp_and_Sign, Retval);

	    Exp = Exp_and_Sign & 0x7fff;
	    Base = -65;
	}
	Base += Exp - 0x3ffe;		// Calculate power of two
	Exp_and_Sign &= 0x8000;		// Get original sign bit
	Exp_and_Sign |= 0x3ffe;		// Append final exponent

	SET_LDOUBLE_EXP(Retval, Exp_and_Sign);
    }
    *ExpPtr = Base;
    return Retval;
}

# if defined TEST_FREXP
#include <fdlibml.h>
LDBL	floorl(LDBL);
LDBL	frexpl(LDBL, int *);
#include <stdio.h>
int
main(void)
{
    long double Arg, Retval;
    int	    M;
    unsigned int Exp, Lsw, Msw, ShiftCt;
    ULLONG  FracBits;

    Exp = 0x4040;
    FracBits = (((unsigned long long)1) << 63);

    SET64_LDOUBLE(Arg, Exp, FracBits);
    printf("New Arg	%.1Lf, Exp = %.4hx (%hu), FracBits = %.16Lx\n",
	Arg, (USHORT) Exp & 0x7fff, (USHORT) Exp & 0x7fff, FracBits);

    GET64_LDOUBLE(Exp, FracBits, NORMALIZER);
    printf("NORMALIZER: %.1Lf, Exp = %.4hx (%hu), FracBits = %.16Lx\n",
	Arg, (USHORT) Exp & 0x7fff, (USHORT) Exp & 0x7fff, FracBits);
    Arg = NORMALIZER;
    Retval = frexpl(Arg, &M);
    printf("frexpl: Arg = %.1Lf, Retval = %Lg, M = %d\n",
	Arg, Retval, M);
    Retval = frexpl(Arg = LDBL_MIN/2.0L, &M);
    GET64_LDOUBLE(Exp, FracBits, Arg);
    printf("frexpl: Arg = %.21Lg, Exp = %.4x, FracBits = %.16Lx\n",
    		Arg, Exp, FracBits);
    printf("frexpl: Retval = %Lg, M = %d\n", Retval, M);

    exit(0);
}
# endif
