// -----------
// isfinitd.c
// -----------
#include <fdlibml.h>
// --------------------------------------------------
// isfinited - Returns 1 if Arg is finite and not NaN			
// --------------------------------------------------
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, October 2003

int isfinited(double Arg)
{
    union
    {
	double		D_Arg;
	unsigned short	S_Arg[4];
    }
    SDU;

    SDU.D_Arg = Arg;
    	
    return  ((((SDU.S_Arg[3] & 0x7ff0) - 0x7ff0) >> 15) & 1);
}
