// -----------
// isfinitf.c
// -----------
#include <fdlibml.h>
// --------------------------------------------------
// isfinitef - Returns 1 if Arg is finite and not NaN			
// --------------------------------------------------
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, October 2003

int isfinitef(float Arg)
{
    union
    {
	float		F_Arg;
	unsigned short	S_Arg[2];
    }
    SFU;

    SFU.F_Arg = Arg;

    return  ((((SFU.S_Arg[1] & 0x7f80) - 0x7f80) >> 15) & 1);
}
