/* -------- */
/* ldexpl.c */
/* -------- */
/*
Written for DJGPP/GCC by KB Williams,
kbwms@aol.com, December 2001
*/
/* ldexpl - multiplies a long double floating point
 *	    number by an integral power of 2
 *
 * y = ldexpl( long double x, int n );
 * long double y;
 *
 * ldexpl(x, n) calls scalbnl() to multiply x by 2**n.
 *
 * If overflow, +-Inf is returned, __math_set_errno(ERANGE
 * If underflow, +-0  is returned, __math_set_errno(ERANGE
 */
#include <math.h>
long double ldexpl(long double x, int n)
{
    return scalbnl(x, n);
}
