/* s_logbl.c -- long double version of s_logb.c.
 * Adapted to long double for DJGPP/GNU by KB Williams,
 * kbwms@aol.com, January 2002 & November 2003.
 */

/*
 ====================================================
 Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.

 Developed at SunPro, a Sun Microsystems, Inc. business.
 Permission to use, copy, modify, and distribute this
 software is freely granted, provided that this notice
 is preserved.
 ====================================================
 */
/* The following is excerpted from C99 dated 12/18/1999
 *
 * The logbl(x) functions extract the exponent of x, as a
 * signed integer value in floating-point format. If x is
 * subnormal it is treated as though it were normalized;
 * thus, for positive finite x,
 *
 *  1 <= x * FLT_RADIX^(-logb(x)) < FLT_RADIX
 *
 * A domain error may occur if the argument is zero.
 *
 * logbl(+-Inf) returns +Inf.
 *
 * logbl(+-0) returns -Inf and raises the divide-by-zero
 * exception (when able to do so).
 *
 */


#include <errno.h>
#include <fdlibml.h>
#include <fenv.h>


#ifdef __STDC__
long double
logbl(long double Arg)
#else
long double
logbl(Arg)
long double Arg;
#endif
{
    LDBL    Retval;

    if (!isfinitel(Arg))		/* +-Inf or NaN */
    {
	Retval = Arg*Arg;
    }
    else
    {
	int	ExpBits;
	ULLONG	FracBits;

	GET64_LDOUBLE(ExpBits, FracBits, Arg);

	ExpBits &= 0x7fff;		/* Remove sign bit */

	if (ExpBits == 0)
	{
	    if (FracBits == 0)		/* Arg = 0 */
	    {
		__math_set_errno(ERANGE);
		__fp_raise_except(FE_DIVBYZERO);
		Retval = -HUGE_VALL;
	    }
	    else			/* Arg is subnormal */
	    {
		Retval = (LDBL) (-0x3ffe);
	    }
	}
	else				/* Arg is normal */
	{
	    Retval = (LDBL) (ExpBits - 0x3fff);
	}
    }
    return Retval;
}
