// ------------
// rintl.c
// ------------
//
// From ISO C99:
//
// Function rintl
//
// Synopsis
//
//	#include <math.h>
//	long double rintl(long double x);
//
// Description
//
// Function rintl rounds its argument to an integer value
// in floating-point format, using the current rounding direction.
// Function rintl uses IEC 60559 rounding according to the
// current rounding direction.	It raises the inexact exception
// when the result differs in value from the argument.
//
// Returns
//
// Function rintl returns the rounded integer value.
//
// Remarks
//
// Function rintl differs from the nearbyintl function
// only in that it raises the inexact exception if the
// result differs in value from the argument.
//
// o rintl(+-0) returns +-0 (for all rounding directions).
//
// o rintl(+-Inf) returns +-Inf (for all rounding directions).
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, March 2002
//

#include <fdlibml.h>
#include <fenv.h>

long double rintl(long double Arg)
{
    long double IntVal;

    ROUND_TO_INT(Arg, IntVal);

    return IntVal;
}
