// --------
// roundf.c
// --------
//
// Function roundf
//
// Synopsis
//
//	#include <math.h>
//	float roundf(float x);
//
// Description
//
// Function roundf() rounds its argument to the nearest integer
// value in floating-point format, rounding halfway cases away
// from zero, regardless of the current rounding direction.
//
// Returns
//
// Function roundf() returns the rounded integer value.
//
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, September 2003
//
#include <math.h>

float
roundf(float Arg)
{
    float	FracPart, IntPart;

    FracPart = modff(Arg, &IntPart);

    if (fabsf(FracPart) >= 0.5f)
           IntPart += copysignf(1.0, IntPart);

    return IntPart;
}
