/* ------- */
/* sqrtl.c */
/* ------- */
/* Returns the long double precision square root of its argument */

/*
Written for DJGPP/GCC by KB Williams,
kbwms@aol.com, December 2001
*/

#include <errno.h>
#include <fenv.h>
#include <fdlibml.h>

long double sqrtl(long double Arg)
//
//	   If  Arg < 0 or Arg == -Inf,
//	   Set Retval to NaN, set errno to EDOM
//
{
    long double Retval;

    if (Arg < 0.0L)
    {
	__math_set_errno(EDOM);
	__fp_raise_except(FE_INVALID);
    	Retval = NAN;
    }
    else if (isnanl(Arg))
    {
    	Retval = NAN;
    }
    else
        __asm__ __volatile__ ("FSQRT" : "=t" (Retval) : "0" (Arg));

    return Retval;
}
