// --------
// truncf.c
// --------
//
// Synopsis
//
//      #include <math.h>
//
//	float Retval;
// 	Retval = truncf( float Arg);
//
// Returns integer part of Arg if |Arg| is in (1,2^23-1);
// If |Arg| < 1, zero is returned.
// If |Arg| > 2^23, Arg is returned.
//
// From C99:
//
// The truncf function rounds its argument to its integer
// value, in floating format, nearest to but no larger in
// magnitude than the argument.
//
// The truncf function uses IEC 60559 rounding toward zero
// (regardless of the current rounding direction).
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, October 2003
//
#include <fdlibml.h>
#include <fenv.h>

float truncf(float Arg)
{
    float  Retval;
    int	    CrntRndDir;

    CrntRndDir = fegetround();
    fesetround(FE_TOWARDZERO);

    ROUND_TO_INT(Arg, Retval);

    fesetround(CrntRndDir);

    return Retval;
}
