// --------
// truncl.c
// --------
//
// Synopsis
//
//      #include <math.h>
//
//	long double Retval;
// 	Retval = truncf( long double Arg);
//
// Returns integer part of Arg if |Arg| is in (1,2^64-1);
// If |Arg| < 1, zero is returned.
// If |Arg| > 2^63, Arg is returned.
//
// From C99:
//
// The truncl function rounds its argument to its integer
// value, in floating format, nearest to but no larger in
// magnitude than the argument.
//
// The truncl function uses IEC 60559 rounding toward zero
// (regardless of the current rounding direction).
//
// Written for DJGPP/GCC by KB Williams,
// kbwms@aol.com, July 2003
//
#include <fdlibml.h>
#include <fenv.h>

long double truncl(long double Arg)
{
    LDBL    Retval;
    int	    CrntRndDir;

    CrntRndDir = fegetround();
    fesetround(FE_TOWARDZERO);

    ROUND_TO_INT(Arg, Retval);

    fesetround(CrntRndDir);

    return Retval;
}
