/*							casinf()
 *
 *	Complex circular arc sine
 *
 *
 *
 * SYNOPSIS:
 *
 * void casinf();
 * cmplxf z, w;
 *
 * casinf( &z, &w );
 *
 *
 *
 * DESCRIPTION:
 *
 * Inverse complex sine:
 *
 *                               2
 * w = -i clog( iz + csqrt( 1 - z ) ).
 *
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    IEEE      -10,+10     30000       1.1e-5      1.5e-6
 * Larger relative error can be observed for z near zero.
 *
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>


float   complex
casinf(float complex z)
{
    float complex w;
    float   x, y;
    static float complex ca, ct, zz, z2;

    x = crealf(z);
    y = cimagf(z);

    if (y == 0.0f)
    {
	if (fabsf(x) > 1.0f)
	{
	    w = M_PI_2 + 0.0f * I;
	    // matherr( "casinf", DOMAIN );
	}
	else
	{
	    w = asinf(x) + 0.0f * I;
	}
	return (w);
    }

/* Power series expansion */

    ca = x + y * I;
    ct = ca * I;			/* iz */
    zz = (x - y) * (x + y) + (2.0f * x * y) * I;
    zz = 1.0f - crealf(zz) - cimagf(zz) * I;
    z2 = csqrtf(zz);

    zz = ct + z2;
    zz = clogf(zz);

    /* multiply by 1/i = -i */
    w = zz * (-1.0f * I);

    return (w);
}
