/*	ctanh.c
 *
 *	Complex hyperbolic tangent
 *
 *
 *
 * SYNOPSIS:
 *
 * double complex ctanh();
 * double complex z, w;
 *
 * w = ctanh (z);
 *
 *
 * DESCRIPTION:
 *
 * tanh z = (sinh 2x  +	 i sin 2y) / (cosh 2x + cos 2y) .
 *
 * ACCURACY:
 *
 *			Relative error:
 * arithmetic	domain	   # trials	 peak	      rms
 *    IEEE	-10,+10	    30000	1.7e-14	    2.4e-16
 *
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <float.h>
#include <math.h>


double	complex
ctanh(z)
double complex z;
{
    double complex w;
    double  x, y, d;

    x = creal(z);
    y = cimag(z);
    d = cosh(2.0 * x) + cos(2.0 * y);
    w = sinh(2.0 * x) / d + (sin(2.0 * y) / d) * I;
    return (w);
}
