/*	ctanl()
 *
 *	Complex circular tangent
 *
 *
 *
 * SYNOPSIS:
 *
 * long double complex ctanl();
 * long double complex z, w;
 *
 * w = ctanl( z );
 *
 *
 *
 * DESCRIPTION:
 *
 * If
 *     z = x + iy,
 *
 * then
 *
 *           sin 2x  +  i sinh 2y
 *     w  =  --------------------.
 *            cos 2x  +  cosh 2y
 *
 * On the real axis the denominator is zero at odd multiples
 * of PI/2.  The denominator is evaluated by its Taylor
 * series near these points.
 *
 *
 * ACCURACY:
 *
 *                      Relative error:
 * arithmetic   domain     # trials      peak         rms
 *    DEC       -10,+10      5200       7.1e-17     1.6e-17
 *    IEEE      -10,+10     30000       7.2e-16     1.2e-16
 * Also tested by ctan * ccot = 1 and catan(ctan(z))  =  z.
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


#include "complex.h"
#include <math.h>
#include <float.h>
#include "redupil.c"
#include "ctansl.c"

long double complex
ctanl(long double complex z)
{
    long double complex w;
    long double d, x, y;

    x = creall(z);
    y = cimagl(z);
    d = cosl(2.0L * x) + coshl(2.0L * y);

    if (d && (fabsl(d) < 0.25L))
    {
	d = ctansl(z);
    }
    if (d == 0.0L)
    {
	w = LDBL_MAX + LDBL_MAX * I;
    }
    else
    {		
	w = sinl(2.0L * x) / d + (sinhl(2.0L * y) / d) * I;
    }
    return (w);
}
