// ctansl.c

/*  Taylor series expansion for cosh(2y) - cos(2x)	*/
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/

// Modified for DJGPP/GCC by KB Williams,
// kbwms@aol.com, April 2004


static long double ctansl(long double complex);

static long double
ctansl(long double complex z)
{
    long double f, x, x2, y, y2, rn, t;
    long double d;

    x = fabsl(2.0L * creall(z));
    y = fabsl(2.0L * cimagl(z));

    x = redupil(x);

    x = x * x;
    y = y * y;
    x2 = 1.0L;
    y2 = 1.0L;
    f = 1.0L;
    rn = 0.0L;
    d = 0.0L;
    do
    {
	rn += 1.0L;
	f *= rn;
	rn += 1.0L;
	f *= rn;
	x2 *= x;
	y2 *= y;
	t = y2 + x2;
	t /= f;
	d += t;

	rn += 1.0L;
	f *= rn;
	rn += 1.0L;
	f *= rn;
	x2 *= x;
	y2 *= y;
	t = y2 - x2;
	t /= f;
	d += t;
    }
    while (fabsl(t / d) > LDBL_EPSILON);
    return (d);
}
