Index: strftime.c
===================================================================
RCS file: /cvs/djgpp/djgpp/tests/libc/ansi/time/strftime.c,v
retrieving revision 1.3
diff -p -u -t -r1.3 strftime.c
--- strftime.c	26 May 2002 16:12:46 -0000	1.3
+++ strftime.c	17 Mar 2004 06:48:41 -0000
@@ -11,6 +11,86 @@
 #include <time.h>
 #include <libc/unconst.h>
 
+
+#undef CMP
+#define CMP(Fmt, Expected) n_fail += compare ((Fmt), tm, (Expected))
+
+
+typedef struct  cmp
+{
+    char *fmt;
+    char *expected;
+
+}               cmp;
+
+
+struct cmp      comparisons[] =
+{
+    { "%-m", "1"        },                      /* GNU */
+    { "%A", "Friday"    },      
+    { "%^A", "FRIDAY"   },                      /* GNU */
+    { "%B", "January"   },      
+    { "%^B", "JANUARY"  },      
+    { "%C", "19"        },                      /* POSIX.2 */
+    { "%D", "01/09/70"  },                      /* POSIX.2 */
+    { "%E", "E"         },                      /* C99 */
+    { "%F", "1970-01-09"},                      /* C99 */
+    { "%G", "1970"      },                      /* GNU */
+    { "%H", "13"        },      
+    { "%I", "01"        },      
+    { "%J", "J"         },      
+    { "%K", "K"         },      
+    { "%L", "L"         },      
+    { "%M", "06"        },      
+    { "%N", "N"         },      
+    { "%O", "O"         },                      /* C99 */
+    { "%P", "P"         },      
+    { "%Q", "Q"         },      
+    { "%R", "13:06"     },                      /* POSIX.2 */
+    { "%S", "07"        },      
+    { "%T", "13:06:07"  },                      /* POSIX.2 */
+    { "%U", "01"        },      
+    { "%V", "02"        },      
+    { "%W", "01"        },      
+    { "%X", "13:06:07"  },      
+    { "%Y", "1970"      },      
+    { "%Z", "GMT"       },      
+    { "%_m", " 1"       },                      /* GNU */
+    { "%a", "Fri"       },      
+    { "%^a", "FRI"      },      
+    { "%b", "Jan"       },      
+    { "%^b", "JAN"      },      
+    { "%c", "Fri Jan  9 13:06:07 1970"  },      
+    { "%^c", "FRI JAN  9 13:06:07 1970" },      
+    { "%d", "09"        },      
+    { "%e", " 9"        },                      /* POSIX.2 */
+    { "%f", "f"         },                      /* ISO */
+    { "%g", "70"        },                      /* GNU */
+    { "%h", "Jan"       },                      /* POSIX.2 */
+    { "%^h", "JAN"      },      
+    { "%i", "i"         },      
+    { "%j", "009"       },      
+    { "%k", "13"        },                      /* GNU */
+    { "%l", " 1"        },                      /* GNU */
+    { "%m", "01"        },      
+    { "%n", "\n"        },                      /* POSIX.2 */
+    { "%o", "o"         },      
+    { "%p", "PM"        },      
+    { "%q", "q"         },      
+    { "%r", "01:06:07 PM"},                     /* POSIX.2 */
+    { "%s", "738367"    },                      /* GNU */
+    { "%t", "\t"        },                      /* POSIX.2 */
+    { "%u", "5"         },                      /* POSIX.2 */
+    { "%v", "v"         },      
+    { "%w", "5"         },      
+    { "%x", "01/09/70"  },      
+    { "%y", "70"        },      
+    { "%z", "+0000"     },                      /* GNU */
+    { "%%", "%"         },      
+
+};      /*      comparisons[] */
+
+
 static int
 compare (const char *fmt, const struct tm *tm, const char *expected)
 {
@@ -19,7 +99,8 @@ compare (const char *fmt, const struct t
   if (strcmp (buf, expected))
     {
 #if 1
-      printf ("fmt: \"%s\", expected \"%s\", got \"%s\"\n",
+      printf ("\n fmt: \"%-3s\"  expected: \"%s\" \n"
+                   "                  got: \"%s\" \n",
               fmt, expected, buf);
 #endif
       return 1;
@@ -27,68 +108,24 @@ compare (const char *fmt, const struct t
   return 0;
 }
 
+
 int
 main (void)
 {
-  int n_fail = 0;
-  struct tm *tm;
-  time_t t = 738367; /* Fri Jan  9 13:06:07 1970 */
-  tm = gmtime (&t);
+  struct cmp *  c;
+  int           n_fail  = 0;
+  time_t        t       = 738367; /* Fri Jan  9 13:06:07 1970 */
+  struct tm *   tm      = gmtime (&t);
+  
 
   /* This is necessary to make strftime give consistent zone strings and
      e.g., seconds since the epoch (%s).  */
   putenv (unconst("TZ=GMT0", char *));
 
-#undef CMP
-#define CMP(Fmt, Expected) n_fail += compare ((Fmt), tm, (Expected))
-
-  CMP ("%-m", "1");             /* GNU */
-  CMP ("%A", "Friday");
-  CMP ("%^A", "FRIDAY");        /* The ^ is a GNU extension.  */
-  CMP ("%B", "January");
-  CMP ("%^B", "JANUARY");
-  CMP ("%C", "19");             /* POSIX.2 */
-  CMP ("%D", "01/09/70");       /* POSIX.2 */
-  CMP ("%G", "1970");           /* GNU */
-  CMP ("%H", "13");
-  CMP ("%I", "01");
-  CMP ("%M", "06");
-  CMP ("%M", "06");
-  CMP ("%R", "13:06");          /* POSIX.2 */
-  CMP ("%S", "07");
-  CMP ("%T", "13:06:07");       /* POSIX.2 */
-  CMP ("%U", "01");
-  CMP ("%V", "02");
-  CMP ("%W", "01");
-  CMP ("%X", "13:06:07");
-  CMP ("%Y", "1970");
-  CMP ("%Z", "GMT");
-  CMP ("%_m", " 1");            /* GNU */
-  CMP ("%a", "Fri");
-  CMP ("%^a", "FRI");
-  CMP ("%b", "Jan");
-  CMP ("%^b", "JAN");
-  CMP ("%c", "Fri Jan  9 13:06:07 1970");
-  CMP ("%^c", "FRI JAN  9 13:06:07 1970");
-  CMP ("%d", "09");
-  CMP ("%e", " 9");             /* POSIX.2 */
-  CMP ("%g", "70");             /* GNU */
-  CMP ("%h", "Jan");            /* POSIX.2 */
-  CMP ("%^h", "JAN");
-  CMP ("%j", "009");
-  CMP ("%k", "13");             /* GNU */
-  CMP ("%l", " 1");             /* GNU */
-  CMP ("%m", "01");
-  CMP ("%n", "\n");             /* POSIX.2 */
-  CMP ("%p", "PM");
-  CMP ("%r", "01:06:07 PM");    /* POSIX.2 */
-  CMP ("%s", "738367");         /* GNU */
-  CMP ("%t", "\t");             /* POSIX.2 */
-  CMP ("%u", "5");              /* POSIX.2 */
-  CMP ("%w", "5");
-  CMP ("%x", "01/09/70");
-  CMP ("%y", "70");
-  CMP ("%z", "+0000");          /* GNU */
+  for (c = comparisons; c < comparisons + sizeof comparisons / sizeof *comparisons; ++ c)
+  {
+       CMP( c->fmt, c->expected);
+  }
 
   exit (n_fail ? 1 : 0);
 }
