/* @(#)tstrftm.c	1.0	18 Feb 2004	BWI	*/



#include <errno.h>
#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>



static const struct
{
    const char *	locale;
    const char *	tz;
    const char *	format;
    const char *	text;
    struct tm		tm;
}	tests[] =
/*	locale		tz		format		text		      */
/*					 sec min  hr day mon year wdy ydy dst */
/*							 -1 -1970 0-6 0-* -=+ */
{
/*  1 */ { "C",	"Universal",	"%u %Y-%m-%d %H:%M:%S",	"7 1999-01-31 21:01:10",
					{ 10,  1, 21, 31,  0,  99, 0,  30,-1 }},
/*  2 */ { "C",	"Universal",	"%u %C%y.%b.%e %I.%M %p","7 1999.Feb.28 09.01 PM",
					{ 10,  1, 21, 28,  1,  99, 0,  58,-1 }},
/*  3 */ { "C",	"Universal",	"%w %y/%h %j %k-%M-%S",	"2 00/Feb 060 16-30-46",
					{ 46, 30, 16, 29,  1, 100, 2,  59,-1 }},
/*  4 */ { "C",	"Universal",	"%a %y %B %e %l:%M %p",	"Sat 00 January  1 12:34 PM",
					{ 12, 34, 12,  1,  0, 100, 6,   0,-1 }},
/*  5 */ { "C",	"Universal",	"%A %y-%m-%d %T","Friday 00-03-03 17:41:01",
					{  1, 41, 17,  3,  2, 100, 5,  62,-1 }},
/*  6 */ { "C",	"Universal",	"%W %F %R",	"36 1999-09-09 21:01",
					{ 10,  1, 21,  9,  8,  99, 4, 251,-1 }},
/*  7 */ { "C",	"Universal",	"%U %D %X",	"18 05/02/99 12:34:12",
					{ 12, 34, 12,  2,  4,  99, 1, 121,-1 }},
/*  8 */ { "C",	"Universal",	"%x %t %r",	"05/21/01 \t 09:01:10 PM",
					{ 10,  1, 21, 21,  4, 101, 1, 140,-1 }},
/*  9 */ { "C",	"Universal",	"%c %n",	"Mon May 21 16:30:46 2001 \n",
					{ 46, 30, 16, 21,  4, 101, 1, 140,-1 }},
/* 10 */ { "C",	"Universal",	"%F %T %Z",	"2000-01-05 17:41:01 UTC",
					{  1, 41, 17,  5,  0, 100, 3,   4,-1 }},
/* 11 */ { "C",	"Universal",	"%F %T %z",	"2000-01-05 17:41:01 +0000",
					{  1, 41, 17,  5,  0, 100, 3,   4,-1 }},
/* 12 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"1975-12-29 1976-W01-1 1975-w52-1 1975-u52-1",
					{  0,  0,  0, 29, 11,  75, 0, 362,-1 }},
/* 13 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"1977-01-02 1976-W53-7 1977-w00-7 1977-u01-0",
					{  0,  0,  0,  2,  0,  77, 0,   1,-1 }},
/* 14 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"1999-01-02 1998-W53-6 1999-w00-6 1999-u00-6",
					{  0,  0,  0,  2,  0,  99, 5,   1,-1 }},
/* 15 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"1999-12-27 1999-W52-1 1999-w52-1 1999-u52-1",
					{  0,  0,  0, 27, 11,  99, 0, 360,-1 }},
/* 16 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2000-01-02 1999-W52-7 2000-w00-7 2000-u01-0",
					{  0,  0,  0,  2,  0, 100, 0,   1,-1 }},
/* 17 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2003-12-28 2003-W52-7 2003-w51-7 2003-u52-0",
					{  0,  0,  0, 28, 11, 103, 0, 361,-1 }},
/* 18 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2003-12-29 2004-W01-1 2003-w52-1 2003-u52-1",
					{  0,  0,  0, 29, 11, 103, 0, 362,-1 }},
/* 19 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2003-12-31 2004-W01-3 2003-w52-3 2003-u52-3",
					{  0,  0,  0, 31, 11, 103, 2, 364,-1 }},
/* 20 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2004-01-01 2004-W01-4 2004-w00-4 2004-u00-4",
					{  0,  0,  0,  1,  0, 104, 3,   0,-1 }},
/* 21 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2004-01-04 2004-W01-7 2004-w00-7 2004-u01-0",
					{  0,  0,  0,  4,  0, 104, 0,   3,-1 }},
/* 22 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2004-01-05 2004-W02-1 2004-w01-1 2004-u01-1",
					{  0,  0,  0,  5,  0, 104, 0,   4,-1 }},
/* 23 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2004-12-26 2004-W52-7 2004-w51-7 2004-u52-0",
					{  0,  0,  0, 26, 11, 104, 0, 360,-1 }},
/* 24 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2004-12-27 2004-W53-1 2004-w52-1 2004-u52-1",
					{  0,  0,  0, 27, 11, 104, 0, 361,-1 }},
/* 25 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2004-12-31 2004-W53-5 2004-w52-5 2004-u52-5",
					{  0,  0,  0, 31, 11, 104, 4, 365,-1 }},
/* 26 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2005-01-01 2004-W53-6 2005-w00-6 2005-u00-6",
					{  0,  0,  0,  1,  0, 105, 5,   0,-1 }},
/* 27 */ { "C",	"Universal",	"%F %G-W%V-%u %Y-w%W-%u %Y-u%U-%w",	"2005-01-03 2005-W01-1 2005-w01-1 2005-u01-1",
					{  0,  0,  0,  3,  0, 105, 0,   2,-1 }},
/* 28 */ { "C",	"Universal",	"%F %g-W%V-%u %y-w%W-%u %y-u%U-%w",	"2012-01-01 11-W52-7 12-w00-7 12-u01-0",
					{  0,  0,  0,  1,  0, 112, 0,   0,-1 }},
/* 29 */ { "C",	"Universal",	"%F %g-W%V-%u %y-w%W-%u %y-u%U-%w",	"2012-02-29 12-W09-3 12-w09-3 12-u09-3",
					{  0,  0,  0, 29, 01, 112, 2,  59,-1 }},
/* 30 */ { "C",	"Universal",	"%F %g-W%V-%u %y-w%W-%u %y-u%U-%w",	"2012-12-31 13-W01-1 12-w53-1 12-u53-1",
					{  0,  0,  0, 31, 11, 112, 0, 365,-1 }},
/* 31 */ { "C",	"EST5EDT",	"%c %Z %s W%V w%W u%U", "Fri Oct  1 15:30:34 1993 EDT 749503834 W39 w39 u39",
					{ 34, 30, 15,  1,  9,  93, 5, 273,-1 }},
/* 32 */ { "C",	"Europe/Berlin","%d.%m.%Y %T %Z","01.08.2000 05:06:07 CEST",
					{  7,  6,  5,  1,  7, 100, 0,   0,-1 }},
/* 33 */ { "C",	"Europe/Berlin","%d.%m.%Y %T %z","01.08.2000 05:06:07 +0200",
					{  7,  6,  5,  1,  7, 100, 0,   0,-1 }},
#if       0	/* not yet supported */
/* 34 */ { "ja_JP.EUC-JP","Universal",	"%Y %U %a",	"2001 20 \xb7\xee",
					{  0,  0,  0, 21,  4, 101, 1, 140,-1 }},
/* 35 */ { "ja_JP.EUC-JP","Universal",	"%Y %W %a",	"2001 21 \xb7\xee",
					{  0,  0,  0, 21,  4, 101, 1, 140,-1 }},
/* 36 */ { "ja_JP.EUC-JP","Asia/Tokyo",	"%Y %W %a",	"2001 21 \xb7\xee",
					{  0,  0,  0, 21,  4, 101, 1, 140,-1 }},
					
#endif /* 0 */
};



int
main (int argc, char *argv[])
{
    time_t	tt;
    size_t	t;
    size_t	len		= 0;
    int		rc		= 0;
    int		errs		= 0;
    struct tm	tm		= { 0 };
    char	text[BUFSIZ]	= "";

    for (t = 0; t < sizeof tests / sizeof *tests; ++t)
    {
	errno	= 0;

	if (setlocale( LC_TIME, tests[t].locale) == NULL)
	{
	    if (errno)	perror( "setlocale()" );
	    printf( "test %3d  error %6s  set locale '%s'  category '%s'(%d) \n",
				t + 1, "NULL", tests[t].locale, "LC_TIME", LC_TIME);
	    ++errs;
	    continue;
	}

	if ((rc = setenv( "TZ", tests[t].tz, 1)))
	{
	    if (errno)	perror( "setenv()" );
	    printf( "test %3d  error %6d  set environment '%s' '%s' \n",
			    		t + 1, rc, "TZ", tests[t].tz);
	    ++errs;
	    continue;
	}

	tzset();

	tm	= tests[t].tm;

	if ((tt = mktime( &tm )) == -1)
	{
	    if (errno)	perror( "mktime()" );
	    printf( "test %3d  error %6d  make time "
		    "%04d-%02d-%02d %02d:%02d:%02d j%03d w%01d dst %d \n",
					t + 1, tt,
			tests[t].tm.tm_year + 1900,
			    tests[t].tm.tm_mon + 1,
				tests[t].tm.tm_mday,
				    tests[t].tm.tm_hour,
					tests[t].tm.tm_min,
					    tests[t].tm.tm_sec,
						tests[t].tm.tm_yday + 1,
						    tests[t].tm.tm_wday,
							tests[t].tm.tm_isdst);
	    ++errs;
	    continue;
	}

	if (!(len = strftime( text, sizeof text, tests[t].format, &tm)))
	{
	    if (errno)	perror( "strftime()" );
	    printf( "test %3d  error %6d  time format '%s' \n",
					t + 1, len, tests[t].format);
	    ++errs;
	    continue;
	}

	if (strlen( tests[t].text ) != strlen( text )
			|| strcmp( tests[t].text, text))
	{
	    printf( "\n test %3d  error %6s  expected '%s' \n"
		   "                           actual '%s' \n",
				t + 1, "FAILED", tests[t].text, text);
	    ++errs;
	    continue;
	}
    }

    if (errs)
    {
	printf( "tests %2d  errors %5d  passed %d \n",
			sizeof tests / sizeof *tests,
				errs,
					sizeof tests / sizeof *tests - errs);
    }

    return errs;

} /* main() */

