Index: strftime.c
===================================================================
RCS file: /cvs/djgpp/djgpp/zoneinfo/src/strftime.c,v
retrieving revision 1.2
diff -p -u -t -r1.2 strftime.c
--- strftime.c	28 May 1998 16:56:10 -0000	1.2
+++ strftime.c	17 Mar 2004 06:43:26 -0000
@@ -1,6 +1,6 @@
 #ifndef lint
 #ifndef NOID
-static char     elsieid[] = "@(#)strftime.c     7.57";
+static char     elsieid[] = "@(#)strftime.c     7.62";
 /*
 ** Based on the UCB version with the ID appearing below.
 ** This is ANSIish only when "multibyte character == plain character".
@@ -80,24 +80,21 @@ static const struct lc_time_T	C_time_loc
 
         /*
         ** x_fmt
-        ** Since the C language standard calls for
-        ** "date, using locale's date format," anything goes.
+        ** C99 requires this format.
         ** Using just numbers (as here) makes Quakers happier;
         ** it's also compatible with SVR4.
-        **
-        ** XXX--might it be better to use the year-2000 friendly
-        **      %Y-%m-%d
-        ** here?
         */
         "%m/%d/%y",
 
         /*
         ** c_fmt
+        ** C99 requires this format.
+        ** Previously this code used "%D %X", but we now conform to C99.
         ** Note that
-        **      "%a %b %d %H:%M:%S %Y"
+        **      "%a %b %d %H:%M:%S %Y"
         ** is used by Solaris 2.3.
         */
-        "%D %X",        /* %m/%d/%y %H:%M:%S */
+        "%a %b %e %T %Y",
 
         /* am */
         "AM",
@@ -236,20 +233,21 @@ label:
                         case 'E':
                         case 'O':
                                 /*
-                                ** POSIX locale extensions, a la
-                                ** Arnold Robbins' strftime version 3.0.
+                                ** C99 locale modifiers.
                                 ** The sequences
-                                **      %Ec %EC %Ex %Ey %EY
+                                **      %Ec %EC %Ex %EX %Ey %EY
                                 **      %Od %oe %OH %OI %Om %OM
                                 **      %OS %Ou %OU %OV %Ow %OW %Oy
                                 ** are supposed to provide alternate
                                 ** representations.
-                                ** (ado, 1993-05-24)
                                 */
                                 goto label;
                         case 'e':
                                 pt = _conv(t->tm_mday, "%2d", pt, ptlim);
                                 continue;
+                        case 'F':
+                                pt = _fmt("%Y-%m-%d", t, pt, ptlim, warnp);
+                                continue;
                         case 'H':
                                 pt = _conv(t->tm_hour, "%02d", pt, ptlim);
                                 continue;
@@ -492,10 +490,66 @@ label:
                                         pt = _add(t->TM_ZONE, pt, ptlim);
                                 else
 #endif /* defined TM_ZONE */
-                                if (t->tm_isdst == 0 || t->tm_isdst == 1) {
-                                        pt = _add(tzname[t->tm_isdst],
+                                if (t->tm_isdst >= 0)
+                                        pt = _add(tzname[t->tm_isdst != 0],
                                                 pt, ptlim);
-                                } else  pt = _add("?", pt, ptlim);
+                                /*
+                                ** C99 says that %Z must be replaced by the
+                                ** empty string if the time zone is not
+                                ** determinable.
+                                */
+                                continue;
+                        case 'z':
+                                {
+                                int             diff;
+                                char const *    sign;
+
+                                if (t->tm_isdst < 0)
+                                        continue;
+#ifdef TM_GMTOFF
+                                diff = t->TM_GMTOFF;
+#else /* !defined TM_GMTOFF */
+                                /*
+                                ** C99 says that the UTC offset must
+                                ** be computed by looking only at
+                                ** tm_isdst.  This requirement is
+                                ** incorrect, since it means the code
+                                ** must rely on magic (in this case
+                                ** altzone and timezone), and the
+                                ** magic might not have the correct
+                                ** offset.  Doing things correctly is
+                                ** tricky and requires disobeying C99;
+                                ** see GNU C strftime for details.
+                                ** For now, punt and conform to the
+                                ** standard, even though it's incorrect.
+                                **
+                                ** C99 says that %z must be replaced by the
+                                ** empty string if the time zone is not
+                                ** determinable, so output nothing if the
+                                ** appropriate variables are not available.
+                                */
+                                if (t->tm_isdst == 0)
+#ifdef USG_COMPAT
+                                        diff = -timezone;
+#else /* defined USG_COMPAT */
+                                        continue;
+#endif /* !defined USG_COMPAT */
+                                else
+#ifdef ALTZONE
+                                        diff = -altzone;
+#else /* !defined ALTZONE */
+                                        continue;
+#endif /* !defined ALTZONE */
+#endif /* !defined TM_GMTOFF */
+                                if (diff < 0) {
+                                        sign = "-";
+                                        diff = -diff;
+                                } else  sign = "+";
+                                pt = _add(sign, pt, ptlim);
+                                diff /= 60;
+                                pt = _conv((diff/60)*100 + diff%60,
+                                        "%04d", pt, ptlim);
+                                }
                                 continue;
                         case '+':
                                 pt = _fmt(Locale->date_fmt, t, pt, ptlim,
@@ -503,10 +557,10 @@ label:
                                 continue;
                         case '%':
                         /*
-                         * X311J/88-090 (4.12.3.5): if conversion char is
-                         * undefined, behavior is undefined.  Print out the
-                         * character itself as printf(3) also does.
-                         */
+                        ** X311J/88-090 (4.12.3.5): if conversion char is
+                        ** undefined, behavior is undefined.  Print out the
+                        ** character itself as printf(3) also does.
+                        */
                         default:
                                 break;
                         }
