--- setlocal.c	2002-07-17 02:16:36.000000000 -0600
+++ setlocal.c	2004-02-24 01:57:18.000000000 -0700
@@ -465,15 +465,17 @@ setlocale(int category, const char *loca
         if (locale[0] == '\0')
         {
           const char *env;
-          if ((env = getenv ("LANG")) != NULL)
+          if ((env = getenv (cat[i].env)) != NULL)
           {
             locale = env;
           }
-          if ((env = getenv (cat[i].env)) != NULL)
+          else
+          if ((env = getenv ("LC_ALL")) != NULL)
           {
             locale = env;
           }
-          if ((env = getenv ("LC_ALL")) != NULL)
+          else
+          if ((env = getenv ("LANG")) != NULL)
           {
             locale = env;
           }
@@ -481,7 +483,10 @@ setlocale(int category, const char *loca
         if ((stricmp(locale, "C") == 0) || (stricmp(locale, "POSIX") == 0))
         {
           if (cat[i].reset() == 0)
+          {
             honored = 0;
+            continue;
+          }
         }
         else
         {
@@ -559,10 +564,10 @@ setlocale(int category, const char *loca
             honored = 0;
             continue;
           }
-
-          strncpy(lc_current[i], locale, LC_MAXNAMESIZE);
-          lc_current[i][LC_MAXNAMESIZE - 1] = '\0';
         }
+
+        strncpy(lc_current[i], locale, LC_MAXNAMESIZE);
+        lc_current[i][LC_MAXNAMESIZE - 1] = '\0';
       }
     }
     if (segment != -1)
@@ -607,8 +612,8 @@ setlocale(int category, const char *loca
 #include <stdio.h>
 
 unsigned char __dj_collate_table[256];
-char __dj_date_format[10] = "%m/%d/%y";
-char __dj_time_format[16] = "%H:%M:%S";
+extern char __dj_date_format[10];
+extern char __dj_time_format[16];
 
 int
 main(int ac, char *av[])
