#! /bin/sh
version=4.7.1

ver1=$(echo $version | sed -e 's:\.::g')
mft=gcc${ver1}s2.mft

#
#  Make diffs are in Unix text format
#
dtou $(find diffs -type f); 
dtou unpack-gcc.sh

#
#  Collect names of files to package into
#  djcross-gcc-$version.tar.bz2
#
rm -f $mft
echo mk-gcc47s2-zip.sh >>$mft
echo unpack-gcc.sh >>$mft
echo djcross-gcc-4.7.spec >>$mft
find diffs -type f -a -not -name '*~*' -a -not -name '*.diff.*' >>$mft
find diffs2 -type f -a -not -name '*~*' -a -not -name '*.diff.*' >>$mft

#
#  Copy required files into temporary directory for
#  creating source package
#
rm -rf djcross-gcc-${version}
mkdir -p djcross-gcc-${version}
tar c $(cat gcc${ver1}s2.mft) | ( cd djcross-gcc-${version} && tar x )

#
#  Create djcross-gcc-$version.tar.bz2
#
tar cjvf djcross-gcc-${version}.tar.bz2 djcross-gcc-${version}/

#
#  Remove temporary directories and files
#
rm -rf djcross-gcc-${version}
rm -f $mft

