/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// created on : 17 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 02 august 2007, Siracusa, Jean Michel Sellier

// This subroutine saves the computed electric field in VTK format file

// The electrostatic potential is described in micron
// the potential is saved on the nodes of the mesh

// The electric field components are described in V/micron
// The Ex, Ey and Ez component are saved on the nodes of the mesh

void save_VTK(int num)
{
 int i;
 FILE *fp;
 char s[200];

 printf("Saving the VTK format files... num = %d\n",num);

// potential field
 sprintf(s,"potential/VTK_format/potential%d.vtk",num);
 if(num<100) sprintf(s,"potential/VTK_format/potential0%d.vtk",num);
 if(num<10)  sprintf(s,"potential/VTK_format/potential00%d.vtk",num);

 fp=fopen(s,"w");
 fprintf(fp,"# vtk DataFile Version 2.0\n");
 fprintf(fp,"potential field on every node of the mesh (scalar in Volt)\n");
 fprintf(fp,"ASCII\n");
 fprintf(fp,"DATASET UNSTRUCTURED_GRID\n");
 fprintf(fp,"POINTS %d float\n",Ng);
 for(i=0;i<Ng;i++) fprintf(fp,"%g %g %g\n",coord[0][i]*1.e6,
                                           coord[1][i]*1.e6,coord[2][i]*1.e6);
 fprintf(fp,"CELLS %d %d\n",Ne,Ne*5);
 for(i=0;i<Ne;i++) fprintf(fp,"4 %d %d %d %d\n",noeud_geo[0][i]-1,
                                                noeud_geo[1][i]-1,
                                                noeud_geo[2][i]-1,
                                                noeud_geo[3][i]-1);
 fprintf(fp,"CELL_TYPES %d\n",Ne);
 for(i=0;i<Ne;i++) fprintf(fp,"10\n");
 fprintf(fp,"POINT_DATA %d\n",Ng);
 fprintf(fp,"SCALARS potential double 1\n");
 fprintf(fp,"LOOKUP_TABLE default\n");
 for(i=0;i<Ng;i++) fprintf(fp,"%g\n",V[i]);
 fclose(fp);

// electric field (vector)
 sprintf(s,"E/VTK_format/Efield%d.vtk",num);
 if(num<100) sprintf(s,"E/VTK_format/Efield0%d.vtk",num);
 if(num<10)  sprintf(s,"E/VTK_format/Efield00%d.vtk",num);

 fp=fopen(s,"w");
 fprintf(fp,"# vtk DataFile Version 2.0\n");
 fprintf(fp,"potential field on every node of the mesh (scalar in Volt)\n");
 fprintf(fp,"ASCII\n");
 fprintf(fp,"DATASET UNSTRUCTURED_GRID\n");
 fprintf(fp,"POINTS %d float\n",Ng);
 for(i=0;i<Ng;i++) fprintf(fp,"%g %g %g\n",coord[0][i]*1.e6,
                                           coord[1][i]*1.e6,coord[2][i]*1.e6);
 fprintf(fp,"CELLS %d %d\n",Ne,Ne*5);
 for(i=0;i<Ne;i++) fprintf(fp,"4 %d %d %d %d\n",noeud_geo[0][i]-1,
                                                noeud_geo[1][i]-1,
                                                noeud_geo[2][i]-1,
                                                noeud_geo[3][i]-1);
 fprintf(fp,"CELL_TYPES %d\n",Ne);
 for(i=0;i<Ne;i++) fprintf(fp,"10\n");
 fprintf(fp,"POINT_DATA %d\n",Ng);
 fprintf(fp,"VECTORS electric_field double\n");
 for(i=0;i<Ng;i++) fprintf(fp,"%g %g %g\n",Ex[i],Ey[i],Ez[i]);
 fclose(fp);

// electron density
 sprintf(s,"e_density/VTK_format/e_density%d.vtk",num);
 if(num<100) sprintf(s,"e_density/VTK_format/e_density0%d.vtk",num);
 if(num<10)  sprintf(s,"e_density/VTK_format/e_density00%d.vtk",num);

 fp=fopen(s,"w");
 fprintf(fp,"# vtk DataFile Version 2.0\n");
 fprintf(fp,"potential field on every node of the mesh (scalar in Volt)\n");
 fprintf(fp,"ASCII\n");
 fprintf(fp,"DATASET UNSTRUCTURED_GRID\n");
 fprintf(fp,"POINTS %d float\n",Ng);
 for(i=0;i<Ng;i++) fprintf(fp,"%g %g %g\n",coord[0][i]*1.e6,
                                           coord[1][i]*1.e6,coord[2][i]*1.e6);
 fprintf(fp,"CELLS %d %d\n",Ne,Ne*5);
 for(i=0;i<Ne;i++) fprintf(fp,"4 %d %d %d %d\n",noeud_geo[0][i]-1,
                                                noeud_geo[1][i]-1,
                                                noeud_geo[2][i]-1,
                                                noeud_geo[3][i]-1);
 fprintf(fp,"CELL_TYPES %d\n",Ne);
 for(i=0;i<Ne;i++) fprintf(fp,"10\n");
 fprintf(fp,"POINT_DATA %d\n",Ng);
 fprintf(fp,"SCALARS electron_density double 1\n");
 fprintf(fp,"LOOKUP_TABLE default\n");
 for(i=0;i<Ng;i++) fprintf(fp,"%g\n",NE[i]); // electron density in 1/m^3
 fclose(fp);
 
 if((it==number_of_steps-1) || (it==number_of_steps)){
// electron velocity (vector)
   sprintf(s,"e_velocity/VTK_format/e_velocity%d.vtk",num);
   if(num<100) sprintf(s,"e_velocity/VTK_format/e_velocity0%d.vtk",num);
   if(num<10)  sprintf(s,"e_velocity/VTK_format/e_velocity00%d.vtk",num);

   fp=fopen(s,"w");
   fprintf(fp,"# vtk DataFile Version 2.0\n");
   fprintf(fp,"velocity field on every node of the mesh (vector)\n");
   fprintf(fp,"ASCII\n");
   fprintf(fp,"DATASET UNSTRUCTURED_GRID\n");
   fprintf(fp,"POINTS %d float\n",Ng);
   for(i=0;i<Ng;i++) fprintf(fp,"%g %g %g\n",coord[0][i]*1.e6,
                                             coord[1][i]*1.e6,coord[2][i]*1.e6);
   fprintf(fp,"CELLS %d %d\n",Ne,Ne*5);
   for(i=0;i<Ne;i++) fprintf(fp,"4 %d %d %d %d\n",noeud_geo[0][i]-1,
                                                  noeud_geo[1][i]-1,
                                                  noeud_geo[2][i]-1,
                                                  noeud_geo[3][i]-1);
   fprintf(fp,"CELL_TYPES %d\n",Ne);
   for(i=0;i<Ne;i++) fprintf(fp,"10\n");
   fprintf(fp,"POINT_DATA %d\n",Ng);
   fprintf(fp,"VECTORS electron_velocity double\n");
   for(i=0;i<Ng;i++) fprintf(fp,"%g %g %g\n",XVEL[i]/((double)MEAN),
                                             YVEL[i]/((double)MEAN),
                                             ZVEL[i]/((double)MEAN));
   fclose(fp);

// electron current (vector)
   sprintf(s,"e_current/VTK_format/e_current%d.vtk",num);
   if(num<100) sprintf(s,"e_current/VTK_format/e_current0%d.vtk",num);
   if(num<10)  sprintf(s,"e_current/VTK_format/e_current00%d.vtk",num);

   fp=fopen(s,"w");
   fprintf(fp,"# vtk DataFile Version 2.0\n");
   fprintf(fp,"currents field on every node of the mesh (vector)\n");
   fprintf(fp,"ASCII\n");
   fprintf(fp,"DATASET UNSTRUCTURED_GRID\n");
   fprintf(fp,"POINTS %d float\n",Ng);
   for(i=0;i<Ng;i++) fprintf(fp,"%g %g %g\n",coord[0][i]*1.e6,
                                             coord[1][i]*1.e6,coord[2][i]*1.e6);
   fprintf(fp,"CELLS %d %d\n",Ne,Ne*5);
   for(i=0;i<Ne;i++) fprintf(fp,"4 %d %d %d %d\n",noeud_geo[0][i]-1,
                                                  noeud_geo[1][i]-1,
                                                  noeud_geo[2][i]-1,
                                                  noeud_geo[3][i]-1);
   fprintf(fp,"CELL_TYPES %d\n",Ne);
   for(i=0;i<Ne;i++) fprintf(fp,"10\n");
   fprintf(fp,"POINT_DATA %d\n",Ng);
   fprintf(fp,"VECTORS electron_velocity double\n");
   for(i=0;i<Ng;i++) fprintf(fp,"%g %g %g\n",-Q*NE[i]*XVEL[i]/((double)MEAN),
                                             -Q*NE[i]*YVEL[i]/((double)MEAN),
                                             -Q*NE[i]*ZVEL[i]/((double)MEAN));
   fclose(fp);

// electron energy
   sprintf(s,"e_energy/VTK_format/e_energy%d.vtk",num);
   if(num<100) sprintf(s,"e_energy/VTK_format/e_energy0%d.vtk",num);
   if(num<10)  sprintf(s,"e_energy/VTK_format/e_energy00%d.vtk",num);

   fp=fopen(s,"w");
   fprintf(fp,"# vtk DataFile Version 2.0\n");
   fprintf(fp,"potential field on every node of the mesh (scalar in Volt)\n");
   fprintf(fp,"ASCII\n");
   fprintf(fp,"DATASET UNSTRUCTURED_GRID\n");
   fprintf(fp,"POINTS %d float\n",Ng);
   for(i=0;i<Ng;i++) fprintf(fp,"%g %g %g\n",coord[0][i]*1.e6,
                                             coord[1][i]*1.e6,coord[2][i]*1.e6);
   fprintf(fp,"CELLS %d %d\n",Ne,Ne*5);
   for(i=0;i<Ne;i++) fprintf(fp,"4 %d %d %d %d\n",noeud_geo[0][i]-1,
                                                  noeud_geo[1][i]-1,
                                                  noeud_geo[2][i]-1,
                                                  noeud_geo[3][i]-1);
   fprintf(fp,"CELL_TYPES %d\n",Ne);
   for(i=0;i<Ne;i++) fprintf(fp,"10\n");
   fprintf(fp,"POINT_DATA %d\n",Ng);
   fprintf(fp,"SCALARS electron_energy double 1\n");
   fprintf(fp,"LOOKUP_TABLE default\n");
   for(i=0;i<Ng;i++) fprintf(fp,"%g\n",ENEL[i]/((double)MEAN));
   fclose(fp);
 }
}

