/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 15 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 02 august 2007, Siracusa, Jean Michel Sellier

// calculate the electron velocity by means of a modified
// version of the well-known cloud in cell algorithm.

void electron_velocity(void)
{
 int i, n, iv, el;
 double *vertex;
 double *c;
 double *aux;
 double *dum;
 double ksquared;
 double xvelocity;
 double yvelocity;
 double zvelocity;
 double thesquareroot;
 double superparticle_energy;
 
 dum=malloc((Ng+1)*sizeof(double));
 vertex=malloc((Ne+1)*sizeof(double));
 aux=malloc((Ne+1)*sizeof(double));
 c=malloc((Ng+1)*sizeof(double));
 if(vertex==NULL || aux==NULL || c==NULL || dum==NULL){
   printf("electron_velocity : not enough memory in allocating arrays.\n");
   system("PAUSE");
   exit(0);
 }
 // just in case...
 for(i=0;i<Ne;i++){
    aux[i]=0.;
    vertex[i]=0.;
 }

// x-component velocity 
// ====================
 for(n=1;n<=INUM;n++){
  iv=(int)(P[n][0]);
  el=(int)(P[n][9]);
  ksquared=P[n][1]*P[n][1]+P[n][2]*P[n][2]+P[n][3]*P[n][3];
  thesquareroot=sqrt(1.+4.*alphaK[i_dom[el]][iv]*HHM[i_dom[el]][iv]*ksquared);
  xvelocity=P[n][1]*HM[i_dom[el]][iv]/thesquareroot;
  vertex[el]+=1.;
  aux[el]+=xvelocity;
 }

// Mean Value of the macroscopic variables
// =======================================
 for(i=0;i<Ne;i++) if(vertex[i]!=0.) aux[i]/=vertex[i];
 for(i=0;i<Ng;i++){ c[i]=0.; dum[i]=0.;}
 for(i=0;i<Ne;i++){
   int j;
   for(j=0;j<4;j++){
     dum[noeud_geo[j][i]-1]+=aux[i];
     c[noeud_geo[j][i]-1]+=1.;
   }
 }
 for(i=0;i<Ng;i++) dum[i]/=c[i];
 for(i=0;i<Ng;i++) XVEL[i]+=dum[i];

// y-component velocity
// ====================
 for(i=0;i<Ne;i++){
    aux[i]=0.;
    vertex[i]=0.;
 }
 for(n=1;n<=INUM;n++){
  iv=(int)(P[n][0]);
  el=(int)(P[n][9]);
  ksquared=P[n][1]*P[n][1]+P[n][2]*P[n][2]+P[n][3]*P[n][3];
  thesquareroot=sqrt(1.+4.*alphaK[i_dom[el]][iv]*HHM[i_dom[el]][iv]*ksquared);
  yvelocity=P[n][2]*HM[i_dom[el]][iv]/thesquareroot;
  vertex[el]+=1.;
  aux[el]+=yvelocity;
 }

// Mean Value of the macroscopic variables
// =======================================
 for(i=0;i<Ne;i++) if(vertex[i]!=0.) aux[i]/=vertex[i];
 for(i=0;i<Ng;i++){ c[i]=0.; dum[i]=0.;}
 for(i=0;i<Ne;i++){
   int j;
   for(j=0;j<4;j++){
     dum[noeud_geo[j][i]-1]+=aux[i];
     c[noeud_geo[j][i]-1]+=1.;
   }
 }
 for(i=0;i<Ng;i++) dum[i]/=c[i];
 for(i=0;i<Ng;i++) YVEL[i]+=dum[i];


// z-component velocity
// ====================
 for(i=0;i<Ne;i++){
    aux[i]=0.;
    vertex[i]=0.;
 }
 for(n=1;n<=INUM;n++){
  iv=(int)(P[n][0]);
  el=(int)(P[n][9]);
  ksquared=P[n][1]*P[n][1]+P[n][2]*P[n][2]+P[n][3]*P[n][3];
  thesquareroot=sqrt(1.+4.*alphaK[i_dom[el]][iv]*HHM[i_dom[el]][iv]*ksquared);
  zvelocity=P[n][3]*HM[i_dom[el]][iv]/thesquareroot;
  vertex[el]+=1.;
  aux[el]+=zvelocity;
 }

// Mean Value of the macroscopic variables
// =======================================
 for(i=0;i<Ne;i++) if(vertex[i]!=0.) aux[i]/=vertex[i];
 for(i=0;i<Ng;i++){ c[i]=0.; dum[i]=0.;}
 for(i=0;i<Ne;i++){
   int j;
   for(j=0;j<4;j++){
     dum[noeud_geo[j][i]-1]+=aux[i];
     c[noeud_geo[j][i]-1]+=1.;
   }
 }
 for(i=0;i<Ng;i++) dum[i]/=c[i];
 for(i=0;i<Ng;i++) ZVEL[i]+=dum[i];

// electron energy
// ===============
 for(i=0;i<Ne;i++){
    aux[i]=0.;
    vertex[i]=0.;
 }
 for(n=1;n<=INUM;n++){
  iv=(int)(P[n][0]);
  el=(int)(P[n][9]);
  ksquared=P[n][1]*P[n][1]+P[n][2]*P[n][2]+P[n][3]*P[n][3];
  thesquareroot=sqrt(1.+4.*alphaK[i_dom[el]][iv]*HHM[i_dom[el]][iv]*ksquared);
  superparticle_energy=(thesquareroot-1.)/(2.*alphaK[i_dom[el]][iv]);
  if(iv==2) superparticle_energy+=EG[i_dom[el]];
  vertex[el]+=1.;
  aux[el]+=superparticle_energy;
  if(iv==2) aux[el] += EG[i_dom[el]];
 }

// Mean Value of the macroscopic variables
// =======================================
 for(i=0;i<Ne;i++) if(vertex[i]!=0.) aux[i]/=vertex[i];
 for(i=0;i<Ng;i++){ c[i]=0.; dum[i]=0.;}
 for(i=0;i<Ne;i++){
   int j;
   for(j=0;j<4;j++){
     dum[noeud_geo[j][i]-1]+=aux[i];
     c[noeud_geo[j][i]-1]+=1.;
   }
 }
 for(i=0;i<Ng;i++) dum[i]/=c[i];
 for(i=0;i<Ng;i++) ENEL[i]+=dum[i];

 free(c);
 free(aux);
 free(vertex);
 free(dum);
}
