/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 06 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 07 june 2007, Siracusa, Jean Michel Sellier

// Multiply the transpose of a matrix in row-index sparse storage arrays sa 
// and ija by a vector x[1..n], giving a vector b[1..n]

void dsprstx(double xx[], double bb[], int n)
{
 int i,j,k;

 if(ija[1]!=n+2){
    printf("dsprstx error : mismatched vector and matrix!");
    exit(0);
 }
 for(i=1;i<=n;i++) bb[i]=sa[i]*xx[i];
 for(i=1;i<=n;i++){
    for(k=ija[i];k<=ija[i+1]-1;k++){ // loop over off-diagonal terms
      j=ija[k];
      bb[j]+=sa[k]*xx[i];
    }
 }
}
