/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Last modified : 02 august 2007, Siracusa, Jean Michel Sellier

// This subroutine saves the computed electric field in a BB format file

// The electrostatic potential is described in micron
// the potential is saved on the nodes of the mesh

// The electric field components are described in V/micron
// The Ex, Ey and Ez component are saved on the nodes of the mesh

void save_BB(int num)
{
// created on 31 may 2005, Siracusa, J.M.Sellier
 int i;
 FILE *fp;
 char s[200];

 printf("Saving the BB format files... num = %d\n",num);

 sprintf(s,"potential/BB_mesh_format/potential%d.bb",num);
 if(num<100) sprintf(s,"potential/BB_mesh_format/potential0%d.bb",num);
 if(num<10)  sprintf(s,"potential/BB_mesh_format/potential00%d.bb",num);

 fp=fopen(s,"w");
 fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
 for(i=0;i<Ng;i++){
//  VecGetValues(u,1,&i,y);
  fprintf(fp,"%g\n",V[i]); // the potential is in Volts
//  printf("%d %g\n",i,V[i]);
 }
 fclose(fp);
 
 sprintf(s,"E/Ex_BB_mesh_format/Ex%d.bb",num);
 if(num<100) sprintf(s,"E/Ex_BB_mesh_format/Ex0%d.bb",num);
 if(num<10)  sprintf(s,"E/Ex_BB_mesh_format/Ex00%d.bb",num);

 fp=fopen(s,"w");
 fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
 for(i=0;i<Ng;i++){
  fprintf(fp,"%g\n",Ex[i]); // the potential is in Volts/meter
 }
 fclose(fp);
 
 sprintf(s,"E/Ey_BB_mesh_format/Ey%d.bb",num);
 if(num<100) sprintf(s,"E/Ey_BB_mesh_format/Ey0%d.bb",num);
 if(num<10)  sprintf(s,"E/Ey_BB_mesh_format/Ey00%d.bb",num);

 fp=fopen(s,"w");
 fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
 for(i=0;i<Ng;i++){
  fprintf(fp,"%g\n",Ey[i]); // the potential is in Volts/meter
 }
 fclose(fp);
 
 sprintf(s,"E/Ez_BB_mesh_format/Ez%d.bb",num);
 if(num<100) sprintf(s,"E/Ez_BB_mesh_format/Ez0%d.bb",num);
 if(num<10)  sprintf(s,"E/Ez_BB_mesh_format/Ez00%d.bb",num);

 fp=fopen(s,"w");
 fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
 for(i=0;i<Ng;i++){
  fprintf(fp,"%g\n",Ez[i]); // the potential is in Volts/meter
 }
 fclose(fp);
 
 sprintf(s,"e_density/BB_mesh_format/e_density%d.bb",num);
 if(num<100) sprintf(s,"e_density/BB_mesh_format/e_density0%d.bb",num);
 if(num<10)  sprintf(s,"e_density/BB_mesh_format/e_density00%d.bb",num);

 fp=fopen(s,"w"); 
 fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
 for(i=0;i<Ng;i++){
  fprintf(fp,"%g\n",NE[i]); // electron density in 1/m^3
 }
 fclose(fp);
 
 if((it==number_of_steps-1) || (it==number_of_steps)){
   sprintf(s,"e_velocity/xvel_BB_mesh_format/xvel%d.bb",num);
   if(num<100) sprintf(s,"e_velocity/xvel_BB_mesh_format/xvel0%d.bb",num);
   if(num<10)  sprintf(s,"e_velocity/xvel_BB_mesh_format/xvel00%d.bb",num);

   fp=fopen(s,"w");
   fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
   for(i=0;i<Ng;i++){
    fprintf(fp,"%g\n",XVEL[i]/((double)MEAN));
   }
   fclose(fp);

   sprintf(s,"e_velocity/yvel_BB_mesh_format/yvel%d.bb",num);
   if(num<100) sprintf(s,"e_velocity/yvel_BB_mesh_format/yvel0%d.bb",num);
   if(num<10)  sprintf(s,"e_velocity/yvel_BB_mesh_format/yvel00%d.bb",num);

   fp=fopen(s,"w");
   fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
   for(i=0;i<Ng;i++){
    fprintf(fp,"%g\n",YVEL[i]/((double)MEAN)); // the potential is in Volts/meter
   }
   fclose(fp);

   sprintf(s,"e_velocity/zvel_BB_mesh_format/zvel%d.bb",num);
   if(num<100) sprintf(s,"e_velocity/zvel_BB_mesh_format/zvel0%d.bb",num);
   if(num<10)  sprintf(s,"e_velocity/zvel_BB_mesh_format/zvel00%d.bb",num);

   fp=fopen(s,"w");
   fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
   for(i=0;i<Ng;i++){
    fprintf(fp,"%g\n",ZVEL[i]/((double)MEAN)); // the potential is in Volts/meter
   }
   fclose(fp);
// ***
   sprintf(s,"e_current/e_current_x_BB_mesh_format/xcurr%d.bb",num);
   if(num<100) sprintf(s,"e_current/e_current_x_BB_mesh_format/xcurr0%d.bb",num);
   if(num<10)  sprintf(s,"e_current/e_current_x_BB_mesh_format/xcurr00%d.bb",num);

   fp=fopen(s,"w");
   fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
   for(i=0;i<Ng;i++){
    fprintf(fp,"%g\n",-Q*NE[i]*XVEL[i]/((double)MEAN));
   }
   fclose(fp);

   sprintf(s,"e_current/e_current_y_BB_mesh_format/ycurr%d.bb",num);
   if(num<100) sprintf(s,"e_current/e_current_y_BB_mesh_format/ycurr0%d.bb",num);
   if(num<10)  sprintf(s,"e_current/e_current_y_BB_mesh_format/ycurr00%d.bb",num);

   fp=fopen(s,"w");
   fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
   for(i=0;i<Ng;i++){
    fprintf(fp,"%g\n",-Q*NE[i]*YVEL[i]/((double)MEAN)); // the potential is in Volts/meter
   }
   fclose(fp);

   sprintf(s,"e_current/e_current_z_BB_mesh_format/zcurr%d.bb",num);
   if(num<100) sprintf(s,"e_current/e_current_z_BB_mesh_format/zcurr0%d.bb",num);
   if(num<10)  sprintf(s,"e_current/e_current_z_BB_mesh_format/zcurr00%d.bb",num);

   fp=fopen(s,"w");
   fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
   for(i=0;i<Ng;i++){
    fprintf(fp,"%g\n",-Q*NE[i]*ZVEL[i]/((double)MEAN)); // the potential is in Volts/meter
   }
   fclose(fp);
// ***

   sprintf(s,"e_energy/BB_mesh_format/e_energy%d.bb",num);
   if(num<100) sprintf(s,"e_energy/BB_mesh_format/e_energy0%d.bb",num);
   if(num<10)  sprintf(s,"e_energy/BB_mesh_format/e_energy00%d.bb",num);

   fp=fopen(s,"w");
   fprintf(fp,"%d %d %d %d\n",dim,1,Ne,2);
   for(i=0;i<Ng;i++){
    fprintf(fp,"%g\n",ENEL[i]/((double)MEAN)); // electron density in 1/m^3
   }
   fclose(fp);
 }
 
// The following rows are in order to avoid the use of the MS DOS command "copy"
// which is a completely different than the UNIX command "cp"
// potential
 sprintf(s,"potential/BB_mesh_format/potential%d.mesh",num);
 if(num<100) sprintf(s,"potential/BB_mesh_format/potential0%d.mesh",num);
 if(num<10)  sprintf(s,"potential/BB_mesh_format/potential00%d.mesh",num);
 fp=fopen(s,"w");
 fprintf(fp,"MeshVersionFormatted 1\n");
 fprintf(fp,"Dimension\n");
 fprintf(fp,"3\n");
 fprintf(fp,"Vertices\n");
 fprintf(fp,"%d\n",Ng);
 for(i=0;i<Ng;i++) 
    fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                              coord[2][i]*1.e6,i_front[i]);
 fprintf(fp,"Tetrahedra\n");
 fprintf(fp,"%d\n",Ne);
 for(i=0;i<Ne;i++)
   fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                 noeud_geo[2][i],noeud_geo[3][i],
                                 i_dom[i]);
 fclose(fp);
// Ex
 sprintf(s,"E/Ex_BB_mesh_format/Ex%d.mesh",num);
 if(num<100) sprintf(s,"E/Ex_BB_mesh_format/Ex0%d.mesh",num);
 if(num<10)  sprintf(s,"E/Ex_BB_mesh_format/Ex00%d.mesh",num);
 fp=fopen(s,"w");
 fprintf(fp,"MeshVersionFormatted 1\n");
 fprintf(fp,"Dimension\n");
 fprintf(fp,"3\n");
 fprintf(fp,"Vertices\n");
 fprintf(fp,"%d\n",Ng);
 for(i=0;i<Ng;i++)
    fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                              coord[2][i]*1.e6,i_front[i]);
 fprintf(fp,"Tetrahedra\n");
 fprintf(fp,"%d\n",Ne);
 for(i=0;i<Ne;i++)
   fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                 noeud_geo[2][i],noeud_geo[3][i],
                                 i_dom[i]);
 fclose(fp);
// Ey
 sprintf(s,"E/Ey_BB_mesh_format/Ey%d.mesh",num);
 if(num<100) sprintf(s,"E/Ey_BB_mesh_format/Ey0%d.mesh",num);
 if(num<10)  sprintf(s,"E/Ey_BB_mesh_format/Ey00%d.mesh",num);
 fp=fopen(s,"w");
 fprintf(fp,"MeshVersionFormatted 1\n");
 fprintf(fp,"Dimension\n");
 fprintf(fp,"3\n");
 fprintf(fp,"Vertices\n");
 fprintf(fp,"%d\n",Ng);
 for(i=0;i<Ng;i++)
    fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                              coord[2][i]*1.e6,i_front[i]);
 fprintf(fp,"Tetrahedra\n");
 fprintf(fp,"%d\n",Ne);
 for(i=0;i<Ne;i++)
   fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                 noeud_geo[2][i],noeud_geo[3][i],
                                 i_dom[i]);
 fclose(fp);
// Ez
 sprintf(s,"E/Ez_BB_mesh_format/Ez%d.mesh",num);
 if(num<100) sprintf(s,"E/Ez_BB_mesh_format/Ez0%d.mesh",num);
 if(num<10)  sprintf(s,"E/Ez_BB_mesh_format/Ez00%d.mesh",num);
 fp=fopen(s,"w");
 fprintf(fp,"MeshVersionFormatted 1\n");
 fprintf(fp,"Dimension\n");
 fprintf(fp,"3\n");
 fprintf(fp,"Vertices\n");
 fprintf(fp,"%d\n",Ng);
 for(i=0;i<Ng;i++)
    fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                              coord[2][i]*1.e6,i_front[i]);
 fprintf(fp,"Tetrahedra\n");
 fprintf(fp,"%d\n",Ne);
 for(i=0;i<Ne;i++)
   fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                 noeud_geo[2][i],noeud_geo[3][i],
                                 i_dom[i]);
 fclose(fp);
// e_density
 sprintf(s,"e_density/BB_mesh_format/e_density%d.mesh",num);
 if(num<100) sprintf(s,"e_density/BB_mesh_format/e_density0%d.mesh",num);
 if(num<10)  sprintf(s,"e_density/BB_mesh_format/e_density00%d.mesh",num);
 fp=fopen(s,"w");
 fprintf(fp,"MeshVersionFormatted 1\n");
 fprintf(fp,"Dimension\n");
 fprintf(fp,"3\n");
 fprintf(fp,"Vertices\n");
 fprintf(fp,"%d\n",Ng);
 for(i=0;i<Ng;i++)
    fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                              coord[2][i]*1.e6,i_front[i]);
 fprintf(fp,"Tetrahedra\n");
 fprintf(fp,"%d\n",Ne);
 for(i=0;i<Ne;i++)
   fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                 noeud_geo[2][i],noeud_geo[3][i],
                                 i_dom[i]);
 fclose(fp);
 if((it==number_of_steps-1) || (it==number_of_steps)){
// xvel
   sprintf(s,"e_velocity/xvel_BB_mesh_format/xvel%d.mesh",num);
   if(num<100) sprintf(s,"e_velocity/xvel_BB_mesh_format/xvel0%d.mesh",num);
   if(num<10)  sprintf(s,"e_velocity/xvel_BB_mesh_format/xvel00%d.mesh",num);
   fp=fopen(s,"w");
   fprintf(fp,"MeshVersionFormatted 1\n");
   fprintf(fp,"Dimension\n");
   fprintf(fp,"3\n");
   fprintf(fp,"Vertices\n");
   fprintf(fp,"%d\n",Ng);
   for(i=0;i<Ng;i++)
      fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                                 coord[2][i]*1.e6,i_front[i]);
   fprintf(fp,"Tetrahedra\n");
   fprintf(fp,"%d\n",Ne);
   for(i=0;i<Ne;i++)
     fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                   noeud_geo[2][i],noeud_geo[3][i],
                                   i_dom[i]);
   fclose(fp);
// yvel
   sprintf(s,"e_velocity/yvel_BB_mesh_format/yvel%d.mesh",num);
   if(num<100) sprintf(s,"e_velocity/yvel_BB_mesh_format/yvel0%d.mesh",num);
   if(num<10)  sprintf(s,"e_velocity/yvel_BB_mesh_format/yvel00%d.mesh",num);
   fp=fopen(s,"w");
   fprintf(fp,"MeshVersionFormatted 1\n");
   fprintf(fp,"Dimension\n");
   fprintf(fp,"3\n");
   fprintf(fp,"Vertices\n");
   fprintf(fp,"%d\n",Ng);
   for(i=0;i<Ng;i++)
      fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                                 coord[2][i]*1.e6,i_front[i]);
   fprintf(fp,"Tetrahedra\n");
   fprintf(fp,"%d\n",Ne);
   for(i=0;i<Ne;i++)
     fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                   noeud_geo[2][i],noeud_geo[3][i],
                                   i_dom[i]);
   fclose(fp);
// zvel
   sprintf(s,"e_velocity/zvel_BB_mesh_format/zvel%d.mesh",num);
   if(num<100) sprintf(s,"e_velocity/zvel_BB_mesh_format/zvel0%d.mesh",num);
   if(num<10)  sprintf(s,"e_velocity/zvel_BB_mesh_format/zvel00%d.mesh",num);
   fp=fopen(s,"w");
   fprintf(fp,"MeshVersionFormatted 1\n");
   fprintf(fp,"Dimension\n");
   fprintf(fp,"3\n");
   fprintf(fp,"Vertices\n");
   fprintf(fp,"%d\n",Ng);
   for(i=0;i<Ng;i++)
      fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                                 coord[2][i]*1.e6,i_front[i]);
   fprintf(fp,"Tetrahedra\n");
   fprintf(fp,"%d\n",Ne);
   for(i=0;i<Ne;i++)
     fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                   noeud_geo[2][i],noeud_geo[3][i],
                                   i_dom[i]);
   fclose(fp);
// ***
// xcurr
   sprintf(s,"e_current/e_current_x_BB_mesh_format/xcurr%d.mesh",num);
   if(num<100) sprintf(s,"e_current/e_current_x_BB_mesh_format/xcurr0%d.mesh",num);
   if(num<10)  sprintf(s,"e_current/e_current_x_BB_mesh_format/xcurr00%d.mesh",num);
   fp=fopen(s,"w");
   fprintf(fp,"MeshVersionFormatted 1\n");
   fprintf(fp,"Dimension\n");
   fprintf(fp,"3\n");
   fprintf(fp,"Vertices\n");
   fprintf(fp,"%d\n",Ng);
   for(i=0;i<Ng;i++)
      fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                                 coord[2][i]*1.e6,i_front[i]);
   fprintf(fp,"Tetrahedra\n");
   fprintf(fp,"%d\n",Ne);
   for(i=0;i<Ne;i++)
     fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                   noeud_geo[2][i],noeud_geo[3][i],
                                   i_dom[i]);
   fclose(fp);
// ycurr
   sprintf(s,"e_current/e_current_y_BB_mesh_format/ycurr%d.mesh",num);
   if(num<100) sprintf(s,"e_current/e_current_y_BB_mesh_format/ycurr0%d.mesh",num);
   if(num<10)  sprintf(s,"e_current/e_current_y_BB_mesh_format/ycurr00%d.mesh",num);
   fp=fopen(s,"w");
   fprintf(fp,"MeshVersionFormatted 1\n");
   fprintf(fp,"Dimension\n");
   fprintf(fp,"3\n");
   fprintf(fp,"Vertices\n");
   fprintf(fp,"%d\n",Ng);
   for(i=0;i<Ng;i++)
      fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                                 coord[2][i]*1.e6,i_front[i]);
   fprintf(fp,"Tetrahedra\n");
   fprintf(fp,"%d\n",Ne);
   for(i=0;i<Ne;i++)
     fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                   noeud_geo[2][i],noeud_geo[3][i],
                                   i_dom[i]);
   fclose(fp);
// zcurr
   sprintf(s,"e_current/e_current_z_BB_mesh_format/zcurr%d.mesh",num);
   if(num<100) sprintf(s,"e_current/e_current_z_BB_mesh_format/zcurr0%d.mesh",num);
   if(num<10)  sprintf(s,"e_current/e_current_z_BB_mesh_format/zcurr00%d.mesh",num);
   fp=fopen(s,"w");
   fprintf(fp,"MeshVersionFormatted 1\n");
   fprintf(fp,"Dimension\n");
   fprintf(fp,"3\n");
   fprintf(fp,"Vertices\n");
   fprintf(fp,"%d\n",Ng);
   for(i=0;i<Ng;i++)
      fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                                 coord[2][i]*1.e6,i_front[i]);
   fprintf(fp,"Tetrahedra\n");
   fprintf(fp,"%d\n",Ne);
   for(i=0;i<Ne;i++)
     fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                   noeud_geo[2][i],noeud_geo[3][i],
                                   i_dom[i]);
   fclose(fp);
// ***
// e_energy
   sprintf(s,"e_energy/BB_mesh_format/e_energy%d.mesh",num);
   if(num<100) sprintf(s,"e_energy/BB_mesh_format/e_energy0%d.mesh",num);
   if(num<10)  sprintf(s,"e_energy/BB_mesh_format/e_energy00%d.mesh",num);
   fp=fopen(s,"w");
   fprintf(fp,"MeshVersionFormatted 1\n");
   fprintf(fp,"Dimension\n");
   fprintf(fp,"3\n");
   fprintf(fp,"Vertices\n");
   fprintf(fp,"%d\n",Ng);
   for(i=0;i<Ng;i++)
      fprintf(fp,"%g %g %g %d\n",coord[0][i]*1.e6,coord[1][i]*1.e6,
                                 coord[2][i]*1.e6,i_front[i]);
   fprintf(fp,"Tetrahedra\n");
   fprintf(fp,"%d\n",Ne);
   for(i=0;i<Ne;i++)
     fprintf(fp,"%d %d %d %d %d\n",noeud_geo[0][i],noeud_geo[1][i],
                                   noeud_geo[2][i],noeud_geo[3][i],
                                   i_dom[i]);
   fclose(fp);
 }
/* 
 sprintf(s,"copy device.mesh potential/potential%d.mesh",num);
 if(num<100) sprintf(s,"copy device.mesh potential/potential0%d.mesh",num);
 if(num<10)  sprintf(s,"copy device.mesh potential/potential00%d.mesh",num);
 system(s);

 sprintf(s,"copy device.mesh Ex/Ex%d.mesh",num);
 if(num<100) sprintf(s,"copy device.mesh Ex/Ex0%d.mesh",num);
 if(num<10)  sprintf(s,"copy device.mesh Ex/Ex00%d.mesh",num);
 system(s);

 sprintf(s,"copy device.mesh Ey/Ey%d.mesh",num);
 if(num<100) sprintf(s,"copy device.mesh Ey/Ey0%d.mesh",num);
 if(num<10)  sprintf(s,"copy device.mesh Ey/Ey00%d.mesh",num);
 system(s);

 sprintf(s,"copy device.mesh Ez/Ez%d.mesh",num);
 if(num<100) sprintf(s,"copy device.mesh Ez/Ez0%d.mesh",num);
 if(num<10)  sprintf(s,"copy device.mesh Ez/Ez00%d.mesh",num);
 system(s);

 sprintf(s,"copy device.mesh e_density/e_density%d.mesh",num);
 if(num<100) sprintf(s,"copy device.mesh e_density/e_density0%d.mesh",num);
 if(num<10)  sprintf(s,"copy device.mesh e_density/e_density00%d.mesh",num);
 system(s);

 sprintf(s,"copy device.mesh xvel/xvel%d.mesh",num);
 if(num<100) sprintf(s,"copy device.mesh xvel/xvel0%d.mesh",num);
 if(num<10)  sprintf(s,"copy device.mesh xvel/xvel00%d.mesh",num);
 system(s);

 sprintf(s,"copy device.mesh yvel/yvel%d.mesh",num);
 if(num<100) sprintf(s,"copy device.mesh yvel/yvel0%d.mesh",num);
 if(num<10)  sprintf(s,"copy device.mesh yvel/yvel00%d.mesh",num);
 system(s);

 sprintf(s,"copy device.mesh zvel/zvel%d.mesh",num);
 if(num<100) sprintf(s,"copy device.mesh zvel/zvel0%d.mesh",num);
 if(num<10)  sprintf(s,"copy device.mesh zvel/zvel00%d.mesh",num);
 system(s);

 sprintf(s,"copy device.mesh e_energy/e_energy%d.mesh",num);
 if(num<100) sprintf(s,"copy device.mesh e_energy/e_energy0%d.mesh",num);
 if(num<10)  sprintf(s,"copy device.mesh e_energy/e_energy00%d.mesh",num);
 system(s);
*/
 }

