/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 06 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 september 2007, Siracusa, Jean Michel Sellier

// Converts a square matrix A[1..n][1..n] into a row-indexed sparse storage
// mode. Only elements of A with magnitude >= thresh are retained. Output is
// in two linear arrays with dimension nmax (an input parameter): 
// sa[1..n][1..n] contains array values, indexed by ija[1..]. 
// The number of elements filled of sa and ija on output are both
// ija[ija[1]-1]-1.

{
 int i,j;
 int n=Ng;
 int nmax=100*Ne;
 
 int k;
 
 for(j=1;j<=n;j++){
   sa[j]=A[j*Ng+j]; // store diagonal elements
//   printf("A[%d][%d]=%g *** %g\n",j,j,A[j*Ng+j],sa[j]);
 }
 ija[1]=n+2;
 k=n+1;
 for(i=1;i<=n;i++){
   for(j=1;j<=n;j++){
//     if(fabs(A[i*Ng+j])!=0.0) printf("fabs(A[%d][%d]=%g\n",i,j,A[i*Ng+j]);
     if(fabs(A[i*Ng+j])>=thresh && i!=j){
       if(++k>nmax){
        printf("srpsin error! nmax too small, please increase it...\n");
        exit(0);
       }
       sa[k]=A[i*Ng+j];
//       printf("A[%d][%d]=%g   k = %d\n",i,j,sa[k],k);
       ija[k]=j;
     }
   }
   ija[i+1]=k+1;
 }
}
