/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 06 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 03 august 2007, Siracusa, Jean Michel Sellier

// Definition of the B array for the resolution
// of the discretised Poisson equation by means of finite
// element. For more informations see french book pag.336 par.9.5.5.

void assemble_rhs_B(void)
{
 int i,m,l,k1,ni;
 double xii[3][3]; // i=1..dim, j=1..lg

 for(k1=0;k1<3;k1++) for(l=0;l<3;l++) xii[k1][l]=0.;
 for(i=0;i<=Ng;i++) b[i]=0.;

// memset(&xii,0,sizeof(xii));
// memset(&b,0,sizeof(b));

// Assemblage du second membre. See the french book, pag.327, par.9.3.2
// fill the vector b = [f(i,j) f(i+1,j) ...] (non-smart but needed).
// note: current content of vector b is random numbers (not set to zero)
 for(m=0;m<Ne;m++){
  memset(&xii,0,sizeof(xii));
//  {int i,j; for(i=0;i<3;i++) for(j=0;j<3;j++) xii[i][j]=0.;}
  for(l=0;l<lg;l++){
// Evaluer less coordonees cartesiennes du point de Gauss \xi_l
   for(k1=0;k1<dim;k1++){ 
     int n; 
     for(n=0;n<ng;n++) xii[k1][l]+=coord[k1][noeud_geo[n][m]-1]*base_geo[n][l];
   }
   for(ni=0;ni<nf;ni++){
    int n;
    double x1;
    double dens;
    i=noeud_geo[ni][m]-1;
    x1=0.;
    dens=0.25*(NE[noeud_geo[0][m]-1]+NE[noeud_geo[1][m]-1]
              +NE[noeud_geo[2][m]-1]+NE[noeud_geo[3][m]-1]);
    for(n=0;n<nf;n++) x1+=-1.e9*Q*(dens-ND[m]+NA[m])*base_ref[n][l];
    if(POISSONUPDATEFLAG==NO) x1=0.;
//    for(n=0;n<nf;n++) x1+=sin(2.*PI*coord[2][noeud_geo[n][m]-1]*1.e6)*base_ref[n][l];
//    printf("%g\n",x1);
    x1*=base_ref[ni][l];
// Neumann boundary conditions
// We compute \int_{\Gamma_N}{g v}
// see pag.105, formula (4.7) of the french book
    if(i_front[i]==INSULATOR) x1+=0.; // i.e. the gradient is zero...
    x1*=poids_K[l][m];
    b[i]+=x1;
//    printf("value = %g\n",value);
    x1=0.;
   }
  }
 }
// non-homogeneous Dirichlet boundary conditions
// *****
 for(m=0;m<Ne;m++)
  for(ni=0;ni<nf;ni++){
    double value;
    i=noeud_geo[ni][m]-1;
    if(i_front[i]==OHMIC || i_front[i]==CONTACT ||
       i_front[i]==SCHOTTKY) value+=VIC[i]/EPS;
    b[i]+=value;
    value=0.;
  }
}
