/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 06 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 02 august 2007, Siracusa, Jean Michel Sellier

// computes the inverse of Jacobian. see pag.324 of french book.

void define_inverse_jacobian(void)
{

// int i,j;
 int k1,k2,m;
 double a[3][3]; // i=1..dim, j=1..dim
 double det;

// memset(&a,0,sizeof(a));
 for(k1=0;k1<dim;k1++)
  for(k2=0;k2<dim;k2++) a[k1][k2]=0.0;

  for(m=0;m<Ne;m++){
//printf("%d of %d\n",m,Ne);
   for(k1=0;k1<dim;k1++)
    for(k2=0;k2<dim;k2++){
     int n;
     for(n=0;n<ng;n++) a[k1][k2]+=coord[k1][noeud_geo[n][m]-1]*d_base_geo[k2][n];
    }
   det=a[0][0]*a[1][1]*a[2][2]+a[0][1]*a[1][2]*a[2][0]+a[0][2]*a[1][0]*a[2][1]
       -(a[2][0]*a[1][1]*a[0][2]+a[2][1]*a[1][2]*a[0][0]+a[2][2]*a[1][0]*a[0][1]);
   if(det==0.0){
   printf("m = %d\n",m);
   printf("%g %g %g\n",a[0][0],a[0][1],a[0][2]);
   printf("%g %g %g\n",a[1][0],a[1][1],a[1][2]);
   printf("%g %g %g\n",a[2][0],a[2][1],a[2][2]);
   }
//printf("det = %g detJ = %g\n",det,detJ(m,l));
// definition of the inverse jacobian matrix of the m-th trasformation in the l-th element
//printf("qui\n");
   inv_jac_K[0][0][m]=(a[1][1]*a[2][2]-a[2][1]*a[1][2])/det;
   inv_jac_K[1][0][m]=-(a[1][0]*a[2][2]-a[2][0]*a[1][2])/det;
   inv_jac_K[2][0][m]=(a[1][0]*a[2][1]-a[2][0]*a[1][1])/det;
   inv_jac_K[0][1][m]=-(a[0][1]*a[2][2]-a[2][1]*a[0][2])/det;
   inv_jac_K[1][1][m]=(a[0][0]*a[2][2]-a[2][0]*a[0][2])/det;
   inv_jac_K[2][1][m]=-(a[0][0]*a[2][1]-a[2][0]*a[0][1])/det;
   inv_jac_K[0][2][m]=(a[0][1]*a[1][2]-a[1][1]*a[0][2])/det;
   inv_jac_K[1][2][m]=-(a[0][0]*a[1][2]-a[1][0]*a[0][2])/det;
   inv_jac_K[2][2][m]=(a[0][0]*a[1][1]-a[1][0]*a[0][1])/det;
//printf("quo\n");

/*   printf("m = %d\n",m);
   printf("%g %g %g\n",
inv_jac_K[0][0][m]*a[0][0]+inv_jac_K[0][1][m]*a[1][0]+inv_jac_K[0][2][m]*a[2][0],
inv_jac_K[0][0][m]*a[0][1]+inv_jac_K[0][1][m]*a[1][1]+inv_jac_K[0][2][m]*a[2][1],
inv_jac_K[0][0][m]*a[0][2]+inv_jac_K[0][1][m]*a[1][2]+inv_jac_K[0][2][m]*a[2][2]);
   printf("%g %g %g\n",
inv_jac_K[1][0][m]*a[0][0]+inv_jac_K[1][1][m]*a[1][0]+inv_jac_K[1][2][m]*a[2][0],
inv_jac_K[1][0][m]*a[0][1]+inv_jac_K[1][1][m]*a[1][1]+inv_jac_K[1][2][m]*a[2][1],
inv_jac_K[1][0][m]*a[0][2]+inv_jac_K[1][1][m]*a[1][2]+inv_jac_K[1][2][m]*a[2][2]);
   printf("%g %g %g\n",
inv_jac_K[2][0][m]*a[0][0]+inv_jac_K[2][1][m]*a[1][0]+inv_jac_K[2][2][m]*a[2][0],
inv_jac_K[2][0][m]*a[0][1]+inv_jac_K[2][1][m]*a[1][1]+inv_jac_K[2][2][m]*a[2][1],
inv_jac_K[2][0][m]*a[0][2]+inv_jac_K[2][1][m]*a[1][2]+inv_jac_K[2][2][m]*a[2][2]);
*/

// reset the array a[][]
//   memset(&a,0,sizeof(a));
 for(k1=0;k1<dim;k1++)
  for(k2=0;k2<dim;k2++) a[k1][k2]=0.0;
 }
 printf("components of inverse jacobian matrices defined...\n");
}

