/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 11 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 august 2007, Siracusa, Jean Michel Sellier

// creation of a particle in the i-th element

inline void creation(int i,double t)
{
 double c1,c2,c3,c4,c5,c6,c7;

// the following rows are just for avoiding warning messages during compilation
 c1=0.;
 c2=0.;
 c3=0.;
 c4=0.;
 c5=0.;
 c6=0.;
 c7=0.;

 L[0]=rnd();
 L[1]=rnd();
 L[2]=rnd();
 L[3]=4.-(L[0]+L[1]+L[2]);
 EL=i;

// We assume that the particles are initially 
// at near thermal equilibrium
 if(i_dom[i]!=SIO2){
  IV=1;
  if(NOVALLEY[i_dom[i]]==2 && rnd()>0.8) IV=2;
  c1=log(rnd());
  c2=SMH[i_dom[i]][IV]*sqrt(-1.5*BKTQ*c1*(1.-alphaK[i_dom[i]][IV]*1.5*BKTQ*c1));
  c3=rnd();
  c4=sqrt(1.-c3*c3);
  c5=2.*PI*rnd();
  c6=sin(c5);
  c7=cos(c5);
 }

// definition of the incoming pseudo-vector
// double modulus;

// calculates the MODULUS OF THE PSEUDO-VECTOR 
 KX=c2*c3;
 KY=c2*c4*c6;
 KZ=c2*c4*c7;
/*
// The following rows are needed if one wants to insert incoming
// particles with a normal velocity, normal to the tetrahedra surface.

 modulus=sqrt(pow(KX,2.)+pow(KY,2.)+pow(KZ,2.));

// calculates the internal unit vector
// i.e. the unit vector which is perpendicular to the "OHMIC face"
// and which points to the internal side of the tetrahedra
 int h,l=0;
 double x[4],y[4],z[4];
 double nx,ny,nz;
 double x21,y21,z21;
 double x23,y23,z23;
 double nmodulus;
 
 for(h=0;h<4;h++){
  if(i_front[noeud_geo[h][i]-1]==OHMIC){
   x[l]=coord[0][noeud_geo[h][i]-1];
   y[l]=coord[1][noeud_geo[h][i]-1];
   z[l]=coord[2][noeud_geo[h][i]-1];
   l++;
  }
  if(i_front[noeud_geo[h][i]-1]!=OHMIC){
   x[3]=coord[0][noeud_geo[h][i]-1];
   y[3]=coord[1][noeud_geo[h][i]-1];
   z[3]=coord[2][noeud_geo[h][i]-1];        
  }
 }
//printf("** %g %g %g\n",x[0],y[0],z[0]);
//printf("** %g %g %g\n",x[1],y[1],z[1]);
//printf("** %g %g %g\n",x[2],y[2],z[2]);
//printf("** %g %g %g\n",x[3],y[3],z[3]);

 x21=x[1]-x[0];
 y21=y[1]-y[0];
 z21=z[1]-z[0];
 x23=x[1]-x[2];
 y23=y[1]-y[2];
 z23=z[1]-z[2]; 
 nx=(y21*z23-y23*z21);
 ny=(z21*x23-z23*x21);
 nz=(x21*y23-x23*y21);
 nmodulus=sqrt(pow(nx,2.)+pow(ny,2.)+pow(nz,2.));
 nx/=nmodulus;
 ny/=nmodulus;
 nz/=nmodulus;
// check if the n vector points to the internal of the tetrahedra
 double scalar;
 scalar=nx*(x[3]-x[1])+ny*(y[3]-y[1])+nz*(z[3]-z[1]);
 scalar/=sqrt(pow(nx*(x[3]-x[1]),2.)
             +pow(ny*(y[3]-y[1]),2.)
             +pow(nz*(z[3]-z[1]),2.));
//printf("theta = %g   %g\n",acos(scalar),scalar);
 if(!(acos(scalar)>=0. && acos(scalar)<=0.5*PI)){
  nx*=-1.;
  ny*=-1.;
  nz*=-1.;
 }
//printf("%g %g %g %g\n",sqrt(pow(nx,2.)+pow(ny,2.)+pow(nz,2.)),nx,ny,nz);
// final definition of the pseudo-wave vector
 KX=nx*modulus;
 KY=ny*modulus;
 KZ=nz*modulus;
*/
 TS=t-log(rnd())/GM[i_dom[i]];
}

