dnl  -*- buffer-read-only: t -*- vi: set ro:
dnl 
dnl DO NOT EDIT THIS FILE   (ag_run_strftime.m4)
dnl 
dnl It has been AutoGen-ed  Monday February  4, 2002 at 08:34:30 PM PST
dnl From the definitions    misc.def
dnl and the template file   conftest.tpl
dnl
dnl @synopsis  AG_RUN_STRFTIME
dnl
dnl @success-result
dnl
dnl   * HAVE_STRFTIME is #defined as 1
dnl
dnl @failure-result:  there is no output
dnl
dnl @description
dnl   Check for existence and functioning of strftime routine.
dnl
dnl @version "04-February-2002 at 20:34"
dnl
dnl @author Bruce Korb <bkorb@gnu.org>
dnl
AC_DEFUN([AG_RUN_STRFTIME],[
  AC_MSG_CHECKING([whether strftime() works])
  AC_CACHE_VAL([ag_cv_run_strftime],[
  AC_TRY_RUN([@%:@include <time.h>
char t_buf@<:@ 64 @:>@;
int main() {
  static const char z@<:@@:>@ = "Thursday Aug 28 240";
  struct tm tm;
  tm.tm_sec   = 36;  /* seconds after the minute @<:@0, 61@:>@  */
  tm.tm_min   = 44;  /* minutes after the hour @<:@0, 59@:>@ */
  tm.tm_hour  = 12;  /* hour since midnight @<:@0, 23@:>@ */
  tm.tm_mday  = 28;  /* day of the month @<:@1, 31@:>@ */
  tm.tm_mon   =  7;  /* months since January @<:@0, 11@:>@ */
  tm.tm_year  = 86;  /* years since 1900 */
  tm.tm_wday  =  4;  /* days since Sunday @<:@0, 6@:>@ */
  tm.tm_yday  = 239; /* days since January 1 @<:@0, 365@:>@ */
  tm.tm_isdst =  1;  /* flag for daylight savings time */
  strftime( t_buf, sizeof( t_buf ), "%A %b %d %j", &tm );
  return (strcmp( t_buf, z ) != 0); }],
    [ag_cv_run_strftime=yes],[ag_cv_run_strftime=no],[ag_cv_run_strftime=no]
  ) # end of TRY_RUN]) # end of CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_strftime}])

  if test "X${ag_cv_run_strftime}" != Xno
  then
    AC_DEFINE([HAVE_STRFTIME],[1],
        [Define this if strftime() works])
  fi
]) # end of AC_DEFUN of AG_RUN_STRFTIME
