dnl  -*- buffer-read-only: t -*- vi: set ro:
dnl 
dnl DO NOT EDIT THIS FILE   (ag_macros.m4)
dnl 
dnl It has been AutoGen-ed  Sunday June 16, 2002 at 10:55:30 AM PDT
dnl From the definitions    misc.def
dnl and the template file   conftest.tpl
dnl
dnl @synopsis  INVOKE_AG_MACROS
dnl
dnl  This macro will invoke the AutoConf macros specified in misc.def
dnl  that have not been disabled with "omit-invocation".
dnl
AC_DEFUN([AG_DISABLE_SHELL],[
  AC_ARG_ENABLE([shell],
    AC_HELP_STRING([--disable-shell], [using shell scripts]),
    [ag_cv_enable_shell=${enable_shell}],
    AC_CACHE_CHECK([whether using shell scripts], ag_cv_enable_shell,
      ag_cv_enable_shell=yes)
  ) # end of AC_ARG_ENABLE

  if test "X${ag_cv_enable_shell}" != Xno
  then
    AC_DEFINE([SHELL_ENABLED],[1],
        [Define this if using shell scripts])
    AC_SUBST(OPTS_TESTDIR)
    AC_SUBST(TOP_DIRLIST)
    AC_SUBST(AGEN5_TESTS)
    TOP_DIRLIST='@S|@(SHELL_DIRS) @S|@(XML2AG_DIR)'
    OPTS_TESTDIR=test
    AGEN5_TESTS='@S|@(SHELL_TESTS) @S|@(NOSHELL_TESTS)'
  else
    TOP_DIRLIST='@S|@(NOSHELL_DIRS) @S|@(XML2AG_DIR)'
    OPTS_TESTDIR=
    AGEN5_TESTS='@S|@(NOSHELL_TESTS)'
  fi
]) # end of AC_DEFUN of AG_DISABLE_SHELL


AC_DEFUN([AG_ENABLE_DEBUG],[
  AC_ARG_ENABLE([debug],
    AC_HELP_STRING([--enable-debug], [wanting autogen debugging]),
    [ag_cv_enable_debug=${enable_debug}],
    AC_CACHE_CHECK([whether wanting autogen debugging], ag_cv_enable_debug,
      ag_cv_enable_debug=no)
  ) # end of AC_ARG_ENABLE

  if test "X${ag_cv_enable_debug}" != Xno
  then
    AC_DEFINE([DEBUG_ENABLED],[1],
        [Define this if wanting autogen debugging])
    CPPFLAGS="-DDEBUG @S|@CPPFLAGS"
    CFLAGS="-g `echo @S|@CFLAGS|sed 's%-g *%%g;s%-O@<:@0-9@:>@* *%%g'`"
  fi
]) # end of AC_DEFUN of AG_ENABLE_DEBUG


AC_DEFUN([AG_WITH_REGEX_HEADER],[
  AC_ARG_WITH([regex-header],
    AC_HELP_STRING([--with-regex-header], [a reg expr header is specified]),
    [ag_cv_with_regex_header=${with_regex_header}],
    AC_CACHE_CHECK([whether a reg expr header is specified], ag_cv_with_regex_header,
      ag_cv_with_regex_header=no)
  ) # end of AC_ARG_WITH

  if test "X${ag_cv_with_regex_header}" != Xno
  then
    AC_DEFINE_UNQUOTED([REGEX_HEADER],[<${ag_cv_with_regex_header}>])
  else
    AC_DEFINE([REGEX_HEADER],[<regex.h>],[name of regex header file])
  fi
]) # end of AC_DEFUN of AG_WITH_REGEX_HEADER


AC_DEFUN([AG_WITHLIB_REGEX],[
  AC_ARG_WITH([libregex],
    AC_HELP_STRING([--with-libregex], [libregex installation prefix]),
    [ag_cv_with_regex_root=${with_libregex}],
    AC_CACHE_CHECK([whether with-libregex was specified], ag_cv_with_regex_root,
      ag_cv_with_regex_root=no)
  ) # end of AC_ARG_WITH

  AC_ARG_WITH([libregex-incdir],
    AC_HELP_STRING([--with-libregex-incdir], [libregex include dir]),
    [ag_cv_with_regex_incdir=${with_regex_incdir}],
    AC_CACHE_CHECK([whether with-libregex-incdir was specified], ag_cv_with_regex_incdir,
      ag_cv_with_regex_incdir=no)
  ) # end of AC_ARG_WITH

  AC_ARG_WITH([libregex-libdir],
    AC_HELP_STRING([--with-libregex-libdir], [libregex include dir]),
    [ag_cv_with_regex_libdir=${with_regex_libdir}],
    AC_CACHE_CHECK([whether with-libregex-libdir was specified], ag_cv_with_regex_libdir,
      ag_cv_with_regex_libdir=no)
  ) # end of AC_ARG_WITH

  case X${ag_cv_with_regex_incdir} in
  Xyes|Xno )
    case X${ag_cv_with_regex_root} in
    Xyes|Xno ) ;;
    * )        ag_cv_with_regex_incdir=${ag_cv_with_regex_root}/include ;;
    esac
  esac

  case X${ag_cv_with_regex_libdir} in
  Xyes|Xno )
    case X${ag_cv_with_regex_root} in
    Xyes|Xno ) ;;
    * )        ag_cv_with_regex_libdir="-L${ag_cv_with_regex_root}/lib -lregex";;
    esac
  esac
  ag_save_CPPFLAGS="${CPPFLAGS}"
  ag_save_LDFLAGS="${LDFLAGS}"

  case X${ag_cv_with_regex_incdir} in
  Xyes|Xno ) ;;
  * ) CPPFLAGS="${CPPFLAGS} ${ag_cv_with_regex_incdir}" ;;
  esac

  case X${ag_cv_with_regex_libdir} in
  Xyes|Xno ) ;;
  * )
    LDFLAGS="${LDFLAGS} ${ag_cv_with_regex_libdir}" ;;
  esac
  AC_MSG_CHECKING([whether libregex functions properly])
  AC_CACHE_VAL([ag_cv_with_regex],[
  AC_TRY_RUN([@%:@include <stdio.h>
@%:@include <sys/types.h>
@%:@include REGEX_HEADER
static regex_t re;
void comp_re( const char* pzPat ) {
  int res = regcomp( &re, pzPat, REG_EXTENDED|REG_ICASE|REG_NEWLINE );
  if (res == 0) return;
  exit( res ); }
int main() {
  int  res;
  regmatch_t m@<:@2@:>@;
  comp_re( "^.*\@S|@"   );
  comp_re( "()|no.*" );
  comp_re( "."       );
  if (regexec( &re, "X", 2, m, 0 ) != 0)  return 1;
  if ((m@<:@0@:>@.rm_so != 0) || (m@<:@0@:>@.rm_eo != 1)) {
    fputs( "error: regex -->.<-- did not match\n", stderr );
    return 1;
  }
  return 0; }],
    [ag_cv_with_regex=yes],[ag_cv_with_regex=no],[ag_cv_with_regex=no]
  ) # end of AC_TRY_RUN ]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_with_regex}])

  if test "X${ag_cv_with_regex}" = Xno
  then
    CPPFLAGS="${ag_save_CPPFLAGS}"
    LDFLAGS="${ag_save_LDFLAGS}"
        	cat >&2 <<'_EOF_'
I cannot detect POSIX compliant regcomp/regexec routines.
These are required for AutoGen to work correctly.  If you have
such a library present on your system, you must specify it by
setting the LIBS environment variable, e.g., "LIBS='-lregex'".
If you do not have such a library on your system, then you should
download and install, for example, the one from:
    ftp://ftp.gnu.org/gnu/rx/
_EOF_
AC_MSG_ERROR([Cannot find working POSIX regex library])
  fi
]) # end of AC_DEFUN of AG_WITHLIB_REGEX


AC_DEFUN([AG_WITHLIB_GUILE],[
  AC_ARG_WITH([libguile],
    AC_HELP_STRING([--with-libguile], [libguile installation prefix]),
    [ag_cv_with_guile_root=${with_libguile}],
    AC_CACHE_CHECK([whether with-libguile was specified], ag_cv_with_guile_root,
      ag_cv_with_guile_root=no)
  ) # end of AC_ARG_WITH

  AC_ARG_WITH([libguile-incdir],
    AC_HELP_STRING([--with-libguile-incdir], [libguile include dir]),
    [ag_cv_with_guile_incdir=${with_guile_incdir}],
    AC_CACHE_CHECK([whether with-libguile-incdir was specified], ag_cv_with_guile_incdir,
      ag_cv_with_guile_incdir=no)
  ) # end of AC_ARG_WITH

  AC_ARG_WITH([libguile-libdir],
    AC_HELP_STRING([--with-libguile-libdir], [libguile include dir]),
    [ag_cv_with_guile_libdir=${with_guile_libdir}],
    AC_CACHE_CHECK([whether with-libguile-libdir was specified], ag_cv_with_guile_libdir,
      ag_cv_with_guile_libdir=no)
  ) # end of AC_ARG_WITH

  case X${ag_cv_with_guile_incdir} in
  Xyes|Xno )
    case X${ag_cv_with_guile_root} in
    Xyes|Xno ) ;;
    * )        ag_cv_with_guile_incdir=${ag_cv_with_guile_root}/include ;;
    esac
  esac

  case X${ag_cv_with_guile_libdir} in
  Xyes|Xno )
    case X${ag_cv_with_guile_root} in
    Xyes|Xno ) ;;
    * )        ag_cv_with_guile_libdir="-L${ag_cv_with_guile_root}/lib -lguile";;
    esac
  esac
  ag_save_CPPFLAGS="${CPPFLAGS}"
  ag_save_LDFLAGS="${LDFLAGS}"

  case X${ag_cv_with_guile_incdir} in
  Xyes|Xno ) ;;
  * ) CPPFLAGS="${CPPFLAGS} ${ag_cv_with_guile_incdir}" ;;
  esac

  case X${ag_cv_with_guile_libdir} in
  Xyes|Xno )
    LDFLAGS="${LDFLAGS} -lguile" ;;
  * )
    LDFLAGS="${LDFLAGS} ${ag_cv_with_guile_libdir}" ;;
  esac
  AC_MSG_CHECKING([whether libguile can be linked with])
  AC_CACHE_VAL([ag_cv_with_guile],[
  AC_LINK_IFELSE([[@%:@include <libguile.h>
int main () {
  SCM fumble, bumble, stumble;
  stumble = scm_cons( fumble, bumble );
  stumble = scm_display( fumble, bumble );
  stumble = scm_ilength( fumble );
  stumble = scm_makstr( 1, 2 );
  stumble = gh_eval_str( "stumble" );
  scm_misc_error( "oops", "bad", bumble );
  stumble = scm_num_eq_p( fumble, bumble );
  scm_wrong_type_arg( "oops", 1, bumble );
  return 0; }]],
    [ag_cv_with_guile=yes],[ag_cv_with_guile=no]
  ) # end of AC_LINK_IFELSE ]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_with_guile}])

  if test "X${ag_cv_with_guile}" = Xno
  then
    CPPFLAGS="${ag_save_CPPFLAGS}"
    LDFLAGS="${ag_save_LDFLAGS}"
    f=`guile-config link`
    if test -z "$f"
    then
      AC_MSG_ERROR([Cannot find Guile])
    fi
    LDFLAGS="${LDFLAGS} $f"
    f=`guile-config compile | \
       sed 's,-I */usr/include,,'`
    CPPFLAGS="${CPPFLAGS} $f"
  fi
]) # end of AC_DEFUN of AG_WITHLIB_GUILE


AC_DEFUN([AG_WITHLIB_XML],[
  AC_ARG_WITH([libxml],
    AC_HELP_STRING([--with-libxml], [libxml installation prefix]),
    [ag_cv_with_xml_root=${with_libxml}],
    AC_CACHE_CHECK([whether with-libxml was specified], ag_cv_with_xml_root,
      ag_cv_with_xml_root=no)
  ) # end of AC_ARG_WITH

  AC_ARG_WITH([libxml-incdir],
    AC_HELP_STRING([--with-libxml-incdir], [libxml include dir]),
    [ag_cv_with_xml_incdir=${with_xml_incdir}],
    AC_CACHE_CHECK([whether with-libxml-incdir was specified], ag_cv_with_xml_incdir,
      ag_cv_with_xml_incdir=no)
  ) # end of AC_ARG_WITH

  AC_ARG_WITH([libxml-libdir],
    AC_HELP_STRING([--with-libxml-libdir], [libxml include dir]),
    [ag_cv_with_xml_libdir=${with_xml_libdir}],
    AC_CACHE_CHECK([whether with-libxml-libdir was specified], ag_cv_with_xml_libdir,
      ag_cv_with_xml_libdir=no)
  ) # end of AC_ARG_WITH

  case X${ag_cv_with_xml_incdir} in
  Xyes|Xno )
    case X${ag_cv_with_xml_root} in
    Xyes|Xno ) ;;
    * )        ag_cv_with_xml_incdir=${ag_cv_with_xml_root}/include ;;
    esac
  esac

  case X${ag_cv_with_xml_libdir} in
  Xyes|Xno )
    case X${ag_cv_with_xml_root} in
    Xyes|Xno ) ;;
    * )        ag_cv_with_xml_libdir="-L${ag_cv_with_xml_root}/lib -lxml";;
    esac
  esac
  ag_save_CPPFLAGS="${CPPFLAGS}"
  ag_save_LDFLAGS="${LDFLAGS}"

  case X${ag_cv_with_xml_incdir} in
  Xyes|Xno ) ;;
  * ) CPPFLAGS="${CPPFLAGS} ${ag_cv_with_xml_incdir}" ;;
  esac

  case X${ag_cv_with_xml_libdir} in
  Xyes|Xno )
    LDFLAGS="${LDFLAGS} -lxml" ;;
  * )
    LDFLAGS="${LDFLAGS} ${ag_cv_with_xml_libdir}" ;;
  esac
  AC_MSG_CHECKING([whether libxml can be linked with])
  AC_CACHE_VAL([ag_cv_with_xml],[
  AC_LINK_IFELSE([[@%:@include <libxml/parser.h>
@%:@include <libxml/tree.h>

int main () {
xmlDocPtr p = xmlParseFile( "mumble.xml" ); }]],
    [ag_cv_with_xml=yes],[ag_cv_with_xml=no]
  ) # end of AC_LINK_IFELSE ]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_with_xml}])

  if test "X${ag_cv_with_xml}" = Xno
  then
    CPPFLAGS="${ag_save_CPPFLAGS}"
    LDFLAGS="${ag_save_LDFLAGS}"
    f=`xml2-config --libs`
    if test X${with_libxml} != Xno && test -n "$f"
    then
      LDFLAGS="${LDFLAGS} $f"
      f=`xml2-config --cflags | \
        sed 's,-I */usr/include,,'`
      CPPFLAGS="${CPPFLAGS} $f"
      AC_SUBST(XML2AG_DIR)
      XML2AG_DIR=xml2ag
      echo "libxml2 found via xml2-config" >&2
    fi
  fi
]) # end of AC_DEFUN of AG_WITHLIB_XML


AC_DEFUN([AG_RUN_ALLOCATED_CTIME],[
  AC_MSG_CHECKING([whether ctime() allocates memory for its result])
  AC_CACHE_VAL([ag_cv_run_allocated_ctime],[
  AC_TRY_RUN([@%:@include <time.h>
int main (int argc, char** argv) {
   time_t  timeVal = time( (time_t*)NULL );
   char*   pzTime  = ctime( &timeVal );
   free( (void*)pzTime );
   return 0; }],
    [ag_cv_run_allocated_ctime=yes],[ag_cv_run_allocated_ctime=no],[ag_cv_run_allocated_ctime=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_allocated_ctime}])

  if test "X${ag_cv_run_allocated_ctime}" != Xno
  then
    AC_DEFINE([HAVE_ALLOCATED_CTIME],[1],
        [Define this if ctime() allocates memory for its result])
  fi
]) # end of AC_DEFUN of AG_RUN_ALLOCATED_CTIME


AC_DEFUN([AG_RUN_PATHFIND],[
  AC_MSG_CHECKING([whether pathfind(3) works])
  AC_CACHE_VAL([ag_cv_run_pathfind],[
  AC_TRY_RUN([@%:@include <string.h>
@%:@include <stdlib.h>
int main (int argc, char** argv) {
   char* pz = pathfind( getenv( "PATH" ), "sh", "x" );
   return (pz == 0) ? 1 : 0;
}],
    [ag_cv_run_pathfind=yes],[ag_cv_run_pathfind=no],[ag_cv_run_pathfind=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_pathfind}])

  if test "X${ag_cv_run_pathfind}" != Xno
  then
    AC_DEFINE([HAVE_PATHFIND],[1],
        [Define this if pathfind(3) works])
  else
    COMPATOBJ="@S|@COMPATOBJ pathfind.lo"
  fi
]) # end of AC_DEFUN of AG_RUN_PATHFIND


AC_DEFUN([AG_RUN_POSIX_SYSINFO],[
  AC_MSG_CHECKING([whether sysinfo(2) is POSIX])
  AC_CACHE_VAL([ag_cv_run_posix_sysinfo],[
  AC_TRY_RUN([@%:@include <sys/systeminfo.h>
int main() { char z@<:@ 256 @:>@;
long sz = sysinfo( SI_SYSNAME, z, sizeof( z ));
return (sz > 0) ? 0 : 1; }],
    [ag_cv_run_posix_sysinfo=yes],[ag_cv_run_posix_sysinfo=no],[ag_cv_run_posix_sysinfo=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_posix_sysinfo}])

  if test "X${ag_cv_run_posix_sysinfo}" != Xno
  then
    AC_DEFINE([HAVE_POSIX_SYSINFO],[1],
        [Define this if sysinfo(2) is POSIX])
  fi
]) # end of AC_DEFUN of AG_RUN_POSIX_SYSINFO


AC_DEFUN([AG_RUN_STRCSPN],[
  AC_MSG_CHECKING([whether strcspn matches prototype and works])
  AC_CACHE_VAL([ag_cv_run_strcspn],[
  AC_TRY_RUN([@%:@include <string.h>
int main (int argc, char** argv) {
   char zRej@<:@@:>@ = "reject";
   char zAcc@<:@@:>@ = "a-ok-eject";
   return strcspn( zAcc, zRej ) - 5;
}],
    [ag_cv_run_strcspn=yes],[ag_cv_run_strcspn=no],[ag_cv_run_strcspn=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_strcspn}])

  if test "X${ag_cv_run_strcspn}" != Xno
  then
    AC_DEFINE([HAVE_STRCSPN],[1],
        [Define this if strcspn matches prototype and works])
  else
    COMPATOBJ="@S|@COMPATOBJ strcspn.lo"
  fi
]) # end of AC_DEFUN of AG_RUN_STRCSPN


AC_DEFUN([AG_RUN_STRFTIME],[
  AC_MSG_CHECKING([whether strftime() works])
  AC_CACHE_VAL([ag_cv_run_strftime],[
  AC_TRY_RUN([@%:@include <time.h>
@%:@include <string.h>
char t_buf@<:@ 64 @:>@;
int main() {
  static const char z@<:@@:>@ = "Thursday Aug 28 240";
  struct tm tm;
  tm.tm_sec   = 36;  /* seconds after the minute @<:@0, 61@:>@  */
  tm.tm_min   = 44;  /* minutes after the hour @<:@0, 59@:>@ */
  tm.tm_hour  = 12;  /* hour since midnight @<:@0, 23@:>@ */
  tm.tm_mday  = 28;  /* day of the month @<:@1, 31@:>@ */
  tm.tm_mon   =  7;  /* months since January @<:@0, 11@:>@ */
  tm.tm_year  = 86;  /* years since 1900 */
  tm.tm_wday  =  4;  /* days since Sunday @<:@0, 6@:>@ */
  tm.tm_yday  = 239; /* days since January 1 @<:@0, 365@:>@ */
  tm.tm_isdst =  1;  /* flag for daylight savings time */
  strftime( t_buf, sizeof( t_buf ), "%A %b %d %j", &tm );
  return (strcmp( t_buf, z ) != 0); }],
    [ag_cv_run_strftime=yes],[ag_cv_run_strftime=no],[ag_cv_run_strftime=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_strftime}])

  if test "X${ag_cv_run_strftime}" != Xno
  then
    AC_DEFINE([HAVE_STRFTIME],[1],
        [Define this if strftime() works])
  fi
]) # end of AC_DEFUN of AG_RUN_STRFTIME


AC_DEFUN([AG_RUN_SYS_SIGLIST],[
  AC_MSG_CHECKING([whether there is a global text array sys_siglist])
  AC_CACHE_VAL([ag_cv_run_sys_siglist],[
  AC_TRY_RUN([@%:@include <signal.h>
int main() {
  const char* pz = sys_siglist@<:@1@:>@;
  return (pz != 0) ? 0 : 1; }],
    [ag_cv_run_sys_siglist=yes],[ag_cv_run_sys_siglist=no],[ag_cv_run_sys_siglist=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_sys_siglist}])

  if test "X${ag_cv_run_sys_siglist}" != Xno
  then
    AC_DEFINE([HAVE_SYS_SIGLIST],[1],
        [Define this if there is a global text array sys_siglist])
  fi
]) # end of AC_DEFUN of AG_RUN_SYS_SIGLIST


AC_DEFUN([AG_RUN_UNAME_SYSCALL],[
  AC_MSG_CHECKING([whether uname(2) is POSIX])
  AC_CACHE_VAL([ag_cv_run_uname_syscall],[
  AC_TRY_RUN([@%:@include <sys/utsname.h>
int main() { struct utsname unm;
return uname( &unm ); }],
    [ag_cv_run_uname_syscall=yes],[ag_cv_run_uname_syscall=no],[ag_cv_run_uname_syscall=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_uname_syscall}])

  if test "X${ag_cv_run_uname_syscall}" != Xno
  then
    AC_DEFINE([HAVE_UNAME_SYSCALL],[1],
        [Define this if uname(2) is POSIX])
  fi
]) # end of AC_DEFUN of AG_RUN_UNAME_SYSCALL


AC_DEFUN([AG_RUN_FOPEN_BINARY],[
  AC_MSG_CHECKING([whether fopen accepts "b" mode])
  AC_CACHE_VAL([ag_cv_run_fopen_binary],[
  AC_TRY_RUN([@%:@include <stdio.h>
int main (int argc, char** argv) {
FILE* fp = fopen("conftest.@S|@ac_ext", "rb");
return (fp == NULL) ? 1 : fclose(fp); }],
    [ag_cv_run_fopen_binary=yes],[ag_cv_run_fopen_binary=no],[ag_cv_run_fopen_binary=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_fopen_binary}])

  if test "X${ag_cv_run_fopen_binary}" != Xno
  then
    AC_DEFINE([FOPEN_BINARY_FLAG],"b",
	[fopen(3) accepts a 'b' in the mode flag])
  else
    AC_DEFINE([FOPEN_BINARY_FLAG],"",
	[fopen(3) accepts a 'b' in the mode flag])
  fi
]) # end of AC_DEFUN of AG_RUN_FOPEN_BINARY


AC_DEFUN([AG_RUN_FOPEN_TEXT],[
  AC_MSG_CHECKING([whether fopen accepts "t" mode])
  AC_CACHE_VAL([ag_cv_run_fopen_text],[
  AC_TRY_RUN([@%:@include <stdio.h>
int main (int argc, char** argv) {
FILE* fp = fopen("conftest.@S|@ac_ext", "rt");
return (fp == NULL) ? 1 : fclose(fp); }],
    [ag_cv_run_fopen_text=yes],[ag_cv_run_fopen_text=no],[ag_cv_run_fopen_text=no]
  ) # end of TRY_RUN]) # end of AC_CACHE_VAL
  AC_MSG_RESULT([${ag_cv_run_fopen_text}])

  if test "X${ag_cv_run_fopen_text}" != Xno
  then
    AC_DEFINE([FOPEN_TEXT_FLAG],"t",
	[fopen(3) accepts a 't' in the mode flag])
  else
    AC_DEFINE([FOPEN_TEXT_FLAG],"",
	[fopen(3) accepts a 't' in the mode flag])
  fi
]) # end of AC_DEFUN of AG_RUN_FOPEN_TEXT


AC_DEFUN([INVOKE_AG_MACROS],[
  # Check to see if using shell scripts.
  AG_DISABLE_SHELL

  # Check to see if wanting autogen debugging.
  AG_ENABLE_DEBUG

  # Check to see if a reg expr header is specified.
  AG_WITH_REGEX_HEADER

  # Check to see if a working libregex can be found.
  AG_WITHLIB_REGEX

  # Check to see if a working libguile can be found.
  AG_WITHLIB_GUILE

  # Check to see if a working libxml can be found.
  AG_WITHLIB_XML

  # Check to see if ctime() allocates memory for its result.
  AG_RUN_ALLOCATED_CTIME

  # Check to see if pathfind(3) works.
  AG_RUN_PATHFIND

  # Check to see if sysinfo(2) is POSIX.
  AG_RUN_POSIX_SYSINFO

  # Check to see if strcspn matches prototype and works.
  AG_RUN_STRCSPN

  # Check to see if strftime() works.
  AG_RUN_STRFTIME

  # Check to see if there is a global text array sys_siglist.
  AG_RUN_SYS_SIGLIST

  # Check to see if uname(2) is POSIX.
  AG_RUN_UNAME_SYSCALL

  # Check to see if fopen accepts "b" mode.
  AG_RUN_FOPEN_BINARY

  # Check to see if fopen accepts "t" mode.
  AG_RUN_FOPEN_TEXT
  
  # Give preference to byacc and yacc over bison.
  # bison likes alloca.  I hate alloca.  It is not portable.
  # This is a rehack of AC_PROG_YACC
  AC_CHECK_PROGS(YACC, byacc yacc 'bison -y', "$missing_dir/missing yacc")
  
]) # end AC_DEFUN of INVOKE_AG_MACROS
