/* LocaleInformation_es.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_es extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "dinar jordano|MVDOL boliviano|oro|corona de las Islas Feroe|libra libanesa|euro|dong vietnamita|chel\u00edn tanzano|peso boliviano|riel camboyano|unidad monetaria asi\u00e1tica|boliviano (1863-1962)|antiguo riel camboyano|libra zambiana|libra australiana|franco CFA BEAC|libra maltesa|cedi revaluado ghan\u00e9s|kwacha zambiano|unidad de cuenta asi\u00e1tica en dinares|libra ghanesa|boliviano|antiguo cedi ghan\u00e9s|lira maltesa|d\u00f3lar australiano|d\u00f3lar estadounidense (mismo d\u00eda)|lira italiana|d\u00f3lar estadounidense (d\u00eda siguiente)|cedi ghan\u00e9s|d\u00f3lar singapurense|balboa paname\u00f1o|kip laosiano|som kirgu\u00eds|franco suizo|chel\u00edn austriaco|d\u00f3lar estadounidense|d\u00f3lar et\u00edope|d\u00f3lar de Brun\u00e9i|libra jamaicana|birr et\u00edope|franco germinal argelino|nuevo franco argelino|dinar argelino|guaran\u00ed paraguayo|libra libia|d\u00f3lar de Jamaica|corona islandesa|peseta espa\u00f1ola|libra de Bermudas|dinar libio|lira libia de la Autoridad Militar Brit\u00e1nica|d\u00f3lar de Bermudas|flor\u00edn neerland\u00e9s|ouguiya mauritano|rial iran\u00ed|corona sueca|nakfa eritreo|chel\u00edn keniata|franco CFA de la Rep\u00fablica Centroafricana|peso argentino|peso argentino (1983-1985)|peso moneda nacional argentino|nuevo d\u00f3lar taiwan\u00e9s|libra sudanesa|lari georgiano|kupon larit georgiano|franco de Martinica|libra de las Islas Malvinas|austral argentino|dinar sudan\u00e9s|dinar iraqu\u00ed|d\u00f3lar de Tuvalu|rupia de Seychelles|rublo let\u00f3n|libra de las Islas Fiyi|lats let\u00f3n|zaire congole\u00f1o|franco de la Rep\u00fablica del Congo|franco congole\u00f1o|d\u00f3lar de las Islas Fiyi|c\u00f3rdoba oro nicarag\u00fcense|pataca de Macao|c\u00f3rdoba oro nicarag\u00fcense|c\u00f3rdoba nicarag\u00fcense|rublo transferible del COMECON|marco finland\u00e9s (1860-1962)|marco finland\u00e9s|d\u00f3lar de las Islas Salom\u00f3n|franco luxemburgu\u00e9s|antiguo d\u00f3lar de Trinidad y Tobago|escudo angole\u00f1o|kwanza reajustado angole\u00f1o (1995-1999)|tugrik mongol|forinto h\u00fangaro|franco de Burundi|nuevo kwanza angole\u00f1o (1990-2000)|kwanza angole\u00f1o (1977-1990)|d\u00f3lar de Trinidad y Tobago|lilangeni suazi|franco CFP de las Nuevas H\u00e9bridas|libra esterlina brit\u00e1nica|riyal soberano saud\u00ed|riyal saud\u00ed|talonas lituano|rupia india|escudo portugu\u00e9s|kwanza angole\u00f1o|conto portugu\u00e9s|litas lituano|tenge kazako|rublo kazako|d\u00f3lar de las Islas V\u00edrgenes Brit\u00e1nicas|libra nigeriana|certificados de cambio birmanos en d\u00f3lares|naira nigeriano|gourde haitiano|libra siria|libra palestina|dinar bahrein\u00ed|kyat de Myanmar|flor\u00edn de las Antillas Neerlandesas|corona checa|libra esterlina de la Isla de Man|certificados de cambio b\u00falgaros en leva|loti lesothense|franco CFA de Gab\u00f3n|lev b\u00falgaro (1879-1952)|nuevo lev b\u00falgaro|lev socialista b\u00falgaro|d\u00f3lar canadiense|lev fuerte b\u00falgaro|lira turca|d\u00f3lar de las Islas Caim\u00e1n|libra chipriota|nuevo sheqel israel\u00ed|d\u00f3lar guyan\u00e9s|dram armenio|libra israel\u00ed|franco mal\u00ed|sheqel israel\u00ed|bol\u00edvar venezolano|certificados de cambio albaneses en d\u00f3lares|d\u00f3lar liberiano|lek valute alban\u00e9s|kuna croata|franco de Reuni\u00f3n|dinar croata|lek alban\u00e9s|libra esterlina de Jersey|lek alban\u00e9s (1946-1961)|dinar macedonio (1992-1993)|viet minh piastre dong viet de Vietnam del Norte|nuevo dong de Vietnam del Norte|dinar macedonio|piastre dong viet de Vietnam del Norte|pataca timorense|franco CFP|franco belga (financiero)|peso de Guinea-Biss\u00e1u|dinar kuwait\u00ed|mil reis de Guinea Portuguesa|franco belga|escudo timorense|franco belga (convertible)|escudo de Guinea Portuguesa|col\u00f3n salvadore\u00f1o|flor\u00edn de Curazao|taka de Bangladesh|libra esterlina tongana|pa\u02bbanga tongano|franco CFA BCEAO|rublo sovi\u00e9tico|nuevo rublo sovi\u00e9tico|franco germinal de Nueva Caledonia|escudo de Cabo Verde|franco CFA de las Antillas Francesas|rand sudafricano|peso dominicano|certificados de cambio cubanos|libra sudafricana|rand sudafricano (financiero)|dinar tunecino|peso cubano|franco guayan\u00e9s de la Guayana Francesa|chel\u00edn ugand\u00e9s|rupia cingalesa|franco de Affars e Issas|lira de la Ciudad del Vaticano|escudo de Santo Tom\u00e9 y Pr\u00edncipe|chel\u00edn ugand\u00e9s (1966-1987)|dobra de Santo Tom\u00e9 y Pr\u00edncipe|d\u00f3lar de las Islas Marshall|libra neozelandesa|tala samoano|libra samoana|lempira hondure\u00f1o|nuevo franco metropolitano franc\u00e9s|manat turcomano|quetzal guatemalteco|d\u00f3lar neozeland\u00e9s|libra escocesa|d\u00f3lar de Barbados|d\u00f3lar de Namibia|franco malgache|ariary malgache|libra egipcia|d\u00f3lar de Honduras Brit\u00e1nica|zloty polaco (1950-1995)|nuevo dinar bosnio|certificados de cambio polacos en d\u00f3lares estadounidenses|marco bosnio convertible|d\u00f3lar de Belice|dinar bosnio|zloty polaco|rial yemen\u00ed|flor\u00edn surinam\u00e9s|corona fuerte checoslovaca|won surcoreano|rublo bielorruso|riyal Imadi yemen\u00ed|rublo bielorruso (1992-1994)|corona checoslovaca|antiguo won surcoreano|hwan surcoreano|nuevo rublo bielorruso (1994-1999)|chel\u00edn de Somalilandia|nuevo dracma griego|rupia pakistan\u00ed|afgani|d\u00f3lar de Zimbabue|rupia de Sri Lanka|dracma griego|libra irlandesa|afgani (1927-2002)|dinar yemen\u00ed|franco ruand\u00e9s|col\u00f3n costarricense|somoni tayiko|rublo tayiko|corona estonia|peseta guineana de Guinea Ecuatorial|cup\u00f3n rublo moldavo|d\u00f3lar de Hong Kong|corona danesa|leu moldavo|franco de Guinea Ecuatorial|ekuele de Guinea Ecuatorial|rupia indonesia|dirham de los Emiratos \u00c1rabes Unidos|won norcoreano|nueva rupia indonesia|pula botsuano|cup\u00f3n leu moldavo|rupia Java indonesia|won del pueblo norcoreano|flor\u00edn Nica indonesio|vatu vanuatuense|dinar isl\u00e1mico|chel\u00edn somal\u00ed|peseta andorrana|rublo ruso (1991-1998)|franco de Guadalupe|franco de Yibuti|diner andorrano|franco germinal monegasco|nuevo franco monegasco|unidad de valor constante (UVC) ecuatoriana|sucre ecuatoriano|franco de Liechtenstein|rublo ruso|peso filipino|sum uzbeko|peso colombiano|baht tailand\u00e9s|libra de Irlanda del Norte|rupia birmana|franco CFA del Congo|kyat birmano|peso de papel colombiano|cup\u00f3n som uzbeko|karbovanet ucraniano|riyal de Qatar|grivna ucraniana|syli guineano|yuan renminbi chino|metical mozambique\u00f1o|certificados de cambio chinos en d\u00f3lares estadounidenses|peso uruguayo|franco guineo (1960-1972)|lira de San Marino|jen min piao yuan chino|escudo mozambique\u00f1o|franco guineo|rial saidi oman\u00ed|kina de Pap\u00faa Nueva Guinea|rial oman\u00ed|peso uruguayo (1975-1993)|franco UIC franc\u00e9s|rupia butanesa|zaire zaire\u00f1o|franco marroqu\u00ed|dirham marroqu\u00ed|ngultrum butan\u00e9s|franco oro franc\u00e9s|peso fuerte uruguayo|ringgit malasio|nuevo zaire zaire\u00f1o|manat azer\u00ed|libra gambiana|franco comorense|leone de Sierra Leona|dalasi gambiano|unidad de moneda europea|libra de las Bahamas|franco CFA de Camer\u00fan|unidad de inversi\u00f3n (UDI) mexicana|franco CFA BCEAEC|d\u00f3lar de las Bahamas|peso de plata mexicano (1861-1992)|peso mexicano|sol peruano|corona de Groenlandia|cruceiro brasile\u00f1o (1942-1967)|nuevo sol peruano|peso chileno|corona eslovaca|inti peruano|cruceiro brasile\u00f1o|derechos especiales de giro|franco germinal/franco Poincar\u00e9 franc\u00e9s|franco franc\u00e9s|nuevo cruzado brasile\u00f1o|unidad de fomento chilena|escudo chileno|real brasile\u00f1o|c\u00f3ndor chileno|cruceiro brasile\u00f1o (1990-1993)|sperrmark alem\u00e1n|libra de Malawi|cruzado brasile\u00f1o|nuevo cruceiro brasile\u00f1o (1967-1986)|kwacha de Malawi|rublo de Transdniestria|marco alem\u00e1n|franco CFA del Chad|nuevo rublo de Transdniestria|cup\u00f3n rublo de Transdniestria|rupia nepalesa|d\u00f3lar de las Islas Cook|yen japon\u00e9s|rufiyaa de Maldivas|nuevo franco CFA|rupia de Maldivas|d\u00f3lar del Caribe Oriental|t\u00f3lar esloveno|dinar reformado yugoslavo|flor\u00edn de Aruba|dinar de octubre yugoslavo|ostmark de Alemania del Este|dinar convertible yugoslavo|super dinar yugoslavo|corona de las Islas Turcas y Caicos|dinar 1994 yugoslavo|dinar de la Federaci\u00f3n Yugoslava|nuevo leu rumano|dinar fuerte yugoslavo|leu rumano|t\u00f3lar bons esloveno|corona noruega|rupia mauriciana|unidad de cuenta europea (XBD)|libra de Gibraltar|dong nacional vietnamita|unidad de cuenta europea (XBC)|dong de la Rep\u00fablica del vietnamita|unidad monetaria europea|unidad compuesta europea|d\u00f3lar de Kiribati|libra de Santa Elena|nuevo dong vietnamita";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|Bs|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|\u20a7|BMP|LD|LYB|Ber$|NLG|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|CNP|MZE|GF|OMS|PGK|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "ene",
    "feb",
    "mar",
    "abr",
    "may",
    "jun",
    "jul",
    "ago",
    "sep",
    "oct",
    "nov",
    "dic",
    null,
  };

  private static final String[] months = {
    "enero",
    "febrero",
    "marzo",
    "abril",
    "mayo",
    "junio",
    "julio",
    "agosto",
    "septiembre",
    "octubre",
    "noviembre",
    "diciembre",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "dom",
    "lun",
    "mar",
    "mi\u00e9",
    "jue",
    "vie",
    "s\u00e1b",
  };

  private static final String[] weekdays = {
    null,
    "domingo",
    "lunes",
    "martes",
    "mi\u00e9rcoles",
    "jueves",
    "viernes",
    "s\u00e1bado",
  };

  private static final String[] eras = {
    "a.C.",
    "d.C.",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "Hora est\u00e1ndar del Pac\u00edfico", "PDT", "Hora de verano del Pac\u00edfico",  "America/Los_Angeles" },
    { "GMT", "Hora media de Greenwich", "GMT", "Hora media de Greenwich",  "Africa/Casablanca" },
    { "EST", "Hora est\u00e1ndar oriental", "EDT", "Hora de verano oriental",  "America/New_York" },
    { "AST", "Hora est\u00e1ndar de Alaska", "ADT", "Hora de verano de Alaska",  "America/Anchorage" },
    { "GMT", "Hora media de Greenwich", "GMT", "Hora media de Greenwich",  "Etc/GMT" },
    { "CTT", "Hora est\u00e1ndar de China", "CDT", "Hora est\u00e1ndar de China",  "Asia/Shanghai" },
    { "AST", "Hora est\u00e1ndar del Atl\u00e1ntico", "ADT", "Hora de verano del Atl\u00e1ntico",  "America/Halifax" },
    { "CET", "Hora est\u00e1ndar de Europa Central", "CEST", "Hora de verano de Europa Central",  "Europe/Paris" },
    { "MST", "Hora est\u00e1ndar de Monta\u00f1a", "MDT", "Hora de verano de Monta\u00f1a",  "America/Denver" },
    { "IST", "Hora est\u00e1ndar de Israel", "IDT", "Hora de verano de Israel",  "Asia/Jerusalem" },
    { "HST", "Hora est\u00e1ndar de Hawai", "HST", "Hora est\u00e1ndar de Hawai",  "Pacific/Honolulu" },
    { "CNT", "Hora est\u00e1ndar de Newfoundland", "CDT", "Hora de verano de Newfoundland",  "America/St_Johns" },
    { "EST", "Hora est\u00e1ndar oriental", "EST", "Hora est\u00e1ndar oriental",  "America/Indianapolis" },
    { "CST", "Hora est\u00e1ndar central", "CDT", "Hora de verano central",  "America/Chicago" },
    { "EET", "Hora est\u00e1ndar de Europa del Este", "EEST", "Hora de verano de Europa del Este",  "Europe/Bucharest" },
    { "JST", "Hora est\u00e1ndar de Jap\u00f3n", "JST", "Hora est\u00e1ndar de Jap\u00f3n",  "Asia/Tokyo" },
    { "MST", "Hora est\u00e1ndar de Monta\u00f1a", "MST", "Hora est\u00e1ndar de Monta\u00f1a",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Timor Oriental|Islas Tokelau|Tayikist\u00e1n|Tailandia|Togo|Territorios Australes Franceses|Guyana|Chad|Islas Turcas y Caicos|Guinea-Bissau|Guam|Guatemala|Islas Georgia del Sur y Sandwich del Sur|Grecia|Guinea Ecuatorial|Guadalupe|Suazilandia|Siria|Guinea|Gambia|Groenlandia|El Salvador|Santo Tom\u00e9 y Pr\u00edncipe|Gibraltar|Ghana|Suriname|Guayana Francesa|Serbia|Georgia|Somalia|Granada|Senegal|San Marino|Reino Unido|Sierra Leona|Gab\u00f3n|Eslovaquia|Svalbard y Jan Mayen|Eslovenia|Santa Elena|Singapur|Suecia|Sud\u00e1n|Seychelles|Islas Salom\u00f3n|Arabia Saud\u00ed|Francia|Islas Feroe|Micronesia|Ruanda|Islas Falkland (Malvinas)|Rusia|Fiyi|Finlandia|Ruman\u00eda|R\u00e9union|Etiop\u00eda|Espa\u00f1a|Eritrea|S\u00e1hara Occidental|Egipto|Estonia|Ecuador|Argelia|Qatar|Rep\u00fablica Dominicana|Paraguay|Dominica|Palau|Dinamarca|Yibuti|Portugal|Territorios Palestinos|Puerto Rico|Alemania|Pitcairn|San Pedro y Miquel\u00f3n|Polonia|Pakist\u00e1n|Filipinas|Pap\u00faa Nueva Guinea|Polinesia Francesa|Rep\u00fablica Checa|Per\u00fa|Chipre|Isla Navidad|Cabo Verde|Panam\u00e1|Cuba|Costa Rica|Colombia|China|Camer\u00fan|Chile|Islas Cook|Costa de Marfil|Suiza|Congo|Rep\u00fablica Centroafricana|Rep\u00fablica Democr\u00e1tica del Congo|Islas Cocos (Keeling)|Om\u00e1n|Canad\u00e1|Belice|Bielorrusia|Botsuana|Isla Bouvet|But\u00e1n|Bahamas|Brasil|Nueva Zelanda|Bolivia|Brun\u00e9i|Bermudas|Isla Niue|Ben\u00edn|Burundi|Bahr\u00e1in|Nauru|Bulgaria|Burkina Faso|Nepal|B\u00e9lgica|Noruega|Bangladesh|Barbados|Zimbabue|Pa\u00edses Bajos|Bosnia-Herzegovina|Nicaragua|Nigeria|Isla Norfolk|Azerbaiy\u00e1n|N\u00edger|Nueva Caledonia|Aruba|Zambia|Namibia|Australia|Austria|Samoa Americana|Argentina|Ant\u00e1rtida|Mozambique|Angola|Malasia|Antillas Neerlandesas|M\u00e9xico|Armenia|Malawi|Albania|Maldivas|Sud\u00e1frica|Mauricio|Malta|Anguila|Montserrat|Mauritania|Antigua y Barbuda|Martinica|Afganist\u00e1n|Islas Marianas del Norte|Emiratos \u00c1rabes Unidos|Macao, Regi\u00f3n administrativa especial de China|Andorra|Mongolia|Myanmar|Mal\u00ed|Macedonia|Yugoslavia|Mayotte|Islas Marshall|Madagascar|Moldova|M\u00f3naco|Marruecos|Yemen|Libia|Letonia|Luxemburgo|Lituania|Lesotho|Liberia|Sri Lanka|Liechtenstein|Saint Lucia|L\u00edbano|Laos|Kazajst\u00e1n|Islas Caim\u00e1n|Kuwait|Corea del Sur|Corea del Norte|San Crist\u00f3bal y Nieves|Comoras|Kiribati|Samoa|Camboya|Kirguizist\u00e1n|Kenia|Wallis y Futuna|Jap\u00f3n|Jordania|Jamaica|Vanuatu|Vietnam|Islas V\u00edrgenes de los Estados Unidos|Islas V\u00edrgenes Brit\u00e1nicas|Venezuela|San Vicente y las Granadinas|Ciudad del Vaticano|Italia|Islandia|Ir\u00e1n|Iraq|Uzbekist\u00e1n|Territorios Brit\u00e1nico del Oc\u00e9ano \u00cdndico|Uruguay|India|Israel|Estados Unidos|Irlanda|Indonesia|Islas menores alejadas de los Estados Unidos|Uganda|Ucrania|Hungr\u00eda|Hait\u00ed|Croacia|Tanzania|Honduras|Islas Heard y McDonald|Taiw\u00e1n|Tuvalu|Hong-Kong, Regi\u00f3n administrativa especial de China|Trinidad y Tabago|Turqu\u00eda|Tonga|T\u00fanez|Turkmenist\u00e1n";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|root|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "kutchin|acadio|ekajuk|ijo|xhosa|sumerio|susu|lenguas varias|lozi|tonga (Niasa)|pohnpeiano|minangkabau|sukuma|uolof|mongo|kutenai|micmac|val\u00f3n|kumyk|zapoteco|cusitas (otras)|lojban|dogri|volapuk|lenguas otomanas|vietnamita|vai|rarotongano|venda|rapanui|rajasthani|turco otomano (1500-1928)|nzima|napolitano|uzbeko|ugar\u00edtico|tamashek|indias norteamericanas (otras)|n\u00e1huatl|urdu|fanti|ucraniano|egipcio (antiguo)|uigur|fang|nilosaharianas (otras)|irland\u00e9s medieval (900-1200)|b\u00e1lticas (otras)|nyoro|basa|nyankole|nyamwezi|hmong|balin\u00e9s|osage|baluchi|tahitiano|lenguas bamileke|twi|serer|tlingit|tatar|tsonga|banda|turco|tonga (Islas Tonga)|setchwana|tagalo|turkmeno|tigrinya|tailand\u00e9s|kurukh|tayiko|blin|telugu|kru|casubio|tamil|tokelauano|efik|swahili|sueco|sundan\u00e9s|karachay-balkar|sesotho|siswati|serbio|alban\u00e9s|mende|criollas y pidgins (otras)|somal\u00ed|afrihili|shona|samoano|esloveno|griego antiguo (hasta el 1453)|eslovaco|gerbo|singal\u00e9s|serbo-croata|turco de Crimea; t\u00e1rtaro de Crimea|afroasi\u00e1tica (otra)|sango|sami septentrional|sindhi|udmurt|sardo|s\u00e1nscrito|kinyarwanda|ruso|mandar|rumano|kiroundi|reto-romance|moksha|tiv|adigeo|zuni|kpelle|quechua|tigr\u00e9|songhai|criollas y pidgins, basadas en el portugu\u00e9s (otras)|sogdiano|adangme|kosraeano|hitita|criollas y pidgins, basadas en el ingl\u00e9s (otras)|himachali|konkani|hiligaynon|g\u00f3tico|gorontalo|gondi|dinka|lenguas nubias|portugu\u00e9s|pashto|friulano|fenicio|alem\u00e1n de la alta edad antigua (750-1050 aprox.)|sonink\u00e9|copto|yap\u00e9s|acoli|yao|filipinas (otras)|polaco|acehn\u00e9s|pali|punjab\u00ed|bugin\u00e9s|iban|sami sklot|buriat|masai|sami inari|os\u00e9tico|austronesio|oriya|mandingo|sami lule|lenguas sami (otras)|macasar|oromo|maithili|ojibwa|magahi|madur\u00e9s|sami meridional|occitano (despu\u00e9s del 1500)|sesotho septentrional|batak|erzya|dogrib|nyanja|maya|navajo|kimbundu|ndebele meridional|alem\u00e1n de la alta edad media (1050-1500 aprox.)|noruego|nynorsk noruego|holand\u00e9s|ra\u00edz|ndonga|eslavas (otras)|nepal\u00ed|ndebele septentrional|lenguas ch\u00e1micas|tet\u00fan|bokmal noruego|nauruano|tereno|temne|birmano|lezgiano|malt\u00e9s|persa antiguo (600-400 a.C. aprox.)|malayo|marathi|franc\u00e9s antiguo (842-1400 aprox.)|moldavo|franc\u00e9s medieval (1400-1600 aprox.)|mongol|judeo-\u00e1rabe|malayalam|macedonio|maor\u00ed|marshal\u00e9s|malgache|marwari|braj|slave|let\u00f3n|luba-katanga|delaware|lituano|laosiano|lingala|limburgu\u00e9s|ewondo|ganda|luxemburgu\u00e9s|lat\u00edn|judeo-persa|v\u00f3tico|sino-tibetanas (otras)|kirghiz|c\u00f3rnico|komi|kurdo|lenguas siouan|cachemiro|kanuri|avadhi|coreano|canar\u00e9s|jemer|groenland\u00e9s|kazajo|roman\u00ed|kuanyama|sidamo|kikuyu|kongo|norse antiguo|georgiano|creek|rom\u00e1nicas (otras)|nogai|lenguas munda|lenguas m\u00faltiples|javan\u00e9s|gilbert\u00e9s|zande|shan|fon|kalmyk|lenguas australianas|kotan\u00e9s|japon\u00e9s|khoisan (otras)|palavano|cheyene|tai (otras)|inuktitut|papiamento|italiano|lenguajes de signos|island\u00e9s|khasi|cherokee|pampanga|pahlavi|chipewyan|ido|choctaw|jerga chinuk|mar\u00ed|tuviniano|bant\u00fa|pangasin\u00e1n|inupiak|truk\u00e9s|sichuan yi|hawaiano|lamba|igbo|chagat\u00e1i|irland\u00e9s antiguo (hasta 900)|pap\u00faes (otras)|interlingue|indonesio|lahnda|dayak|chibcha|interlingua|ladino|herero|haida|dargva|armenio|lenguas atabascas|h\u00fangaro|haitiano|dakota|croata|hiri motu|hindi|diula|hebreo|asturiano|hausa|lenguas sorbias|ga\u00e9lico man\u00e9s|gujarati|sem\u00edticas (otras)|selkup|lenguas iroquesas|guaran\u00ed|gallego|arahuaco|geez|artificiales (otras)|ga\u00e9lico escoc\u00e9s|iranio|irland\u00e9s|arapaho|araucano|fris\u00f3n|siksika|germ\u00e1nicas (otras)|lenguas yupik|arameo|franc\u00e9s|fero\u00e9s|celtas (otras)|fidji|finland\u00e9s|fula|tuvaluano|cebuano|farsi|vasco|escoc\u00e9s|estonio|espa\u00f1ol|esperanto|ingl\u00e9s|griego|altaicas (otras)|niueano|lenguas tup\u00ed|ewe|tumbuka|mossi|bhutan\u00ed|n\u00edger-kordofanianas (otras)|lushai|finougrias (otras)|divehi|nias|mohawk|luo|lunda|lenguas apache|luise\u00f1o|hupa|bini|alem\u00e1n|luba-lulua|bicol|washo|indeterminada|waray|dan\u00e9s|neerland\u00e9s medio (1050-1350 aprox.)|walamo|lenguas manobo|lenguas wakasha|santali|gal\u00e9s|sasak|kabardiana|chuvash|eslavo eclesi\u00e1stico|manipuri|checo|arameo samaritano|cree|lenguas salishan|duala|corso|indias sudamericanas (otras)|manch\u00fa|yakut|kawi|ingush|gbaya|sandawe|chamorro|indoeuropeas (otras)|bhojpuri|ingl\u00e9s medieval (1100-1500)|karen|\u00edndicas (otras)|checheno|gayo|catal\u00e1n|umbundu|siriaco|kamba|tsimshiano|ingl\u00e9s antiguo (450-1100 aprox.)|kachin|cauc\u00e1sicas (otras)|cabila|karakalpako|bosnio|caribe|bret\u00f3n|tibetano|bengal\u00ed|bambara|ga|indias centroamericanas (otras)|bislama|bihari|b\u00falgaro|bielorruso|caddo|bashkir|zul\u00fa|zenaga|provenzal antiguo (hasta el 1500)|sorbio superior|azer\u00ed|aymara|avar|asam\u00e9s|sorbio inferior|\u00e1rabe|ilocano|elamita|chino|aragon\u00e9s|lenguas prakrit|am\u00e1rico|newari|akan|zhuang|afrikaans|av\u00e9stico|abkhaziano|afar|yoruba|lenguas algonquinas|aleutiano|mon-jemer (otras)|yidish|drav\u00eddicas (otras)|bereber|bajo alem\u00e1n; bajo saj\u00f3n|bemba|beja|tok pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "Revisado";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "currencyFormat", "\u00a4#,##0.00;(\u00a4#,##0.00)" },
    { "localPatternChars", "GuMtkHmsSEDFwWahKzUeygAZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "d/MM/yy" },
    { "mediumDateFormat", "dd-MMM-yy" },
    { "longDateFormat", "d' de 'MMMM' de 'yyyy" },
    { "fullDateFormat", "EEEE d' de 'MMMM' de 'yyyy" },
    { "fullTimeFormat", "HH'H'mm''ss\" z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
