//
// ContentInfoTest.cs - NUnit tests for ContentInfo
//
// Author:
//	Sebastien Pouliot (spouliot@motus.com)
//
// (C) 2003 Motus Technologies Inc. (http://www.motus.com)
//

#if NET_1_2

using NUnit.Framework;

using System;
using System.Security.Cryptography;
using System.Security.Cryptography.Pkcs;

using Mono.Security;

namespace MonoTests.System.Security.Cryptography.Pkcs {

	[TestFixture]
	public class ContentInfoTest : Assertion {

		static string defaultOid = "1.2.840.113549.1.7.1";
		static string defaultName = "PKCS 7 Data";
		static byte[] asnNull = { 0x05, 0x00 };
		static string asnNullString = "05-00";

		[Test]
		public void ConstructorContent () 
		{
			ContentInfo ci = new ContentInfo (asnNull);
			AssertEquals ("Content", asnNullString, BitConverter.ToString (ci.Content));
			AssertEquals ("ContentType.FriendlyName", defaultName, ci.ContentType.FriendlyName);
			AssertEquals ("ContentType.Value", defaultOid, ci.ContentType.Value);
		}

		[Test]
		[ExpectedException (typeof (ArgumentNullException))]
		public void ConstructorOidNull () 
		{
			ContentInfo ci = new ContentInfo (null);
		}

		[Test]
		public void ConstructorOidContent () 
		{
			Oid o = new Oid (defaultOid);
			ContentInfo ci = new ContentInfo (o, asnNull);
			AssertEquals ("Content", asnNullString, BitConverter.ToString (ci.Content));
			AssertEquals ("ContentType.FriendlyName", defaultName, ci.ContentType.FriendlyName);
			AssertEquals ("ContentType.Value", defaultOid, ci.ContentType.Value);
		}

		[Test]
		[ExpectedException (typeof (ArgumentNullException))]
		public void ConstructorOidNullContent () 
		{
			ContentInfo ci = new ContentInfo (null, asnNull);
		}

		[Test]
		[ExpectedException (typeof (ArgumentNullException))]
		public void ConstructorOidContentNull ()
		{
			Oid o = new Oid (defaultOid);
			ContentInfo ci = new ContentInfo (o, null);
		}

		[Test]
		public void GetContentType () 
		{
			byte[] pkcs7ContentInfo = {
				0x30, 0x82, 0x03, 0x04, 0x30, 0x0B, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 
				0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x02, 0xF3, 0x30, 0x82, 0x02, 
				0xEF, 0x30, 0x82, 0x02, 0x5A, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x01, 
				0x6C, 0x30, 0x0B, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 
				0x01, 0x05, 0x30, 0x56, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 
				0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 
				0x04, 0x0A, 0x13, 0x0F, 0x55, 0x2E, 0x53, 0x2E, 0x20, 0x47, 0x6F, 0x76, 
				0x65, 0x72, 0x6E, 0x6D, 0x65, 0x6E, 0x74, 0x31, 0x0C, 0x30, 0x0A, 0x06, 
				0x03, 0x55, 0x04, 0x0B, 0x13, 0x03, 0x44, 0x6F, 0x44, 0x31, 0x0D, 0x30, 
				0x0B, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x04, 0x4E, 0x61, 0x76, 0x79, 
				0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x07, 0x4E, 
				0x61, 0x76, 0x79, 0x20, 0x43, 0x41, 0x30, 0x1E, 0x17, 0x0D, 0x30, 0x32, 
				0x31, 0x30, 0x31, 0x31, 0x31, 0x33, 0x31, 0x32, 0x35, 0x30, 0x5A, 0x17, 
				0x0D, 0x30, 0x34, 0x31, 0x30, 0x31, 0x30, 0x31, 0x33, 0x31, 0x32, 0x35, 
				0x30, 0x5A, 0x30, 0x81, 0x8B, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 
				0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 
				0x55, 0x04, 0x0A, 0x13, 0x0F, 0x55, 0x2E, 0x53, 0x2E, 0x20, 0x47, 0x6F, 
				0x76, 0x65, 0x72, 0x6E, 0x6D, 0x65, 0x6E, 0x74, 0x31, 0x0C, 0x30, 0x0A, 
				0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x03, 0x44, 0x6F, 0x44, 0x31, 0x0D, 
				0x30, 0x0B, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x04, 0x4E, 0x61, 0x76, 
				0x79, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x09, 
				0x6C, 0x6F, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x73, 0x31, 0x1B, 0x30, 
				0x19, 0x06, 0x03, 0x55, 0x04, 0x07, 0x13, 0x12, 0x41, 0x6E, 0x6E, 0x61, 
				0x70, 0x6F, 0x6C, 0x69, 0x73, 0x20, 0x4A, 0x75, 0x6E, 0x63, 0x74, 0x69, 
				0x6F, 0x6E, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 
				0x0B, 0x4E, 0x61, 0x76, 0x79, 0x20, 0x55, 0x73, 0x65, 0x72, 0x20, 0x31, 
				0x30, 0x81, 0x9F, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 
				0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8D, 0x00, 0x30, 0x81, 
				0x89, 0x02, 0x81, 0x81, 0x00, 0xB7, 0x7E, 0x94, 0x5F, 0xE8, 0x2A, 0xE7, 
				0xAD, 0x82, 0x16, 0x2C, 0x3D, 0x2F, 0x5E, 0x88, 0x67, 0xF0, 0x23, 0x26, 
				0x15, 0x34, 0x04, 0x1F, 0x63, 0x8B, 0xFE, 0xFB, 0xBB, 0x0D, 0xC0, 0x7E, 
				0xF0, 0x46, 0x82, 0x09, 0xA2, 0x91, 0xE0, 0xEA, 0xEF, 0xD0, 0x43, 0xCB, 
				0x30, 0x45, 0xAC, 0x7C, 0xAC, 0xFC, 0xBE, 0x54, 0x79, 0x77, 0xA9, 0x6A, 
				0x45, 0xF5, 0xBF, 0xE5, 0xEF, 0x97, 0x11, 0x63, 0xC2, 0xF7, 0x3C, 0x73, 
				0x6D, 0xBA, 0x8D, 0xFE, 0xAE, 0x28, 0x4A, 0x29, 0xE4, 0xA2, 0x59, 0x0C, 
				0x8F, 0x1A, 0x57, 0x86, 0xF2, 0x42, 0xF7, 0x35, 0x0B, 0xC3, 0xA5, 0x31, 
				0xD8, 0x19, 0xE2, 0x97, 0x7A, 0xA1, 0xF4, 0xE5, 0xDB, 0xCA, 0xF5, 0x54, 
				0x39, 0x1D, 0x0E, 0xDF, 0x78, 0x73, 0xBF, 0x86, 0x97, 0x40, 0xAA, 0x06, 
				0x8E, 0x8B, 0x6B, 0x0C, 0x06, 0x98, 0xD7, 0xD2, 0x1D, 0x45, 0xAA, 0x7F, 
				0xA5, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x81, 0x9A, 0x30, 0x81, 0x97, 
				0x30, 0x1F, 0x06, 0x03, 0x55, 0x1D, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 
				0x14, 0xFB, 0x96, 0xF0, 0x10, 0xC4, 0x37, 0x55, 0xF0, 0xCE, 0xB5, 0xA6, 
				0xE2, 0xF1, 0x19, 0xFF, 0x99, 0x1A, 0xAE, 0x6E, 0x58, 0x30, 0x1D, 0x06, 
				0x03, 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0x02, 0x48, 0x78, 0xB9, 
				0xCC, 0x01, 0x51, 0x31, 0x74, 0x7F, 0x39, 0x2A, 0x37, 0xC2, 0x44, 0x93, 
				0x7E, 0x98, 0x69, 0x80, 0x30, 0x0B, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x04, 
				0x04, 0x03, 0x02, 0x04, 0xF0, 0x30, 0x17, 0x06, 0x03, 0x55, 0x1D, 0x20, 
				0x04, 0x10, 0x30, 0x0E, 0x30, 0x0C, 0x06, 0x0A, 0x60, 0x86, 0x48, 0x01, 
				0x65, 0x03, 0x02, 0x01, 0x30, 0x01, 0x30, 0x2F, 0x06, 0x03, 0x55, 0x1D, 
				0x11, 0x04, 0x28, 0x30, 0x26, 0x81, 0x24, 0x4E, 0x61, 0x76, 0x79, 0x31, 
				0x40, 0x77, 0x61, 0x72, 0x72, 0x65, 0x6E, 0x74, 0x6F, 0x6E, 0x2E, 0x61, 
				0x74, 0x6C, 0x2E, 0x67, 0x65, 0x74, 0x72, 0x6F, 0x6E, 0x69, 0x63, 0x73, 
				0x67, 0x6F, 0x76, 0x2E, 0x63, 0x6F, 0x6D, 0x30, 0x0B, 0x06, 0x09, 0x2A, 
				0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x05, 0x03, 0x81, 0x81, 0x00, 
				0x1D, 0xB0, 0x1C, 0x88, 0x4D, 0xA2, 0x68, 0x25, 0x08, 0x8F, 0xA3, 0xAC, 
				0xC3, 0x18, 0xD5, 0xBF, 0x56, 0x7C, 0xA1, 0xF2, 0x7C, 0x76, 0x39, 0x8D, 
				0x12, 0x42, 0x17, 0xE6, 0x49, 0x02, 0x39, 0xAE, 0xBB, 0x75, 0x70, 0x4B, 
				0x65, 0xEF, 0x0E, 0x3A, 0xC2, 0x33, 0xD9, 0x94, 0xDF, 0x5F, 0xA6, 0x12, 
				0x64, 0x8F, 0x04, 0x76, 0x2C, 0xAF, 0x92, 0x37, 0x4C, 0xF1, 0x94, 0x99, 
				0x52, 0xFD, 0x61, 0x95, 0x00, 0x2B, 0x9D, 0x0D, 0x35, 0xB9, 0x7C, 0x6A, 
				0x4C, 0xBB, 0x8D, 0x8A, 0x7B, 0x93, 0x37, 0x02, 0xC8, 0x81, 0x0B, 0xBD, 
				0xB9, 0x45, 0x51, 0x03, 0xBA, 0xD3, 0xF4, 0xBD, 0x72, 0x10, 0x05, 0xE9, 
				0xC1, 0x6E, 0xFE, 0xC5, 0x76, 0x2C, 0x6A, 0x6A, 0x16, 0x2F, 0x0C, 0x54, 
				0x44, 0x0D, 0x15, 0xC7, 0xA5, 0x41, 0xB1, 0x05, 0xE8, 0x4B, 0xF3, 0x60, 
				0x92, 0xEB, 0xD4, 0xF7, 0x93, 0xFF, 0x67, 0x4E, 0xF7, 0x93, 0xFF, 0x67, 
				0x4E };

			Oid o = ContentInfo.GetContentType (pkcs7ContentInfo);
			AssertEquals ("GetContentType", defaultOid, o.Value);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void GetContentTypeBadASN1 () 
		{
			// ContentInfo ::= SEQUENCE {
			ASN1 contentInfo = new ASN1 (0x30);
			// contentType ContentType, -> ContentType ::= OBJECT IDENTIFIER
			contentInfo.Add (ASN1Convert.FromOID (defaultOid));
			// content [0] EXPLICIT ANY DEFINED BY contentType OPTIONAL 
			contentInfo.Add (new ASN1 (asnNull));
			
			Oid o = ContentInfo.GetContentType (contentInfo.GetBytes ());
			AssertEquals ("GetContentType", defaultOid, o.Value);
		}

		[Test]
		//BUG [ExpectedException (typeof (ArgumentNullException))]
		[ExpectedException (typeof (NullReferenceException))]
		public void GetContentTypeNull () 
		{
			Oid o = ContentInfo.GetContentType (null);
		}
	}
}

#endif
