/*
 * EntryPoint.cs - Main entry point to the "Curse of Frogger" game.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace Frogger
{

using System;
using Curses;

public class EntryPoint
{
	// Internal state.
	private static MainBoard board;

	public static int Main(String[] args)
			{
				int ch;
				Frog.PlayResult result;

				// Initialize the curses library.
				if(!Setup.Initialize())
				{
					Console.Error.WriteLine
						("Could not initialize the curses library");
					return 1;
				}

				// Keep the cursor docked out of the way at all times.
				Misc.DockedCursor = true;

				// Draw the game banner and wait for a keystroke.
				Banner.DrawBanner(Window.Screen);
				Input.GetNextChar();

				// Create the main game board and draw it.
				board = new MainBoard(Window.Screen);
				board.Draw();

				// Keep playing the game until the user quits.
				Misc.ReportTimeouts = true;
				while((result = board.Frog.Play()) != Frog.PlayResult.Quit)
				{
					board.StopEvents();
					if(result == Frog.PlayResult.Dead)
					{
						ch = Input.GetNextChar();
						if(ch == 0x1B || ch == 'q' || ch == 'Q')
						{
							break;
						}
					}
					board.NewLevel();
				}

				// Shutdown and exit.
				Window.Screen.Clear();
				Window.Screen.Refresh();
				Setup.Shutdown();
				return 0;
			}

} // class EntryPoint

} // namespace Frogger
