/*
 * AuthorizationRule.cs - Implementation of the
 *			"System.Security.AccessControl.AuthorizationRule" class.
 *
 * Copyright (C) 2004  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace System.Security.AccessControl
{

#if CONFIG_ACCESS_CONTROL

using System.Security.Principal;

public abstract class AuthorizationRule
{
	// Internal state.
	private IdentityReference identity;
	private int accessMask;
	private bool isInherited;
	private InheritanceFlags inheritanceFlags;
	private PropagationFlags propagationFlags;

	// Constructor.
	protected internal AuthorizationRule
				(IdentityReference identity, int accessMask,
				 bool isInherited, InheritanceFlags inheritanceFlags,
				 PropagationFlags propagationFlags)
			{
				if(identity == null)
				{
					throw new ArgumentNullException("identity");
				}
				this.identity = identity;
				this.accessMask = accessMask;
				this.isInherited = isInherited;
				this.inheritanceFlags = inheritanceFlags;
				this.propagationFlags = propagationFlags;
			}

	// Get this object's properties.
	protected internal int AccessMask
			{
				get
				{
					return accessMask;
				}
			}
	public IdentityReference IdentityReference
			{
				get
				{
					return identity;
				}
			}
	public InheritanceFlags InheritanceFlags
			{
				get
				{
					return inheritanceFlags;
				}
			}
	public bool IsInherited
			{
				get
				{
					return isInherited;
				}
			}
	public PropagationFlags PropagationFlags
			{
				get
				{
					return propagationFlags;
				}
			}

}; // class AuthorizationRule

#endif // CONFIG_ACCESS_CONTROL

}; // namespace System.Security.AccessControl
