/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;

public class Schematic {
    private static HashSet cellsChecked;
    private static ErrorLogger errorLogger;

    public static ErrorLogger doCheck(Cell cell) {
        cellsChecked = new HashSet();
        if (errorLogger != null) {
            errorLogger.delete();
        }
        errorLogger = ErrorLogger.newInstance("Schematic DRC");
        Schematic.checkSchematicCellRecursively(cell);
        errorLogger.termLogging(true);
        cellsChecked = null;
        return errorLogger;
    }

    private static void checkSchematicCellRecursively(Cell cell) {
        cellsChecked.add(cell);
        if (!cell.isSchematic() && cell.getTechnology() != Schematics.tech) {
            return;
        }
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell)) continue;
            Cell subCell = (Cell)np;
            Cell contentsCell = subCell.contentsView();
            if (contentsCell == null) {
                contentsCell = subCell;
            }
            if (cellsChecked.contains(contentsCell) || ni.isIconOfParent()) continue;
            Schematic.checkSchematicCellRecursively(contentsCell);
        }
        System.out.println("Checking schematic " + cell);
        Schematic.checkSchematicCell(cell, false);
    }

    private static void checkSchematicCell(Cell cell, boolean justThis) {
        if (justThis) {
            errorLogger = ErrorLogger.newInstance("Schematic DRC");
        }
        int initialErrorCount = errorLogger.getNumErrors();
        Netlist netlist = NetworkTool.getUserNetlist(cell);
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() instanceof PrimitiveNode && ni.getProto().getTechnology() == Generic.tech) continue;
            Schematic.schematicDoCheck(netlist, ni);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Schematic.schematicDoCheck(netlist, ai);
        }
        int errorCount = errorLogger.getNumErrors();
        int thisErrors = errorCount - initialErrorCount;
        String indent = "   ";
        if (justThis) {
            indent = "";
        }
        if (thisErrors == 0) {
            System.out.println(indent + "No errors found");
        } else {
            System.out.println(indent + thisErrors + " errors found");
        }
        if (justThis) {
            errorLogger.termLogging(true);
        }
    }

    private static void schematicDoCheck(Netlist netlist, Geometric geom) {
        Cell cell = geom.getParent();
        if (geom instanceof NodeInst) {
            Iterator it;
            ErrorLogger.MessageLog err;
            Iterator it2;
            boolean found;
            NodeInst ni = (NodeInst)geom;
            NodeProto np = ni.getProto();
            if (np == Schematics.tech.busPinNode) {
                Connection con;
                if (ni.getNumExports() == 0) {
                    found = false;
                    it2 = ni.getConnections();
                    while (it2.hasNext()) {
                        con = (Connection)it2.next();
                        if (con.getArc().getProto() != Schematics.tech.bus_arc) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        err = errorLogger.logError("Bus pin does not connect to any bus arcs", cell, 0);
                        err.addGeom(geom, true, cell, null);
                        return;
                    }
                }
                int i = 0;
                it2 = ni.getConnections();
                while (it2.hasNext()) {
                    con = (Connection)it2.next();
                    if (con.getArc().getProto() != Schematics.tech.wire_arc) continue;
                    ++i;
                }
                if (i > 1) {
                    err = errorLogger.logError("Wire arcs cannot connect through a bus pin", cell, 0);
                    err.addGeom(geom, true, cell, null);
                    it = ni.getConnections();
                    while (it.hasNext()) {
                        Connection con2 = (Connection)it.next();
                        if (con2.getArc().getProto() == Schematics.tech.wire_arc) {
                            ++i;
                        }
                        err.addGeom(con2.getArc(), true, cell, null);
                    }
                    return;
                }
            }
            if (np.getFunction() == PrimitiveNode.Function.PIN) {
                if (ni.getNumExports() == 0 && ni.getNumConnections() == 0) {
                    found = false;
                    it2 = ni.getVariables();
                    while (it2.hasNext()) {
                        Variable var = (Variable)it2.next();
                        if (!var.isDisplay()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        err = errorLogger.logError("Stranded pin (not connected or exported)", cell, 0);
                        err.addGeom(geom, true, cell, null);
                        return;
                    }
                }
                if (ni.isInlinePin()) {
                    ErrorLogger.MessageLog err2 = errorLogger.logError("Unnecessary pin (between 2 arcs)", cell, 0);
                    err2.addGeom(geom, true, cell, null);
                    return;
                }
                Point2D pinLoc = ni.invisiblePinWithOffsetText(false);
                if (pinLoc != null) {
                    err = errorLogger.logError("Invisible pin has text in different location", cell, 0);
                    err.addGeom(geom, true, cell, null);
                    err.addLine(ni.getAnchorCenterX(), ni.getAnchorCenterY(), pinLoc.getX(), pinLoc.getY(), cell);
                    return;
                }
            }
            if (np instanceof Cell) {
                Cell instCell = (Cell)np;
                Cell contentsCell = instCell.contentsView();
                if (contentsCell == null) {
                    contentsCell = instCell;
                }
                it = ni.getVariables();
                while (it.hasNext()) {
                    ErrorLogger.MessageLog err3;
                    String trueVarName;
                    Variable var = (Variable)it.next();
                    if (!var.isParam()) continue;
                    Variable foundVar = null;
                    Iterator cIt = contentsCell.getVariables();
                    while (cIt.hasNext()) {
                        Variable fVar = (Variable)cIt.next();
                        if (!fVar.isParam() || var.getKey() != fVar.getKey()) continue;
                        foundVar = fVar;
                        break;
                    }
                    if (foundVar == null) {
                        trueVarName = var.getTrueName();
                        err3 = errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " is invalid", cell, 0);
                        err3.addGeom(geom, true, cell, null);
                        continue;
                    }
                    if (var.getUnit() != foundVar.getUnit()) {
                        trueVarName = var.getTrueName();
                        err3 = errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " had incorrect units (now fixed)", cell, 0);
                        err3.addGeom(geom, true, cell, null);
                        var.setUnit(foundVar.getUnit());
                    }
                    if (foundVar.isInterior()) {
                        if (!var.isDisplay()) continue;
                        trueVarName = var.getTrueName();
                        err3 = errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " should not be visible (now fixed)", cell, 0);
                        err3.addGeom(geom, true, cell, null);
                        var.setDisplay(false);
                        continue;
                    }
                    if (var.isDisplay()) continue;
                    trueVarName = var.getTrueName();
                    err3 = errorLogger.logError("Parameter '" + trueVarName + "' on " + ni + " should be visible (now fixed)", cell, 0);
                    err3.addGeom(geom, true, cell, null);
                    var.setDisplay(true);
                }
            }
        } else {
            int signals;
            Name name;
            ArcInst ai = (ArcInst)geom;
            boolean checkDangle = false;
            Name arcName = ai.getNameKey();
            if (arcName == null || arcName.isTempname()) {
                checkDangle = true;
            }
            if (checkDangle && ai.getProto() == Schematics.tech.bus_arc && (name = netlist.getBusName(ai)) != null && !name.isTempname()) {
                checkDangle = false;
            }
            if (checkDangle) {
                for (int i = 0; i < 2; ++i) {
                    NodeInst ni = ai.getPortInst(i).getNodeInst();
                    if (ni.getProto().getFunction() != PrimitiveNode.Function.PIN || ni.getNumExports() != 0 || ni.getNumConnections() != 1) continue;
                    ErrorLogger.MessageLog err = errorLogger.logError("Arc dangles", cell, 0);
                    err.addGeom(geom, true, cell, null);
                    return;
                }
            }
            if ((signals = netlist.getBusWidth(ai)) < 1) {
                signals = 1;
            }
            for (int i = 0; i < 2; ++i) {
                int nodeSize;
                PortInst pi = ai.getPortInst(i);
                NodeInst ni = pi.getNodeInst();
                if (!(ni.getProto() instanceof Cell)) continue;
                Cell subNp = (Cell)ni.getProto();
                PortProto pp = pi.getPortProto();
                Cell np = subNp.contentsView();
                if (np != null && ((pp = ((Export)pi.getPortProto()).getEquivalent()) == null || pp == pi.getPortProto())) {
                    ErrorLogger.MessageLog err = errorLogger.logError("Arc " + ai.describe(true) + " connects to " + pi.getPortProto() + " of " + ni + ", but there is no equivalent port in " + np, cell, 0);
                    err.addGeom(geom, true, cell, null);
                    err.addGeom(ni, true, cell, null);
                    continue;
                }
                int portWidth = netlist.getBusWidth((Export)pp);
                if (portWidth < 1) {
                    portWidth = 1;
                }
                if ((nodeSize = ni.getNameKey().busWidth()) <= 0) {
                    nodeSize = 1;
                }
                if (signals == portWidth || signals == portWidth * nodeSize) continue;
                ErrorLogger.MessageLog err = errorLogger.logError("Arc " + ai.describe(true) + " (" + signals + " wide) connects to " + pp + " of " + ni + " (" + portWidth + " wide)", cell, 0);
                err.addGeom(geom, true, cell, null);
                err.addGeom(ni, true, cell, null);
            }
        }
        Schematic.checkObjectVicinity(netlist, geom, geom, DBMath.MATID);
    }

    private static void checkObjectVicinity(Netlist netlist, Geometric topGeom, Geometric geom, AffineTransform trans) {
        block6: {
            block4: {
                AffineTransform localTrans;
                NodeProto np;
                NodeInst ni;
                block5: {
                    if (!(geom instanceof NodeInst)) break block4;
                    ni = (NodeInst)geom;
                    np = ni.getProto();
                    localTrans = ni.rotateOut();
                    localTrans.preConcatenate(trans);
                    if (!(np instanceof Cell)) break block5;
                    if (!ni.isExpanded()) break block6;
                    AffineTransform subRot = ni.translateOut();
                    subRot.preConcatenate(localTrans);
                    Cell subCell = (Cell)np;
                    Iterator it = subCell.getNodes();
                    while (it.hasNext()) {
                        NodeInst subNi = (NodeInst)it.next();
                        Schematic.checkObjectVicinity(netlist, topGeom, subNi, subRot);
                    }
                    it = subCell.getArcs();
                    while (it.hasNext()) {
                        ArcInst subAi = (ArcInst)it.next();
                        Schematic.checkObjectVicinity(netlist, topGeom, subAi, subRot);
                    }
                    break block6;
                }
                Technology tech = np.getTechnology();
                Poly[] polyList = tech.getShapeOfNode(ni);
                int total = polyList.length;
                for (int i = 0; i < total; ++i) {
                    Poly poly = polyList[i];
                    poly.transform(localTrans);
                    Schematic.checkPolygonVicinity(netlist, topGeom, poly);
                }
                break block6;
            }
            ArcInst ai = (ArcInst)geom;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polyList = tech.getShapeOfArc(ai);
            int total = polyList.length;
            for (int i = 0; i < total; ++i) {
                Poly poly = polyList[i];
                poly.transform(trans);
                Schematic.checkPolygonVicinity(netlist, topGeom, poly);
            }
        }
    }

    private static boolean checkPolygonVicinity(Netlist netlist, Geometric geom, Poly poly) {
        Poly.Type style = poly.getStyle();
        if (style.isText()) {
            return false;
        }
        Cell cell = geom.getParent();
        NodeInst ni = null;
        ArcInst ai = null;
        if (geom instanceof NodeInst) {
            ni = (NodeInst)geom;
        } else {
            ai = (ArcInst)geom;
        }
        Rectangle2D bounds = geom.getBounds();
        Iterator sIt = cell.searchIterator(bounds);
        while (sIt.hasNext()) {
            boolean found;
            Geometric oGeom = (Geometric)sIt.next();
            if (geom == oGeom) continue;
            if (oGeom instanceof NodeInst) {
                NodeInst oNi = (NodeInst)oGeom;
                if (oNi.getProto() instanceof PrimitiveNode && oNi.getProto().getTechnology() == Generic.tech) continue;
                if (geom instanceof NodeInst) {
                    found = false;
                    Iterator it = ni.getConnections();
                    while (it.hasNext()) {
                        Connection con = (Connection)it.next();
                        Iterator oIt = oNi.getConnections();
                        while (oIt.hasNext()) {
                            Connection oCon = (Connection)oIt.next();
                            if (!netlist.sameNetwork(con.getArc(), oCon.getArc())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                    if (found) {
                        continue;
                    }
                } else {
                    found = false;
                    Iterator oIt = oNi.getConnections();
                    while (oIt.hasNext()) {
                        Connection oCon = (Connection)oIt.next();
                        if (!netlist.sameNetwork(ai, oCon.getArc())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                if (!Schematic.checkPoly(geom, poly, oGeom, oGeom, DBMath.MATID, false)) continue;
                return true;
            }
            ArcInst oAi = (ArcInst)oGeom;
            if (geom instanceof NodeInst) {
                found = false;
                Iterator it = ni.getConnections();
                while (it.hasNext()) {
                    Connection con = (Connection)it.next();
                    if (!netlist.sameNetwork(oAi, con.getArc())) continue;
                    found = true;
                    break;
                }
                if (found || !Schematic.checkPoly(geom, poly, oGeom, oGeom, DBMath.MATID, false)) continue;
                return true;
            }
            if (Schematic.checkColinear(ai, oAi)) {
                return true;
            }
            boolean connected = false;
            if (netlist.sameNetwork(ai, oAi)) {
                connected = true;
            } else {
                int aiBusWidth = netlist.getBusWidth(ai);
                int oAiBusWidth = netlist.getBusWidth(oAi);
                if (aiBusWidth > 1 && oAiBusWidth <= 1) {
                    for (int i = 0; i < aiBusWidth; ++i) {
                        if (netlist.getNetwork(ai, i) != netlist.getNetwork(oAi, 0)) continue;
                        connected = true;
                        break;
                    }
                } else if (oAiBusWidth > 1 && aiBusWidth <= 1) {
                    for (int i = 0; i < oAiBusWidth; ++i) {
                        if (netlist.getNetwork(oAi, i) != netlist.getNetwork(ai, 0)) continue;
                        connected = true;
                        break;
                    }
                }
            }
            if (!connected) {
                NodeInst headNi = ai.getHeadPortInst().getNodeInst();
                NodeInst tailNi = ai.getTailPortInst().getNodeInst();
                if (headNi.getProto() != Schematics.tech.wireConNode) {
                    headNi = null;
                }
                if (tailNi.getProto() != Schematics.tech.wireConNode) {
                    tailNi = null;
                }
                NodeInst oHeadNi = oAi.getHeadPortInst().getNodeInst();
                NodeInst oTailNi = oAi.getTailPortInst().getNodeInst();
                if (headNi == oHeadNi || headNi == oTailNi || tailNi == oHeadNi || tailNi == oTailNi) {
                    connected = true;
                }
            }
            if (connected || !Schematic.checkPoly(geom, poly, oGeom, oGeom, DBMath.MATID, false)) continue;
            return true;
        }
        return true;
    }

    private static boolean checkPoly(Geometric geom, Poly poly, Geometric oTopGeom, Geometric oGeom, AffineTransform oTrans, boolean canCross) {
        if (oGeom instanceof NodeInst) {
            if (geom instanceof ArcInst) {
                return false;
            }
            NodeInst ni = (NodeInst)oGeom;
            NodeProto np = ni.getProto();
            AffineTransform thisTrans = ni.rotateOut();
            thisTrans.preConcatenate(oTrans);
            if (np instanceof Cell) {
                AffineTransform subRot = ni.translateOut();
                subRot.preConcatenate(thisTrans);
                Cell subCell = (Cell)np;
                Iterator it = subCell.getNodes();
                while (it.hasNext()) {
                    NodeInst subNi = (NodeInst)it.next();
                    if (!Schematic.checkPoly(geom, poly, oTopGeom, subNi, subRot, canCross)) continue;
                    return true;
                }
                it = subCell.getArcs();
                while (it.hasNext()) {
                    ArcInst subAi = (ArcInst)it.next();
                    if (!Schematic.checkPoly(geom, poly, oTopGeom, subAi, subRot, canCross)) continue;
                    return true;
                }
            } else {
                Technology tech = np.getTechnology();
                Poly[] polyList = tech.getShapeOfNode(ni);
                int total = polyList.length;
                for (int i = 0; i < total; ++i) {
                    Poly nodePoly = polyList[i];
                    nodePoly.transform(thisTrans);
                    if (!Schematic.checkPolyAgainstPoly(geom, poly, oTopGeom, nodePoly, canCross)) continue;
                    return true;
                }
            }
        } else {
            if (geom instanceof NodeInst) {
                return false;
            }
            ArcInst ai = (ArcInst)geom;
            ArcInst oAi = (ArcInst)oGeom;
            Technology tech = oAi.getProto().getTechnology();
            Poly[] polyList = tech.getShapeOfArc(oAi);
            int total = polyList.length;
            if (oAi.getProto() == Schematics.tech.bus_arc && ai.getProto() == Schematics.tech.wire_arc || oAi.getProto() == Schematics.tech.wire_arc && ai.getProto() == Schematics.tech.bus_arc) {
                canCross = true;
            }
            for (int i = 0; i < total; ++i) {
                Poly oPoly = polyList[i];
                oPoly.transform(oTrans);
                if (!Schematic.checkPolyAgainstPoly(geom, poly, oTopGeom, oPoly, canCross)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkPolyAgainstPoly(Geometric geom, Poly poly, Geometric oGeom, Poly opoly, boolean canCross) {
        if (canCross) {
            int i;
            Point2D[] pointList = poly.getPoints();
            Rectangle2D.Double pointRect = new Rectangle2D.Double();
            boolean found = false;
            for (i = 0; i < pointList.length; ++i) {
                ((Rectangle2D)pointRect).setRect(pointList[i].getX(), pointList[i].getY(), 0.0, 0.0);
                if (!(opoly.polyDistance(pointRect) <= 0.0)) continue;
                found = true;
                break;
            }
            if (!found) {
                pointList = opoly.getPoints();
                found = false;
                for (i = 0; i < pointList.length; ++i) {
                    ((Rectangle2D)pointRect).setRect(pointList[i].getX(), pointList[i].getY(), 0.0, 0.0);
                    if (!(poly.polyDistance(pointRect) <= 0.0)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
        } else if (!poly.intersects(opoly)) {
            return false;
        }
        ErrorLogger.MessageLog err = errorLogger.logError("Objects '" + geom.getName() + "' '" + oGeom.getName() + "' touch", geom.getParent(), 0);
        err.addGeom(geom, true, geom.getParent(), null);
        err.addGeom(oGeom, true, geom.getParent(), null);
        return true;
    }

    private static boolean checkColinear(ArcInst ai, ArcInst oAi) {
        double oHigh;
        double fx = ai.getHeadLocation().getX();
        double fy = ai.getHeadLocation().getY();
        double tx = ai.getTailLocation().getX();
        double ty = ai.getTailLocation().getY();
        double oFx = oAi.getHeadLocation().getX();
        double oFy = oAi.getHeadLocation().getY();
        double oTx = oAi.getTailLocation().getX();
        double oTy = oAi.getTailLocation().getY();
        if (oFx == oTx && oFy == oTy) {
            return false;
        }
        double lowX = Math.min(fx, tx);
        double highX = Math.max(fx, tx);
        double lowY = Math.min(fy, ty);
        double highY = Math.max(fy, ty);
        int ang = 0;
        if (fx == tx) {
            double oLow = Math.min(oFy, oTy);
            oHigh = Math.max(oFy, oTy);
            if (oFx != fx || oTx != fx) {
                return false;
            }
            if (lowY >= oHigh || highY <= oLow) {
                return false;
            }
            ang = 900;
        } else if (fy == ty) {
            double oLow = Math.min(oFx, oTx);
            oHigh = Math.max(oFx, oTx);
            if (oFy != fy || oTy != fy) {
                return false;
            }
            if (lowX >= oHigh || highX <= oLow) {
                return false;
            }
            ang = 0;
        } else {
            int oAng;
            ang = DBMath.figureAngle(new Point2D.Double(fx, fy), new Point2D.Double(tx, ty));
            if (ang != (oAng = DBMath.figureAngle(new Point2D.Double(oFx, oFy), new Point2D.Double(oTx, oTy))) && Math.min(ang, oAng) + 1800 != Math.max(ang, oAng)) {
                return false;
            }
            if ((oFx - fx) * (ty - fy) / (tx - fx) != oFy - fy) {
                return false;
            }
            if ((oTx - fx) * (ty - fy) / (tx - fx) != oTy - fy) {
                return false;
            }
            double oLow = Math.min(oFy, oTy);
            double oHigh2 = Math.max(oFy, oTy);
            if (lowY >= oHigh2 || highY <= oLow) {
                return false;
            }
            oLow = Math.min(oFx, oTx);
            oHigh2 = Math.max(oFx, oTx);
            if (lowX >= oHigh2 || highX <= oLow) {
                return false;
            }
        }
        Cell cell = ai.getParent();
        ErrorLogger.MessageLog err = errorLogger.logError("Arcs overlap", cell, 0);
        err.addGeom(ai, true, cell, null);
        err.addGeom(oAi, true, cell, null);
        ang = (ang + 900) % 3600;
        double dist = 2.0;
        double gDist = dist / 2.0;
        double ca = Math.cos(ang);
        double sa = Math.sin(ang);
        double frX = fx + dist * ca;
        double frY = fy + dist * sa;
        double toX = tx + dist * ca;
        double toY = ty + dist * sa;
        err.addLine(frX, frY, toX, toY, cell);
        err.addLine(frX, frY, fx += gDist * ca, fy += gDist * sa, cell);
        err.addLine(tx += gDist * ca, ty += gDist * sa, toX, toY, cell);
        frX = oFx - dist * ca;
        frY = oFy - dist * sa;
        toX = oTx - dist * ca;
        toY = oTy - dist * sa;
        err.addLine(frX, frY, toX, toY, cell);
        err.addLine(frX, frY, oFx -= gDist * ca, oFy -= gDist * sa, cell);
        err.addLine(oTx -= gDist * ca, oTy -= gDist * sa, toX, toY, cell);
        return true;
    }

    static {
        errorLogger = null;
    }
}

