/* gcompris - cursor.h
 *
 * Copyright (C) 2002 Pascal Georges
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef CURSOR_H
#define CURSOR_H

#include <gtk/gtk.h>
#include <gdk_imlib.h>

#include <stdio.h>

GdkCursor *gdk_cursor_new_from_data(const gchar *bits[],
				    gint width, gint height,
				    GdkColor *fg, GdkColor *bg,
				    gint hot_x, gint hot_y);

/* Bitmap data of cursor */
static const gchar *big_red_arrow_cursor_bits[] = {
"111111                                  ",
"1000011111                              ",
"1000000001111                           ",
"1000000000001111                        ",
"10000000000000011111                    ",
"1000000000000000000111                  ",
"10000000000000000000011111              ",
"10000000000000000000000001111           ",
"1000000000000000000000000000111         ",
"10000000000000000000000000000011        ",
"100000000000000000000000000000011       ",
"100000000000000000000000000000001       ",
"100000000000000000000000000000001       ",
"100000000000000000000000000000001       ",
"100000000000000000000000000000111       ",
"1000000000000000000000000011111         ",
"100000000000000000000000111             ",
"1000000000000000000001111               ",
"1000000000000000000001                  ",
"1000000000000000000001                  ",
"1000000000000000000001                  ",
"10000000000000000000011                 ",
"100000000000000000000011                ",
"1000000000000000000000011               ",
"10000000000000000000000011              ",
"1000000000000111110000000111            ",
"10000000001111   110000000011           ",
" 1000000011       100000000011          ",
" 110000111        1110000000011         ",
"  111111            100000000011        ",
"                    1000000000011       ",
"                    1100000000001       ",
"                     100000000001       ",
"                      10000000001       ",
"                      11000000001       ",
"                       1000000001       ",
"                       1100000011       ",
"                        11000011        ",
"                         110011         ",
"                           11           "};

static const gchar *bird_cursor_bits[] = {
"        111                             ",
"     11000001                           ",
" 1110001000001                          ",
"110000000000001                         ",
"  11100000000001                        ",
"     0000000000011                      ",
"      100000000011111                   ",
"       000000010000111                  ",
"       0000000000000111                 ",
"       00000010000000011                ",
"       100000000000000011               ",
"       0000000000000000011              ",
"       10000000100000000011             ",
"        0000000000000000011             ",
"        10000001000000000011            ",
"         0000000000000000001            ",
"         10000000000000000011           ",
"          00000000000000000011          ",
"           0000000000000000011          ",
"            000000000000000011          ",
"             1000000000000000011        ",
"              10000000000000011         ",
"               1000000000000001         ",
"                 100000000000011        ",
"                  11000000111111        ",
"                    100000000011        ",
"                      11000000001       ",
"                         10000001       ",
"                            10001       ",
"                              00001     ",
"                              100001    ",
"                               00000    ",
"                               100001   ",
"                               1000001  ",
"                                1000001 ",
"                                 0000001",
"                                 0000000",
"                                 1000001",
"                                  10000 ",
"                                   01   "}; 

/* Bitmap data of a line */
static const gchar *big_red_line_cursor_bits[] = {
"1111111111111111111111111               ",
"111111111111111111111111                ",
"1100000000000000000111                  ",
"11000000000000000111                    ",
"110000000000000111                      ",
"1100000000000111                        ",
"11000000000111                          ",
"110000000011                            ",
"1100000000011                           ",
"11000000000011                          ",
"110000110000011                         ",
"1100001110000011                        ",
"1100011 11000011                        ",
"1100011  1100011                        ",
"110011    110011                        ",
"110011     11111                        ",
"11011                                   ",
"11011                                   ",
"1111              11111                 ",
"1111              111111                ",
"111               1100011               ",
"111               11000011              ",
"11                110000011             ",
"1                  110000011            ",
"                    110000011           ",
"                     110000011          ",
"                      110000011         ",
"                       110000011        ",
"                        110000011       ",
"                         110000011      ",
"                          110000011     ",
"                           110000011    ",
"                            110000011   ",
"                             110000011  ",
"                              110000011 ",
"                               110000011",
"                                11000011",
"                                 1100011",
"                                  111111",
"                                   11111"};

// Bitmap data of a rectangle
static const gchar *big_red_rectangle_cursor_bits[] = {
"1111111111111111111111111               ",
"111111111111111111111111                ",
"1100000000000000000111                  ",
"11000000000000000111                    ",
"110000000000000111                      ",
"1100000000000111                        ",
"11000000000111                          ",
"110000000011                            ",
"1100000000011                           ",
"11000000000011                          ",
"110000110000011                         ",
"1100001110000011                        ",
"1100011 11000011                        ",
"1100011  1100011                        ",
"110011    110011                        ",
"110011     11111                        ",
"11011                                   ",
"11011                                   ",
"1111             11111111111111111111111",
"1111             11111111111111111111111",
"111              11000000000000000000011",
"111              110                 011",
"11               110                 011",
"1                110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 11000000000000000000011",
"                 11111111111111111111111",
"                 11111111111111111111111"};

// Bitmap data of a rectangle
static const gchar *big_red_filledrectangle_cursor_bits[] = {
"1111111111111111111111111               ",
"111111111111111111111111                ",
"1100000000000000000111                  ",
"11000000000000000111                    ",
"110000000000000111                      ",
"1100000000000111                        ",
"11000000000111                          ",
"110000000011                            ",
"1100000000011                           ",
"11000000000011                          ",
"110000110000011                         ",
"1100001110000011                        ",
"1100011 11000011                        ",
"1100011  1100011                        ",
"110011    110011                        ",
"110011     11111                        ",
"11011                                   ",
"11011                                   ",
"1111             11111111111111111111111",
"1111             11111111111111111111111",
"111              11000000000000000000011",
"111              11000000000000000000011",
"11               11000000000000000000011",
"1                11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11111111111111111111111",
"                 11111111111111111111111"};

static const gchar *big_red_circle_cursor_bits[] = {
"1111111111111111111111111               ",
"111111111111111111111111                ",
"1100000000000000000111                  ",
"11000000000000000111                    ",
"110000000000000111                      ",
"1100000000000111                        ",
"11000000000111                          ",
"110000000011                            ",
"1100000000011                           ",
"11000000000011                          ",
"110000110000011                         ",
"1100001110000011                        ",
"1100011 11000011                        ",
"1100011  1100011                        ",
"110011    110011                        ",
"110011     11111                        ",
"11011                                   ",
"11011                                   ",
"1111                      11111         ",
"1111                    111111111       ",
"111                   11         11     ",
"111                  11           11    ",
"11                  11             11   ",
"1                  11               11  ",
"                   11               11  ",
"                  11                 11 ",
"                  11                 11 ",
"                 11                   11",
"                 11                   11",
"                 11                   11",
"                  11                 11 ",
"                  11                 11 ",
"                   11               11  ",
"                   11               11  ",
"                    11             11   ",
"                    11             11   ",
"                     11           11    ",
"                      11         11     ",
"                        111111111       ",
"                          11111         "};

static const gchar *big_red_filledcircle_cursor_bits[] = {
"1111111111111111111111111               ",
"111111111111111111111111                ",
"1100000000000000000111                  ",
"11000000000000000111                    ",
"110000000000000111                      ",
"1100000000000111                        ",
"11000000000111                          ",
"110000000011                            ",
"1100000000011                           ",
"11000000000011                          ",
"110000110000011                         ",
"1100001110000011                        ",
"1100011 11000011                        ",
"1100011  1100011                        ",
"110011    110011                        ",
"110011     11111                        ",
"11011                                   ",
"11011                                   ",
"1111                      11111         ",
"1111                    111111111       ",
"111                   1100000000011     ",
"111                  110000000000011    ",
"11                  11000000000000011   ",
"1                  1100000000000000011  ",
"                   1100000000000000011  ",
"                  110000000000000000011 ",
"                  110000000000000000011 ",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                 11000000000000000000011",
"                  110000000000000000011 ",
"                  110000000000000000011 ",
"                   1100000000000000011  ",
"                   1100000000000000011  ",
"                    11000000000000011   ",
"                    11000000000000011   ",
"                     110000000000011    ",
"                      1100000000011     ",
"                        111111111       ",
"                          11111         "};

static const gchar *big_red_fill_cursor_bits[] = {
"1111111111111111111111111               ",
"111111111111111111111111                ",
"1100000000000000000111                  ",
"11000000000000000111                    ",
"110000000000000111                      ",
"1100000000000111                        ",
"11000000000111                          ",
"110000000011                            ",
"1100000000011                           ",
"11000000000011                          ",
"110000110000011                         ",
"1100001110000011                        ",
"1100011 11000011        11111111        ",
"1100011  1100011        11111111        ",
"110011    110011        11000011        ",
"110011     11111        11000011        ",
"11011                   11000001        ",
"11011                   11000001        ",
"1111             11111111111111111111111",
"1111             11111111111111111111111",
"11               11000000000000000000011",
"1                110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110000              011",
"                 110 000             011",
"                 110   0000          011",
"                 110      0          011",
"                 110000   0          011",
"                 110 000  0          011",
"                 110   0000          011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 110                 011",
"                 11000000000000000000011",
"                 11111111111111111111111",
"                 11111111111111111111111"};

static const gchar *big_red_del_cursor_bits[] = {
"1111111111111111111111111               ",
"111111111111111111111111                ",
"1100000000000000000111                  ",
"11000000000000000111                    ",
"110000000000000111                      ",
"1100000000000111                        ",
"11000000000111                          ",
"110000000011                            ",
"1100000000011                           ",
"11000000000011                          ",
"110000110000011                         ",
"1100001110000011                        ",
"1100011 11000011                        ",
"1100011  1100011                        ",
"110011    110011                        ",
"110011     11111                        ",
"11011                                   ",
"11011                                   ",
"1111                                    ",
"1111      111                 111       ",
"11        1001               1001       ",
"1         10001             10001       ",
"           10001           10001        ",
"            10001         10001         ",
"             10001       10001          ",
"              10001     10001           ",
"               10001   10001            ",
"                10001 10001             ",
"                 100010001              ",
"                 100000001              ",
"                 100010001              ",
"                10001 10001             ",
"               10001   10001            ",
"              10001     10001           ",
"             10001       10001          ",
"            10001         10001         ",
"           10001           10001        ",
"          10001             10001       ",
"          1001               1001       ",
"          111                 111       "};

static const gchar *big_red_select_cursor_bits[] = {
"1111111111111111111111111               ",
"111111111111111111111111                ",
"1100000000000000000111                  ",
"11000000000000000111                    ",
"110000000000000111                      ",
"1100000000000111                        ",
"11000000000111                          ",
"110000000011                            ",
"1100000000011                           ",
"11000000000011                          ",
"110000110000011                         ",
"1100001110000011                        ",
"1100011 11000011                        ",
"1100011  1100011                        ",
"110011    110011                        ",
"110011     11111                        ",
"11011                                   ",
"11011               111                 ",
"1111               10001                ",
"1111              1000001               ",
"11               100000001              ",
"1               11110001111             ",
"                   10001                ",
"              1    10001    1           ",
"             11    10001    11          ",
"            101    10001    101         ",
"           100111111000111111001        ",
"          10000000000000000000001       ",
"          10000000000000000000001       ",
"          10000000000000000000001       ",
"           100111111000111111001        ",
"            101    10001    101         ",
"             11    10001    11          ",
"              1    10001    1           ",
"                   10001                ",
"                11110001111             ",
"                 100000001              ",
"                  1000001               ",
"                   10001                ",
"                    111                 "};

#endif
