/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gl4java.GLCapabilities;
import gl4java.GLEnum;
import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.awt.GLCanvas;
import gl4java.drawable.GLDrawable;
import gl4java.drawable.GLDrawableFactory;
import gl4java.drawable.GLEventListener;
import gnu.gleem.CameraParameters;
import gnu.gleem.ManipManager;
import gnu.gleem.Translate2Manip;
import gnu.gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class TestTranslate2 {
    private static final int X_SIZE = 400;
    private static final int Y_SIZE = 400;

    public static void main(String[] args) {
        Frame frame = new Frame("Translate2 Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        GLCanvas canvas = GLDrawableFactory.getFactory().createGLCanvas(new GLCapabilities(), 400, 400);
        canvas.addGLEventListener((GLEventListener)new Listener());
        frame.add((Component)canvas, "Center");
        frame.pack();
        frame.show();
    }

    static {
        X_SIZE = 400;
        Y_SIZE = 400;
    }

    static class Listener
    implements GLEventListener,
    GLEnum {
        private GLFunc gl;
        private GLUFunc glu;
        private CameraParameters params = new CameraParameters();

        Listener() {
        }

        public void init(GLDrawable drawable) {
            this.gl = drawable.getGL();
            this.glu = drawable.getGLU();
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            float[] lightPosition = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            float[] ambient = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            float[] diffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            this.gl.glLightfv(16384, 4608, ambient);
            this.gl.glLightfv(16384, 4609, diffuse);
            this.gl.glLightfv(16384, 4611, lightPosition);
            this.gl.glEnable(2896);
            this.gl.glEnable(16384);
            this.gl.glEnable(2929);
            this.params.setPosition(new Vec3f(0.0f, 0.0f, 0.0f));
            this.params.setForwardDirection(Vec3f.NEG_Z_AXIS);
            this.params.setUpDirection(Vec3f.Y_AXIS);
            this.params.setVertFOV(0.3926991f);
            this.params.setImagePlaneAspectRatio(1.0f);
            this.params.xSize = 400;
            this.params.ySize = 400;
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.glu.gluPerspective(45.0, 1.0, 1.0, 100.0);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
            ManipManager manager = ManipManager.getManipManager();
            manager.registerWindow(drawable);
            Translate2Manip manip = new Translate2Manip();
            manip.setTranslation(new Vec3f(0.0f, 0.0f, -5.0f));
            manip.setNormal(new Vec3f(-1.0f, 1.0f, 1.0f));
            manager.showManipInWindow(manip, drawable);
        }

        public void display(GLDrawable drawable) {
            this.gl.glClear(16640);
            ManipManager.getManipManager().updateCameraParameters(drawable, this.params);
            ManipManager.getManipManager().render(drawable, this.gl);
        }

        public void reshape(GLDrawable drawable, int w, int h) {
            float aspect = (float)w / (float)h;
            float theta = w >= h ? 45.0f : (float)Math.toDegrees(Math.atan(1.0f / aspect));
            this.params.setVertFOV((float)Math.toRadians(theta) / 2.0f);
            this.params.setImagePlaneAspectRatio(aspect);
            this.params.setXSize(w);
            this.params.setYSize(h);
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.glu.gluPerspective((double)theta, (double)aspect, 1.0, 100.0);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
        }

        public void preDisplay(GLDrawable drawable) {
        }

        public void postDisplay(GLDrawable drawable) {
        }

        public void cleanup(GLDrawable drawable) {
        }
    }
}

