/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gnu.gleem.linalg.Vec3f;

public class NormalCalc {
    public static NormalInfo computeFacetedNormals(Vec3f[] vertices, int[] indices, boolean ccw) {
        if (indices.length % 3 != 0) {
            System.err.println("NormalCalc.computeFacetedNormals: numIndices wasn't divisible by 3, so it can't possibly represent a set of triangles");
            return null;
        }
        Vec3f[] outputNormals = new Vec3f[indices.length / 3];
        int[] outputNormalIndices = new int[indices.length];
        Vec3f d1 = new Vec3f();
        Vec3f d2 = new Vec3f();
        int curNormalIndex = 0;
        int i = 0;
        while (i < indices.length) {
            int i0 = indices[i];
            int i1 = indices[i + 1];
            int i2 = indices[i + 2];
            if (i0 < 0 || i0 >= indices.length || i1 < 0 || i1 >= indices.length || i2 < 0 || i2 >= indices.length) {
                System.err.println("NormalCalc.computeFacetedNormals: ERROR: vertex index out of bounds or no end of triangle index found");
                return null;
            }
            Vec3f v0 = vertices[i0];
            Vec3f v1 = vertices[i1];
            Vec3f v2 = vertices[i2];
            d1.sub(v1, v0);
            d2.sub(v2, v0);
            Vec3f n = new Vec3f();
            if (ccw) {
                n.cross(d1, d2);
            } else {
                n.cross(d2, d1);
            }
            n.normalize();
            outputNormals[curNormalIndex] = n;
            outputNormalIndices[i] = curNormalIndex;
            outputNormalIndices[i + 1] = curNormalIndex;
            outputNormalIndices[i + 2] = curNormalIndex++;
            i += 3;
        }
        return new NormalInfo(outputNormals, outputNormalIndices);
    }

    public static class NormalInfo {
        public Vec3f[] normals;
        public int[] normalIndices;

        NormalInfo(Vec3f[] normals, int[] normalIndices) {
            this.normals = normals;
            this.normalIndices = normalIndices;
        }
    }
}

