#ifndef	_process_user_
#define	_process_user_

/* Module process */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine proc_sethostid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_sethostid
#if	defined(LINTLIBRARY)
    (process, hostid)
	process_t process;
	int hostid;
{ return __proc_sethostid(process, hostid); }
#else
(
	process_t process,
	int hostid
);
#endif

/* Routine proc_gethostid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_gethostid
#if	defined(LINTLIBRARY)
    (process, hostid)
	process_t process;
	int *hostid;
{ return __proc_gethostid(process, hostid); }
#else
(
	process_t process,
	int *hostid
);
#endif

/* Routine proc_sethostname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_sethostname
#if	defined(LINTLIBRARY)
    (process, hostname, hostnameCnt)
	process_t process;
	data_t hostname;
	mach_msg_type_number_t hostnameCnt;
{ return __proc_sethostname(process, hostname, hostnameCnt); }
#else
(
	process_t process,
	data_t hostname,
	mach_msg_type_number_t hostnameCnt
);
#endif

/* Routine proc_gethostname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_gethostname
#if	defined(LINTLIBRARY)
    (process, hostname, hostnameCnt)
	process_t process;
	data_t *hostname;
	mach_msg_type_number_t *hostnameCnt;
{ return __proc_gethostname(process, hostname, hostnameCnt); }
#else
(
	process_t process,
	data_t *hostname,
	mach_msg_type_number_t *hostnameCnt
);
#endif

/* Routine proc_getprivports */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getprivports
#if	defined(LINTLIBRARY)
    (process, host_priv, device_master)
	process_t process;
	mach_port_t *host_priv;
	mach_port_t *device_master;
{ return __proc_getprivports(process, host_priv, device_master); }
#else
(
	process_t process,
	mach_port_t *host_priv,
	mach_port_t *device_master
);
#endif

/* Routine proc_getallpids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getallpids
#if	defined(LINTLIBRARY)
    (process, pidarray, pidarrayCnt)
	process_t process;
	pidarray_t *pidarray;
	mach_msg_type_number_t *pidarrayCnt;
{ return __proc_getallpids(process, pidarray, pidarrayCnt); }
#else
(
	process_t process,
	pidarray_t *pidarray,
	mach_msg_type_number_t *pidarrayCnt
);
#endif

/* Routine proc_setexecdata */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setexecdata
#if	defined(LINTLIBRARY)
    (process, ports, portsPoly, portsCnt, ints, intsCnt)
	process_t process;
	portarray_t ports;
	mach_msg_type_name_t portsPoly;
	mach_msg_type_number_t portsCnt;
	intarray_t ints;
	mach_msg_type_number_t intsCnt;
{ return __proc_setexecdata(process, ports, portsPoly, portsCnt, ints, intsCnt); }
#else
(
	process_t process,
	portarray_t ports,
	mach_msg_type_name_t portsPoly,
	mach_msg_type_number_t portsCnt,
	intarray_t ints,
	mach_msg_type_number_t intsCnt
);
#endif

/* Routine proc_getexecdata */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getexecdata
#if	defined(LINTLIBRARY)
    (process, ports, portsCnt, ints, intsCnt)
	process_t process;
	portarray_t *ports;
	mach_msg_type_number_t *portsCnt;
	intarray_t *ints;
	mach_msg_type_number_t *intsCnt;
{ return __proc_getexecdata(process, ports, portsCnt, ints, intsCnt); }
#else
(
	process_t process,
	portarray_t *ports,
	mach_msg_type_number_t *portsCnt,
	intarray_t *ints,
	mach_msg_type_number_t *intsCnt
);
#endif

/* Routine proc_execdata_notify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_execdata_notify
#if	defined(LINTLIBRARY)
    (process, notify, notifyPoly)
	process_t process;
	mach_port_t notify;
	mach_msg_type_name_t notifyPoly;
{ return __proc_execdata_notify(process, notify, notifyPoly); }
#else
(
	process_t process,
	mach_port_t notify,
	mach_msg_type_name_t notifyPoly
);
#endif

/* Routine proc_uname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_uname
#if	defined(LINTLIBRARY)
    (process, uname)
	process_t process;
	utsname_t *uname;
{ return __proc_uname(process, uname); }
#else
(
	process_t process,
	utsname_t *uname
);
#endif

/* Routine proc_register_version */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_register_version
#if	defined(LINTLIBRARY)
    (process, credential, name, release, version)
	process_t process;
	mach_port_t credential;
	string_t name;
	string_t release;
	string_t version;
{ return __proc_register_version(process, credential, name, release, version); }
#else
(
	process_t process,
	mach_port_t credential,
	string_t name,
	string_t release,
	string_t version
);
#endif

/* SimpleRoutine proc_reauthenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_reauthenticate
#if	defined(LINTLIBRARY)
    (process, rendezvous2, rendezvous2Poly)
	process_t process;
	mach_port_t rendezvous2;
	mach_msg_type_name_t rendezvous2Poly;
{ return __proc_reauthenticate(process, rendezvous2, rendezvous2Poly); }
#else
(
	process_t process,
	mach_port_t rendezvous2,
	mach_msg_type_name_t rendezvous2Poly
);
#endif

/* Routine proc_child */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_child
#if	defined(LINTLIBRARY)
    (process, child)
	process_t process;
	mach_port_t child;
{ return __proc_child(process, child); }
#else
(
	process_t process,
	mach_port_t child
);
#endif

/* Routine proc_setmsgport */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setmsgport
#if	defined(LINTLIBRARY)
    (process, newmsgport, oldmsgport)
	process_t process;
	mach_port_t newmsgport;
	mach_port_t *oldmsgport;
{ return __proc_setmsgport(process, newmsgport, oldmsgport); }
#else
(
	process_t process,
	mach_port_t newmsgport,
	mach_port_t *oldmsgport
);
#endif

/* Routine proc_reassign */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_reassign
#if	defined(LINTLIBRARY)
    (process, newtask)
	process_t process;
	mach_port_t newtask;
{ return __proc_reassign(process, newtask); }
#else
(
	process_t process,
	mach_port_t newtask
);
#endif

/* Routine proc_setowner */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setowner
#if	defined(LINTLIBRARY)
    (process, owner, clear)
	process_t process;
	uid_t owner;
	int clear;
{ return __proc_setowner(process, owner, clear); }
#else
(
	process_t process,
	uid_t owner,
	int clear
);
#endif

/* Routine proc_getpids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getpids
#if	defined(LINTLIBRARY)
    (process, pid, ppid, orphaned)
	process_t process;
	pid_t *pid;
	pid_t *ppid;
	int *orphaned;
{ return __proc_getpids(process, pid, ppid, orphaned); }
#else
(
	process_t process,
	pid_t *pid,
	pid_t *ppid,
	int *orphaned
);
#endif

/* Routine proc_set_arg_locations */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_set_arg_locations
#if	defined(LINTLIBRARY)
    (process, argv, envp)
	process_t process;
	vm_address_t argv;
	vm_address_t envp;
{ return __proc_set_arg_locations(process, argv, envp); }
#else
(
	process_t process,
	vm_address_t argv,
	vm_address_t envp
);
#endif

/* Routine proc_get_arg_locations */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_get_arg_locations
#if	defined(LINTLIBRARY)
    (process, argv, envp)
	process_t process;
	vm_address_t *argv;
	vm_address_t *envp;
{ return __proc_get_arg_locations(process, argv, envp); }
#else
(
	process_t process,
	vm_address_t *argv,
	vm_address_t *envp
);
#endif

/* Routine proc_getmsgport */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getmsgport
#if	defined(LINTLIBRARY)
    (process, pid, msgport)
	process_t process;
	pid_t pid;
	mach_port_t *msgport;
{ return __proc_getmsgport(process, pid, msgport); }
#else
(
	process_t process,
	pid_t pid,
	mach_port_t *msgport
);
#endif

/* Routine proc_wait */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_wait
#if	defined(LINTLIBRARY)
    (process, pid, options, status, sigcode, rusage, pid_status)
	process_t process;
	pid_t pid;
	int options;
	int *status;
	int *sigcode;
	rusage_t *rusage;
	pid_t *pid_status;
{ return __proc_wait(process, pid, options, status, sigcode, rusage, pid_status); }
#else
(
	process_t process,
	pid_t pid,
	int options,
	int *status,
	int *sigcode,
	rusage_t *rusage,
	pid_t *pid_status
);
#endif

/* Routine proc_dostop */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_dostop
#if	defined(LINTLIBRARY)
    (process, contthread)
	process_t process;
	mach_port_t contthread;
{ return __proc_dostop(process, contthread); }
#else
(
	process_t process,
	mach_port_t contthread
);
#endif

/* Routine proc_handle_exceptions */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_handle_exceptions
#if	defined(LINTLIBRARY)
    (process, msgport, forwardport, forwardportPoly, flavor, new_state, new_stateCnt)
	process_t process;
	mach_port_t msgport;
	mach_port_t forwardport;
	mach_msg_type_name_t forwardportPoly;
	int flavor;
	thread_state_t new_state;
	mach_msg_type_number_t new_stateCnt;
{ return __proc_handle_exceptions(process, msgport, forwardport, forwardportPoly, flavor, new_state, new_stateCnt); }
#else
(
	process_t process,
	mach_port_t msgport,
	mach_port_t forwardport,
	mach_msg_type_name_t forwardportPoly,
	int flavor,
	thread_state_t new_state,
	mach_msg_type_number_t new_stateCnt
);
#endif

/* Routine proc_mark_stop */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_stop
#if	defined(LINTLIBRARY)
    (process, signo, sigcode)
	process_t process;
	int signo;
	int sigcode;
{ return __proc_mark_stop(process, signo, sigcode); }
#else
(
	process_t process,
	int signo,
	int sigcode
);
#endif

/* Routine proc_mark_cont */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_cont
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return __proc_mark_cont(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_mark_exit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_exit
#if	defined(LINTLIBRARY)
    (process, status, sigcode)
	process_t process;
	int status;
	int sigcode;
{ return __proc_mark_exit(process, status, sigcode); }
#else
(
	process_t process,
	int status,
	int sigcode
);
#endif

/* Routine proc_mark_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_exec
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return __proc_mark_exec(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_mark_traced */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_traced
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return __proc_mark_traced(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_mod_stopchild */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mod_stopchild
#if	defined(LINTLIBRARY)
    (process, doit)
	process_t process;
	int doit;
{ return __proc_mod_stopchild(process, doit); }
#else
(
	process_t process,
	int doit
);
#endif

/* Routine proc_pid2task */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_pid2task
#if	defined(LINTLIBRARY)
    (process, pid, task)
	process_t process;
	pid_t pid;
	mach_port_t *task;
{ return __proc_pid2task(process, pid, task); }
#else
(
	process_t process,
	pid_t pid,
	mach_port_t *task
);
#endif

/* Routine proc_task2pid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_task2pid
#if	defined(LINTLIBRARY)
    (process, task, pid)
	process_t process;
	mach_port_t task;
	pid_t *pid;
{ return __proc_task2pid(process, task, pid); }
#else
(
	process_t process,
	mach_port_t task,
	pid_t *pid
);
#endif

/* Routine proc_task2proc */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_task2proc
#if	defined(LINTLIBRARY)
    (process, task, proc)
	process_t process;
	mach_port_t task;
	mach_port_t *proc;
{ return __proc_task2proc(process, task, proc); }
#else
(
	process_t process,
	mach_port_t task,
	mach_port_t *proc
);
#endif

/* Routine proc_proc2task */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_proc2task
#if	defined(LINTLIBRARY)
    (process, task)
	process_t process;
	mach_port_t *task;
{ return __proc_proc2task(process, task); }
#else
(
	process_t process,
	mach_port_t *task
);
#endif

/* Routine proc_pid2proc */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_pid2proc
#if	defined(LINTLIBRARY)
    (process, pid, proc)
	process_t process;
	pid_t pid;
	mach_port_t *proc;
{ return __proc_pid2proc(process, pid, proc); }
#else
(
	process_t process,
	pid_t pid,
	mach_port_t *proc
);
#endif

/* Routine proc_getprocinfo */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getprocinfo
#if	defined(LINTLIBRARY)
    (process, which, flags, procinfo, procinfoCnt, threadwaits, threadwaitsCnt)
	process_t process;
	pid_t which;
	int *flags;
	procinfo_t *procinfo;
	mach_msg_type_number_t *procinfoCnt;
	data_t *threadwaits;
	mach_msg_type_number_t *threadwaitsCnt;
{ return __proc_getprocinfo(process, which, flags, procinfo, procinfoCnt, threadwaits, threadwaitsCnt); }
#else
(
	process_t process,
	pid_t which,
	int *flags,
	procinfo_t *procinfo,
	mach_msg_type_number_t *procinfoCnt,
	data_t *threadwaits,
	mach_msg_type_number_t *threadwaitsCnt
);
#endif

/* Routine proc_getprocargs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getprocargs
#if	defined(LINTLIBRARY)
    (process, which, procargs, procargsCnt)
	process_t process;
	pid_t which;
	data_t *procargs;
	mach_msg_type_number_t *procargsCnt;
{ return __proc_getprocargs(process, which, procargs, procargsCnt); }
#else
(
	process_t process,
	pid_t which,
	data_t *procargs,
	mach_msg_type_number_t *procargsCnt
);
#endif

/* Routine proc_getprocenv */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getprocenv
#if	defined(LINTLIBRARY)
    (process, which, procenv, procenvCnt)
	process_t process;
	pid_t which;
	data_t *procenv;
	mach_msg_type_number_t *procenvCnt;
{ return __proc_getprocenv(process, which, procenv, procenvCnt); }
#else
(
	process_t process,
	pid_t which,
	data_t *procenv,
	mach_msg_type_number_t *procenvCnt
);
#endif

/* Routine proc_make_login_coll */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_make_login_coll
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return __proc_make_login_coll(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_getloginid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getloginid
#if	defined(LINTLIBRARY)
    (process, pid, login_id)
	process_t process;
	pid_t pid;
	pid_t *login_id;
{ return __proc_getloginid(process, pid, login_id); }
#else
(
	process_t process,
	pid_t pid,
	pid_t *login_id
);
#endif

/* Routine proc_getloginpids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getloginpids
#if	defined(LINTLIBRARY)
    (process, id, pids, pidsCnt)
	process_t process;
	pid_t id;
	pidarray_t *pids;
	mach_msg_type_number_t *pidsCnt;
{ return __proc_getloginpids(process, id, pids, pidsCnt); }
#else
(
	process_t process,
	pid_t id,
	pidarray_t *pids,
	mach_msg_type_number_t *pidsCnt
);
#endif

/* Routine proc_setlogin */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setlogin
#if	defined(LINTLIBRARY)
    (process, logname)
	process_t process;
	string_t logname;
{ return __proc_setlogin(process, logname); }
#else
(
	process_t process,
	string_t logname
);
#endif

/* Routine proc_getlogin */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getlogin
#if	defined(LINTLIBRARY)
    (process, logname)
	process_t process;
	string_t logname;
{ return __proc_getlogin(process, logname); }
#else
(
	process_t process,
	string_t logname
);
#endif

/* Routine proc_setsid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setsid
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return __proc_setsid(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_getsid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getsid
#if	defined(LINTLIBRARY)
    (process, pid, sid)
	process_t process;
	pid_t pid;
	pid_t *sid;
{ return __proc_getsid(process, pid, sid); }
#else
(
	process_t process,
	pid_t pid,
	pid_t *sid
);
#endif

/* Routine proc_getsessionpgids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getsessionpgids
#if	defined(LINTLIBRARY)
    (process, sid, pgidset, pgidsetCnt)
	process_t process;
	pid_t sid;
	pidarray_t *pgidset;
	mach_msg_type_number_t *pgidsetCnt;
{ return __proc_getsessionpgids(process, sid, pgidset, pgidsetCnt); }
#else
(
	process_t process,
	pid_t sid,
	pidarray_t *pgidset,
	mach_msg_type_number_t *pgidsetCnt
);
#endif

/* Routine proc_getsessionpids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getsessionpids
#if	defined(LINTLIBRARY)
    (process, sid, pidset, pidsetCnt)
	process_t process;
	pid_t sid;
	pidarray_t *pidset;
	mach_msg_type_number_t *pidsetCnt;
{ return __proc_getsessionpids(process, sid, pidset, pidsetCnt); }
#else
(
	process_t process,
	pid_t sid,
	pidarray_t *pidset,
	mach_msg_type_number_t *pidsetCnt
);
#endif

/* Routine proc_getsidport */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getsidport
#if	defined(LINTLIBRARY)
    (process, sessport)
	process_t process;
	mach_port_t *sessport;
{ return __proc_getsidport(process, sessport); }
#else
(
	process_t process,
	mach_port_t *sessport
);
#endif

/* Routine proc_setpgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setpgrp
#if	defined(LINTLIBRARY)
    (process, pid, pgrp)
	process_t process;
	pid_t pid;
	pid_t pgrp;
{ return __proc_setpgrp(process, pid, pgrp); }
#else
(
	process_t process,
	pid_t pid,
	pid_t pgrp
);
#endif

/* Routine proc_getpgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getpgrp
#if	defined(LINTLIBRARY)
    (process, pid, pgrp)
	process_t process;
	pid_t pid;
	pid_t *pgrp;
{ return __proc_getpgrp(process, pid, pgrp); }
#else
(
	process_t process,
	pid_t pid,
	pid_t *pgrp
);
#endif

/* Routine proc_getpgrppids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getpgrppids
#if	defined(LINTLIBRARY)
    (process, pgrp, pidset, pidsetCnt)
	process_t process;
	pid_t pgrp;
	pidarray_t *pidset;
	mach_msg_type_number_t *pidsetCnt;
{ return __proc_getpgrppids(process, pgrp, pidset, pidsetCnt); }
#else
(
	process_t process,
	pid_t pgrp,
	pidarray_t *pidset,
	mach_msg_type_number_t *pidsetCnt
);
#endif

/* Routine proc_get_tty */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_get_tty
#if	defined(LINTLIBRARY)
    (calling_process, target_process, tty)
	process_t calling_process;
	pid_t target_process;
	mach_port_t *tty;
{ return __proc_get_tty(calling_process, target_process, tty); }
#else
(
	process_t calling_process,
	pid_t target_process,
	mach_port_t *tty
);
#endif


/* Module process */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine proc_sethostid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_sethostid
#if	defined(LINTLIBRARY)
    (process, hostid)
	process_t process;
	int hostid;
{ return proc_sethostid(process, hostid); }
#else
(
	process_t process,
	int hostid
);
#endif

/* Routine proc_gethostid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_gethostid
#if	defined(LINTLIBRARY)
    (process, hostid)
	process_t process;
	int *hostid;
{ return proc_gethostid(process, hostid); }
#else
(
	process_t process,
	int *hostid
);
#endif

/* Routine proc_sethostname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_sethostname
#if	defined(LINTLIBRARY)
    (process, hostname, hostnameCnt)
	process_t process;
	data_t hostname;
	mach_msg_type_number_t hostnameCnt;
{ return proc_sethostname(process, hostname, hostnameCnt); }
#else
(
	process_t process,
	data_t hostname,
	mach_msg_type_number_t hostnameCnt
);
#endif

/* Routine proc_gethostname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_gethostname
#if	defined(LINTLIBRARY)
    (process, hostname, hostnameCnt)
	process_t process;
	data_t *hostname;
	mach_msg_type_number_t *hostnameCnt;
{ return proc_gethostname(process, hostname, hostnameCnt); }
#else
(
	process_t process,
	data_t *hostname,
	mach_msg_type_number_t *hostnameCnt
);
#endif

/* Routine proc_getprivports */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprivports
#if	defined(LINTLIBRARY)
    (process, host_priv, device_master)
	process_t process;
	mach_port_t *host_priv;
	mach_port_t *device_master;
{ return proc_getprivports(process, host_priv, device_master); }
#else
(
	process_t process,
	mach_port_t *host_priv,
	mach_port_t *device_master
);
#endif

/* Routine proc_getallpids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getallpids
#if	defined(LINTLIBRARY)
    (process, pidarray, pidarrayCnt)
	process_t process;
	pidarray_t *pidarray;
	mach_msg_type_number_t *pidarrayCnt;
{ return proc_getallpids(process, pidarray, pidarrayCnt); }
#else
(
	process_t process,
	pidarray_t *pidarray,
	mach_msg_type_number_t *pidarrayCnt
);
#endif

/* Routine proc_setexecdata */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setexecdata
#if	defined(LINTLIBRARY)
    (process, ports, portsPoly, portsCnt, ints, intsCnt)
	process_t process;
	portarray_t ports;
	mach_msg_type_name_t portsPoly;
	mach_msg_type_number_t portsCnt;
	intarray_t ints;
	mach_msg_type_number_t intsCnt;
{ return proc_setexecdata(process, ports, portsPoly, portsCnt, ints, intsCnt); }
#else
(
	process_t process,
	portarray_t ports,
	mach_msg_type_name_t portsPoly,
	mach_msg_type_number_t portsCnt,
	intarray_t ints,
	mach_msg_type_number_t intsCnt
);
#endif

/* Routine proc_getexecdata */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getexecdata
#if	defined(LINTLIBRARY)
    (process, ports, portsCnt, ints, intsCnt)
	process_t process;
	portarray_t *ports;
	mach_msg_type_number_t *portsCnt;
	intarray_t *ints;
	mach_msg_type_number_t *intsCnt;
{ return proc_getexecdata(process, ports, portsCnt, ints, intsCnt); }
#else
(
	process_t process,
	portarray_t *ports,
	mach_msg_type_number_t *portsCnt,
	intarray_t *ints,
	mach_msg_type_number_t *intsCnt
);
#endif

/* Routine proc_execdata_notify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_execdata_notify
#if	defined(LINTLIBRARY)
    (process, notify, notifyPoly)
	process_t process;
	mach_port_t notify;
	mach_msg_type_name_t notifyPoly;
{ return proc_execdata_notify(process, notify, notifyPoly); }
#else
(
	process_t process,
	mach_port_t notify,
	mach_msg_type_name_t notifyPoly
);
#endif

/* Routine proc_uname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_uname
#if	defined(LINTLIBRARY)
    (process, uname)
	process_t process;
	utsname_t *uname;
{ return proc_uname(process, uname); }
#else
(
	process_t process,
	utsname_t *uname
);
#endif

/* Routine proc_register_version */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_register_version
#if	defined(LINTLIBRARY)
    (process, credential, name, release, version)
	process_t process;
	mach_port_t credential;
	string_t name;
	string_t release;
	string_t version;
{ return proc_register_version(process, credential, name, release, version); }
#else
(
	process_t process,
	mach_port_t credential,
	string_t name,
	string_t release,
	string_t version
);
#endif

/* SimpleRoutine proc_reauthenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_reauthenticate
#if	defined(LINTLIBRARY)
    (process, rendezvous2, rendezvous2Poly)
	process_t process;
	mach_port_t rendezvous2;
	mach_msg_type_name_t rendezvous2Poly;
{ return proc_reauthenticate(process, rendezvous2, rendezvous2Poly); }
#else
(
	process_t process,
	mach_port_t rendezvous2,
	mach_msg_type_name_t rendezvous2Poly
);
#endif

/* Routine proc_child */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_child
#if	defined(LINTLIBRARY)
    (process, child)
	process_t process;
	mach_port_t child;
{ return proc_child(process, child); }
#else
(
	process_t process,
	mach_port_t child
);
#endif

/* Routine proc_setmsgport */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setmsgport
#if	defined(LINTLIBRARY)
    (process, newmsgport, oldmsgport)
	process_t process;
	mach_port_t newmsgport;
	mach_port_t *oldmsgport;
{ return proc_setmsgport(process, newmsgport, oldmsgport); }
#else
(
	process_t process,
	mach_port_t newmsgport,
	mach_port_t *oldmsgport
);
#endif

/* Routine proc_reassign */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_reassign
#if	defined(LINTLIBRARY)
    (process, newtask)
	process_t process;
	mach_port_t newtask;
{ return proc_reassign(process, newtask); }
#else
(
	process_t process,
	mach_port_t newtask
);
#endif

/* Routine proc_setowner */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setowner
#if	defined(LINTLIBRARY)
    (process, owner, clear)
	process_t process;
	uid_t owner;
	int clear;
{ return proc_setowner(process, owner, clear); }
#else
(
	process_t process,
	uid_t owner,
	int clear
);
#endif

/* Routine proc_getpids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getpids
#if	defined(LINTLIBRARY)
    (process, pid, ppid, orphaned)
	process_t process;
	pid_t *pid;
	pid_t *ppid;
	int *orphaned;
{ return proc_getpids(process, pid, ppid, orphaned); }
#else
(
	process_t process,
	pid_t *pid,
	pid_t *ppid,
	int *orphaned
);
#endif

/* Routine proc_set_arg_locations */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_set_arg_locations
#if	defined(LINTLIBRARY)
    (process, argv, envp)
	process_t process;
	vm_address_t argv;
	vm_address_t envp;
{ return proc_set_arg_locations(process, argv, envp); }
#else
(
	process_t process,
	vm_address_t argv,
	vm_address_t envp
);
#endif

/* Routine proc_get_arg_locations */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_get_arg_locations
#if	defined(LINTLIBRARY)
    (process, argv, envp)
	process_t process;
	vm_address_t *argv;
	vm_address_t *envp;
{ return proc_get_arg_locations(process, argv, envp); }
#else
(
	process_t process,
	vm_address_t *argv,
	vm_address_t *envp
);
#endif

/* Routine proc_getmsgport */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getmsgport
#if	defined(LINTLIBRARY)
    (process, pid, msgport)
	process_t process;
	pid_t pid;
	mach_port_t *msgport;
{ return proc_getmsgport(process, pid, msgport); }
#else
(
	process_t process,
	pid_t pid,
	mach_port_t *msgport
);
#endif

/* Routine proc_wait */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_wait
#if	defined(LINTLIBRARY)
    (process, pid, options, status, sigcode, rusage, pid_status)
	process_t process;
	pid_t pid;
	int options;
	int *status;
	int *sigcode;
	rusage_t *rusage;
	pid_t *pid_status;
{ return proc_wait(process, pid, options, status, sigcode, rusage, pid_status); }
#else
(
	process_t process,
	pid_t pid,
	int options,
	int *status,
	int *sigcode,
	rusage_t *rusage,
	pid_t *pid_status
);
#endif

/* Routine proc_dostop */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_dostop
#if	defined(LINTLIBRARY)
    (process, contthread)
	process_t process;
	mach_port_t contthread;
{ return proc_dostop(process, contthread); }
#else
(
	process_t process,
	mach_port_t contthread
);
#endif

/* Routine proc_handle_exceptions */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_handle_exceptions
#if	defined(LINTLIBRARY)
    (process, msgport, forwardport, forwardportPoly, flavor, new_state, new_stateCnt)
	process_t process;
	mach_port_t msgport;
	mach_port_t forwardport;
	mach_msg_type_name_t forwardportPoly;
	int flavor;
	thread_state_t new_state;
	mach_msg_type_number_t new_stateCnt;
{ return proc_handle_exceptions(process, msgport, forwardport, forwardportPoly, flavor, new_state, new_stateCnt); }
#else
(
	process_t process,
	mach_port_t msgport,
	mach_port_t forwardport,
	mach_msg_type_name_t forwardportPoly,
	int flavor,
	thread_state_t new_state,
	mach_msg_type_number_t new_stateCnt
);
#endif

/* Routine proc_mark_stop */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_stop
#if	defined(LINTLIBRARY)
    (process, signo, sigcode)
	process_t process;
	int signo;
	int sigcode;
{ return proc_mark_stop(process, signo, sigcode); }
#else
(
	process_t process,
	int signo,
	int sigcode
);
#endif

/* Routine proc_mark_cont */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_cont
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return proc_mark_cont(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_mark_exit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_exit
#if	defined(LINTLIBRARY)
    (process, status, sigcode)
	process_t process;
	int status;
	int sigcode;
{ return proc_mark_exit(process, status, sigcode); }
#else
(
	process_t process,
	int status,
	int sigcode
);
#endif

/* Routine proc_mark_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_exec
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return proc_mark_exec(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_mark_traced */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_traced
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return proc_mark_traced(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_mod_stopchild */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mod_stopchild
#if	defined(LINTLIBRARY)
    (process, doit)
	process_t process;
	int doit;
{ return proc_mod_stopchild(process, doit); }
#else
(
	process_t process,
	int doit
);
#endif

/* Routine proc_pid2task */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_pid2task
#if	defined(LINTLIBRARY)
    (process, pid, task)
	process_t process;
	pid_t pid;
	mach_port_t *task;
{ return proc_pid2task(process, pid, task); }
#else
(
	process_t process,
	pid_t pid,
	mach_port_t *task
);
#endif

/* Routine proc_task2pid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_task2pid
#if	defined(LINTLIBRARY)
    (process, task, pid)
	process_t process;
	mach_port_t task;
	pid_t *pid;
{ return proc_task2pid(process, task, pid); }
#else
(
	process_t process,
	mach_port_t task,
	pid_t *pid
);
#endif

/* Routine proc_task2proc */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_task2proc
#if	defined(LINTLIBRARY)
    (process, task, proc)
	process_t process;
	mach_port_t task;
	mach_port_t *proc;
{ return proc_task2proc(process, task, proc); }
#else
(
	process_t process,
	mach_port_t task,
	mach_port_t *proc
);
#endif

/* Routine proc_proc2task */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_proc2task
#if	defined(LINTLIBRARY)
    (process, task)
	process_t process;
	mach_port_t *task;
{ return proc_proc2task(process, task); }
#else
(
	process_t process,
	mach_port_t *task
);
#endif

/* Routine proc_pid2proc */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_pid2proc
#if	defined(LINTLIBRARY)
    (process, pid, proc)
	process_t process;
	pid_t pid;
	mach_port_t *proc;
{ return proc_pid2proc(process, pid, proc); }
#else
(
	process_t process,
	pid_t pid,
	mach_port_t *proc
);
#endif

/* Routine proc_getprocinfo */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprocinfo
#if	defined(LINTLIBRARY)
    (process, which, flags, procinfo, procinfoCnt, threadwaits, threadwaitsCnt)
	process_t process;
	pid_t which;
	int *flags;
	procinfo_t *procinfo;
	mach_msg_type_number_t *procinfoCnt;
	data_t *threadwaits;
	mach_msg_type_number_t *threadwaitsCnt;
{ return proc_getprocinfo(process, which, flags, procinfo, procinfoCnt, threadwaits, threadwaitsCnt); }
#else
(
	process_t process,
	pid_t which,
	int *flags,
	procinfo_t *procinfo,
	mach_msg_type_number_t *procinfoCnt,
	data_t *threadwaits,
	mach_msg_type_number_t *threadwaitsCnt
);
#endif

/* Routine proc_getprocargs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprocargs
#if	defined(LINTLIBRARY)
    (process, which, procargs, procargsCnt)
	process_t process;
	pid_t which;
	data_t *procargs;
	mach_msg_type_number_t *procargsCnt;
{ return proc_getprocargs(process, which, procargs, procargsCnt); }
#else
(
	process_t process,
	pid_t which,
	data_t *procargs,
	mach_msg_type_number_t *procargsCnt
);
#endif

/* Routine proc_getprocenv */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprocenv
#if	defined(LINTLIBRARY)
    (process, which, procenv, procenvCnt)
	process_t process;
	pid_t which;
	data_t *procenv;
	mach_msg_type_number_t *procenvCnt;
{ return proc_getprocenv(process, which, procenv, procenvCnt); }
#else
(
	process_t process,
	pid_t which,
	data_t *procenv,
	mach_msg_type_number_t *procenvCnt
);
#endif

/* Routine proc_make_login_coll */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_make_login_coll
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return proc_make_login_coll(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_getloginid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getloginid
#if	defined(LINTLIBRARY)
    (process, pid, login_id)
	process_t process;
	pid_t pid;
	pid_t *login_id;
{ return proc_getloginid(process, pid, login_id); }
#else
(
	process_t process,
	pid_t pid,
	pid_t *login_id
);
#endif

/* Routine proc_getloginpids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getloginpids
#if	defined(LINTLIBRARY)
    (process, id, pids, pidsCnt)
	process_t process;
	pid_t id;
	pidarray_t *pids;
	mach_msg_type_number_t *pidsCnt;
{ return proc_getloginpids(process, id, pids, pidsCnt); }
#else
(
	process_t process,
	pid_t id,
	pidarray_t *pids,
	mach_msg_type_number_t *pidsCnt
);
#endif

/* Routine proc_setlogin */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setlogin
#if	defined(LINTLIBRARY)
    (process, logname)
	process_t process;
	string_t logname;
{ return proc_setlogin(process, logname); }
#else
(
	process_t process,
	string_t logname
);
#endif

/* Routine proc_getlogin */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getlogin
#if	defined(LINTLIBRARY)
    (process, logname)
	process_t process;
	string_t logname;
{ return proc_getlogin(process, logname); }
#else
(
	process_t process,
	string_t logname
);
#endif

/* Routine proc_setsid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setsid
#if	defined(LINTLIBRARY)
    (process)
	process_t process;
{ return proc_setsid(process); }
#else
(
	process_t process
);
#endif

/* Routine proc_getsid */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getsid
#if	defined(LINTLIBRARY)
    (process, pid, sid)
	process_t process;
	pid_t pid;
	pid_t *sid;
{ return proc_getsid(process, pid, sid); }
#else
(
	process_t process,
	pid_t pid,
	pid_t *sid
);
#endif

/* Routine proc_getsessionpgids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getsessionpgids
#if	defined(LINTLIBRARY)
    (process, sid, pgidset, pgidsetCnt)
	process_t process;
	pid_t sid;
	pidarray_t *pgidset;
	mach_msg_type_number_t *pgidsetCnt;
{ return proc_getsessionpgids(process, sid, pgidset, pgidsetCnt); }
#else
(
	process_t process,
	pid_t sid,
	pidarray_t *pgidset,
	mach_msg_type_number_t *pgidsetCnt
);
#endif

/* Routine proc_getsessionpids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getsessionpids
#if	defined(LINTLIBRARY)
    (process, sid, pidset, pidsetCnt)
	process_t process;
	pid_t sid;
	pidarray_t *pidset;
	mach_msg_type_number_t *pidsetCnt;
{ return proc_getsessionpids(process, sid, pidset, pidsetCnt); }
#else
(
	process_t process,
	pid_t sid,
	pidarray_t *pidset,
	mach_msg_type_number_t *pidsetCnt
);
#endif

/* Routine proc_getsidport */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getsidport
#if	defined(LINTLIBRARY)
    (process, sessport)
	process_t process;
	mach_port_t *sessport;
{ return proc_getsidport(process, sessport); }
#else
(
	process_t process,
	mach_port_t *sessport
);
#endif

/* Routine proc_setpgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setpgrp
#if	defined(LINTLIBRARY)
    (process, pid, pgrp)
	process_t process;
	pid_t pid;
	pid_t pgrp;
{ return proc_setpgrp(process, pid, pgrp); }
#else
(
	process_t process,
	pid_t pid,
	pid_t pgrp
);
#endif

/* Routine proc_getpgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getpgrp
#if	defined(LINTLIBRARY)
    (process, pid, pgrp)
	process_t process;
	pid_t pid;
	pid_t *pgrp;
{ return proc_getpgrp(process, pid, pgrp); }
#else
(
	process_t process,
	pid_t pid,
	pid_t *pgrp
);
#endif

/* Routine proc_getpgrppids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getpgrppids
#if	defined(LINTLIBRARY)
    (process, pgrp, pidset, pidsetCnt)
	process_t process;
	pid_t pgrp;
	pidarray_t *pidset;
	mach_msg_type_number_t *pidsetCnt;
{ return proc_getpgrppids(process, pgrp, pidset, pidsetCnt); }
#else
(
	process_t process,
	pid_t pgrp,
	pidarray_t *pidset,
	mach_msg_type_number_t *pidsetCnt
);
#endif

/* Routine proc_get_tty */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_get_tty
#if	defined(LINTLIBRARY)
    (calling_process, target_process, tty)
	process_t calling_process;
	pid_t target_process;
	mach_port_t *tty;
{ return proc_get_tty(calling_process, target_process, tty); }
#else
(
	process_t calling_process,
	pid_t target_process,
	mach_port_t *tty
);
#endif

#endif	/* not defined(_process_user_) */
