# GNU Enterprise Application Server - Test Program
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: test.py 9953 2009-10-11 18:50:17Z reinhard $

import os
from gnue.common.apps.GClientApp import GClientApp
from gnue.common.datasources.GLoginHandler import SilentLoginHandler
from gnue.appserver.geasSessionManager import geasSessionManager
from gnue.appserver import geasConfiguration

# =============================================================================
# Test application
# =============================================================================

class testApp (GClientApp):

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------
  def __init__ (self, connections = None):
    ConfigOptions = geasConfiguration.ConfigOptions
    GClientApp.__init__ (self, connections, 'appserver', ConfigOptions)


  # ---------------------------------------------------------------------------
  # Create a session manager object
  # ---------------------------------------------------------------------------
  def getSessionManager (self):
    self.connections.setLoginHandler (SilentLoginHandler (_username = 'gnue',
                                                          _password = ''))

    print "Creating session manager ..."
    sm = geasSessionManager (self.connections)

    return sm


  def _ok (self):
    print "Ok   <Enter>"
    raw_input ()

  # ---------------------------------------------------------------------------
  # Main program
  # ---------------------------------------------------------------------------
  def run (self):
    sm = self.getSessionManager ()

    print "Opening session ...",
    session = sm.open ({"user":"hacker", "password":"secret"})
    self._ok ()

    print "Creating and populating list object ...",
    list = session.request ("address_person", [], ["address_zip"],
                       ["address_name", "address_street", "address_city",
                        "address_country.address_code",
                        "address_country.address_name"])
    self._ok ()

    print "Retrieving first instance ...",
    rset = list.fetch (0, 1)
    first_id = rset[0][0]
    self._ok ()

    print "These are the values of the first instance:"
    print "  Name   :", rset[0][1]
    print "  Street :", rset[0][2]
    print "  City   :", rset[0][3]
    print "  Country:", rset[0][4] + '/' + rset[0][5]

    print "Retrieving second instance ...",
    rset = list.fetch (1, 1)
    self._ok ()

    print "These are the values of the second instance:"
    print "  Name   :", rset[0][1]
    print "  Street :", rset[0][2]
    print "  City   :", rset[0][3]
    print "  Country:", rset[0][4] + '/' + rset[0][5]

    print "Closing the list ..."
    list = None
    self._ok ()

    print "Executing rollback to clear cache ...",
    session.rollback ()
    self._ok ()

    print "Loading the datatypes with load () ...",
    rset = session.load ("address_person", [None],
                    ["address_name", "address_street", "address_city",
                     "address_country.address_code",
                     "address_country.address_name",
                     "address_nextmeeting"])
    self._ok ()

    print "These are again the values of the first instance:"
    print "  Name   :", rset[0][0]
    print "  Street :", rset[0][1]
    print "  City   :", rset[0][2]
    print "  Country:", rset[0][3] + '/' + rset[0][4]
    print "  Meeting:", rset[0][5]

    print "Loading the first instance with load () ...",
    rset = session.load ("address_person", [first_id],
                    ["address_name", "address_street", "address_city",
                     "address_country.address_code",
                     "address_country.address_name",
                     "address_nextmeeting"])
    self._ok ()

    print "These are again the values of the first instance:"
    print "  Name   :", rset[0][0]
    print "  Street :", rset[0][1]
    print "  City   :", rset[0][2]
    print "  Country:", rset[0][3] + '/' + rset[0][4]
    print "  Meeting:", rset[0][5]

    print "Now I call the procedure 'show' for the first instance:"
    try:
      res = session.call ("address_person", [first_id], "address_show", {})
    except Exception, msg:
      print " Exception:", msg

    print "Now I call the procedure 'test' for the first instance:"
    try:
      res = session.call ("address_person", [first_id], "address_test", {})
      print "Result:", res
    except:
      pass

    print "Committing and closing session ...",
    session.commit ()
    session = None

    self._ok ()



# =============================================================================
# Let it rock
# =============================================================================
if __name__ == "__main__":
  testApp().run()
  print "Thank you for playing!"
