# GNU Enterprise Forms - QT3 driver - Page widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: page.py 9956 2009-10-11 18:54:57Z reinhard $

import qt

from _base import UIHelper

# =============================================================================
# UIPage implements a <page> tag
# =============================================================================

class UIPage(UIHelper):
    """
    Implmenetation of the page tag

    @ivar page_index: zero-based index of the page within the form's
        page-container (which is either a notebook or a panel).
    """

    page_index = 0

    # -------------------------------------------------------------------------
    # Create a new page widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Create the page widget and add it to the page-container.  The spacer is
        ignored for page tags.

        @returns: the QWidget instance which is the parent for all child
            widgets of this page.  It has already a QLayout descendant set.
        """

        self.page_index = len(self._uiForm.pages)

        parent = event.container

        self._container = qt.QWidget(parent)
        if self.managed:
            page_sizer = qt.QVBoxLayout(self._container)
        else:
            w = getattr(self._form._layout, 'Char__width', -1)
            h = getattr(self._form._layout, 'Char__height', -1)
            page_sizer = qt.QGridLayout(self._container, h+1, w, 2, 2)
            page_sizer.setRowStretch(h, 1)

        if isinstance(parent, qt.QTabWidget):
            title = "%s" % (self._gfObject.caption or self._gfObject.name)
            parent.addTab(self._container, title)
        else:
            parent.layout().addWidget(self._container)

        self._uiForm.pages.append(self._container)

        return self._container


    # -------------------------------------------------------------------------
    # Add an UI widget to the page
    # -------------------------------------------------------------------------

    def add_widgets(self, ui_widget, spacer):
        """
        Add an UI widget to the page

        @param ui_widget: UI widget to be added
        @param spacer: not used for pages
        """

        item = ui_widget.widget
        sizer = self._container.layout()

        if self.managed:
            sizer.addWidget(item)
        else:
            sizer.addMultiCellWidget(item, ui_widget.chr_y, ui_widget.chr_y +
                    ui_widget.chr_h - 1, ui_widget.chr_x, ui_widget.chr_x +
                    ui_widget.chr_w - 1, qt.Qt.AlignLeft | qt.Qt.AlignTop)
    
# =============================================================================
# Configuration
# =============================================================================

configuration = {
  'baseClass': UIPage,
  'provides' : 'GFPage',
  'container': 1
}
