# GNU Enterprise Forms - win32 UI Driver - MenuItem widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: menuitem.py 9956 2009-10-11 18:54:57Z reinhard $

import win32gui
import win32con

from gnue.forms.uidrivers.win32.widgets._base import UIHelper
from gnue.forms.uidrivers.win32.common import getNextId, textEncode

_menustyle = win32con.MF_STRING


# =============================================================================
# Wrap an UI layer around a Menu widget
# =============================================================================

class UIMenuItem(UIHelper):
    """
    Implements a menu item object.
    """

    # -------------------------------------------------------------------------
    # Create a menu item widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Creates a new MenuItem widget.
        """
        # These are the relevant parameters
        icon_file = self._gfObject._get_icon_file(size="16x16", format="png")
        label = self._gfObject.label
        description = self._gfObject.description
        hotkey = self._gfObject.hotkey
        check = (self._gfObject.action_off is not None)

        self.__id = getNextId()
        if label is not None:
            if hotkey is not None:
                label += u"\t" + hotkey

            event.container.parent.parent.addDescription(self.__id, textEncode(description) or '')
            widget = win32gui.AppendMenu(event.container.id, _menustyle, self.__id, textEncode(label))
            event.container.parent.parent.Connect(self.__id, self.__on_menu)
                
        else:
            widget = None
            win32gui.AppendMenu(event.container.id, win32con.MF_SEPARATOR, 0, "")

        self.__widget = Menu(self.__id, event.container)

        return self.__widget


    # -------------------------------------------------------------------------
    # Events
    # -------------------------------------------------------------------------

    def __on_menu(self, *args):
        self._gfObject._event_fire()


    # -------------------------------------------------------------------------
    # Check/uncheck menu item
    # -------------------------------------------------------------------------

    def _ui_switch_on_(self):
        if self.__widget is not None:
            win32gui.CheckMenuItem(self.__widget.parent.id, self.__widget.id,
                            win32con.MF_BYCOMMAND|win32con.MF_CHECKED)

    # -------------------------------------------------------------------------

    def _ui_switch_off_(self):
        if self.__widget is not None:
            win32gui.CheckMenuItem(self.__widget.parent.id, self.__widget.id,
                            win32con.MF_BYCOMMAND|win32con.MF_UNCHECKED)


    # -------------------------------------------------------------------------
    # Enable/disable menu item
    # -------------------------------------------------------------------------

    def _ui_enable_(self):
        if self.__widget is not None:
            win32gui.EnableMenuItem(self.__widget.parent.id, self.__widget.id,
                            win32con.MF_BYCOMMAND|win32con.MF_ENABLED)

    # -------------------------------------------------------------------------

    def _ui_disable_(self):
        if self.__widget is not None:
            win32gui.EnableMenuItem(self.__widget.parent.id, self.__widget.id,
                            win32con.MF_BYCOMMAND|win32con.MF_GRAYED)


class Menu:
    def __init__(self, id, parent):
        self.id = id
        self.parent = parent

# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass': UIMenuItem,
  'provides' : 'GFMenuItem',
  'container': False
}
