#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# FILE:
# GRLayout.py
#
# DESCRIPTION:
# Classes related to the Layout section
#
# NOTES:
#


from gnue.common.apps import GDebug
import string
from GRLayoutElement import GRLayoutElement
from xml.sax import saxutils


############################################################
#
# <summ> tag
#
class GRSumm (GRLayoutElement):
  def __init__(self, parent):
    GRLayoutElement.__init__(self, parent, 'GRSumm')
    self.section = None
    self.function = "count"
    self.format = None

  def _buildObject(self):
    if self.section:
      self._section = string.lower(self.section)
    else:
      self._section = None

    if hasattr(self,  'field'):
        self._field = string.lower(self.field)
    else:
        self._field = None
    if hasattr(self,  'formula'):
        self._formula = string.lower(self.formula)
    else:
        self._formula = None
    return GRLayoutElement._buildObject(self)

  def process(self, dest, mapper, isfirst, islast, firstSection, nextSection):
    ## structuralComment(dest,"<!-- [summ:%s:%s:%s] -->" % (self.section, self._field, self.function))
    dest.write (self._mymapper.getSummary((self._field, self._formula), self.function, self.format))
    ## structuralComment(dest,"<!-- [/summ] -->")
    return nextSection

