/*
     This file is part of GNUnet.
     (C) 2010 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/download.h
 * @brief functions for downloading
 * @author Christian Grothoff
 */

#ifndef DOWNLOAD_H
#define DOWNLOAD_H
#include "common.h"

/**
 * Information we keep for a download.
 */
struct DownloadContext
{
  /**
   * URI for the download.
   */
  struct GNUNET_FS_Uri *uri;

  /**
   * Meta data.
   */
  struct GNUNET_CONTAINER_MetaData *meta;

  /**
   * Mime type.
   */ 
  char *mime;

  /**
   * Suggested filename, or NULL.
   */
  char *filename;

  /**
   * Row reference (if URI was found by search, or 
   * part of directory, etc.); otherwise NULL (download by URI).
   */
  GtkTreeRowReference *rr;

  /**
   * Associated search result, or NULL.
   */
  struct GNUNET_FS_SearchResult *sr;

  /**
   * Is this a recursive download?
   */
  int is_recursive;

  /**
   * Desired (default) anonymity level.
   */
  int anonymity;
};



void
GNUNET_GTK_open_download_as_dialog (struct DownloadContext *dc);

#endif
