/* 
   XRWindow.h

   NSWindow for GNUstep GUI X/RAW Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Author:  Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: August 1995
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_XRWindow
#define _GNUstep_H_XRWindow

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <AppKit/NSWindow.h>
#include <Foundation/NSMapTable.h>

@class NSMutableArray;

//
// Global variables
//

NSMutableArray  *_XRGlobalWindowList;

//
// Methods for XWindows implementation
//
@interface XRWindow : NSWindow
{
}

+ (XRWindow*)_windowForXWindow:(Window)xWindow;
+ (NSWindow*)_windowWithTag:(int)windowNumber;

- (void)setContentViewSize:(NSSize)aSize;

- (Pixmap)xBackingPixmap;
- (unsigned int)xHeight;
- (NSRect)xFrame;
- (Window)xWindow;
- (GC)xGC;
- (void)xSetFrameFromXFrame:(NSRect)rect;
- (void)xSetUnmapped:(BOOL)flag;
- (void)_updateWindowGeometry;
- (Drawable)xDrawable;
- (void)_createBackingStore;

//
// Dealing with expose events
//
- (void)_addExposedRectangle:(XRectangle)rectangle;
- (void)_processExposedRectangles;

//
// Flush methods
//
- (void)_windowNeedsFlushInRect:(NSRect)rect;		
- (void) _windowNeedsFlushInXRect: (XRectangle)xRect;

@end

//
// Backend structure for XRWindow
//
typedef struct _XRWindow_struct
{
  Window xWindow;
  Display* xDisplay;
  GC context;
  BOOL is_exposed;
  NSMutableArray* exposedRects;
  Drawable xPixmap;		// This is the pixmap used as backing store
  int x, y;				// The actual coordinates of xWindow (device space)
  int width, height;	// The actual size of xWindow (device space)
  int depth;			// Depth of xWindow
  Region region;		// Temporary region used between several expose events

} XRWindow_struct;

#endif /* _GNUstep_H_XRWindow */
