/* Generic header info common to X backends for GNUstep

   Copyright (C) 2000 Free Software Foundation, Inc.

   Written by:  Richard Frith-Macdonald <rfm@gnu.org>
   Date: Mar 2000
   
   This file is part of the GNUstep project

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#ifndef	INCLUDED_XGGENERIC_H
#define	INCLUDED_XGGENERIC_H

/*
 * Typedef for current window manager.
 */
typedef	enum {
  XGWM_UNKNOWN,
  XGWM_WINDOWMAKER
} XGWMType;

/*
 * Structure containing ivars that are common to all X backend contexts.
 */
struct XGGeneric {
  XGWMType		wm;
  unsigned		lastKeyFlags;
  Time			lastTime;
  Time			lastClick;
  Time			lastMotion;
  Atom			protocols_atom;
  Atom			delete_win_atom;
  Atom			take_focus_atom;
  Atom			miniaturize_atom;
  Atom			win_decor_atom;
  Atom			titlebar_state_atom;
  char			*rootName;
  long			currentFocusWindow;
  long			desiredFocusWindow;
  long			focusRequestNumber;
};

/*
 * Graphics context methods that are common to X backends
 * Implemented in SharedX/XGContextEvent.m or SharedX/XGContextWindow.m
 */
@interface	NSGraphicsContext (XGGeneric)
- (NSRect) _OSFrameToXFrame: (NSRect)o for: (void*)window;
- (NSRect) _OSFrameToXHints: (NSRect)o for: (void*)window;
- (NSRect) _XFrameToOSFrame: (NSRect)x for: (void*)window;
@end

Window _findXWindow(Display* display, Window topwindow, Window window_to_check,
		    int x, int y);

#endif

