/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.CompilationException;
import gnu.jel.OP;
import gnu.jel.OPfunction;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import gnu.jel.TableKeeper;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import java.util.Stack;

public class OPbinary
extends OPfunction {
    private int code;
    private int opsIDX;
    private static final String[] opNames;
    private static final String[] opSymbols;
    protected static final byte[][] promotions;
    private static final int[][] ops;
    private static final char[][] openjumps;
    private static final byte[] promotionTypes;

    public OPbinary(TypesStack typesStk, Stack paramOPs, int opcode, OPlist list) throws CompilationException {
        Debug.assert(this.code >= 0 && this.code < opNames.length && opNames.length == opSymbols.length);
        int op2ID = typesStk.peekID();
        Class op2Type = typesStk.pop();
        int op1ID = typesStk.peekID();
        Class op1Type = typesStk.pop();
        OP p2CvtPlaceholder = (OP)paramOPs.pop();
        OP p1CvtPlaceholder = (OP)paramOPs.pop();
        if ((op1ID == 10 || op1ID == 11) && this.code == 0) {
            opcode = 20;
        }
        this.code = opcode;
        int op2cvtID = op2ID;
        int op1cvtID = op1ID;
        this.resID = -1;
        boolean second_narrowing = false;
        switch (promotionTypes[opcode]) {
            case 0: {
                this.resID = 0;
            }
            case 1: {
                op2cvtID = this.opsIDX = promotions[TypesStack.baseType[TypesStack.unwrapType[op1ID]]][TypesStack.baseType[TypesStack.unwrapType[op2ID]]];
                op1cvtID = this.opsIDX;
                if (this.resID < 0) {
                    this.resID = this.opsIDX;
                }
                if (this.opsIDX != -1) break;
                Object[] paramsExc = new Object[]{op1Type, op2Type, opNames[opcode]};
                throw new CompilationException(-1, 15, paramsExc);
            }
            case 2: {
                op1cvtID = this.opsIDX = OPunary.unary_prmtns[TypesStack.unwrapType[op1ID]];
                this.resID = this.opsIDX;
                if (!TypesStack.isIntegral(TypesStack.unwrapType[op2ID])) {
                    Object[] paramsExc = new Object[]{opNames[opcode], op2Type};
                    throw new CompilationException(-1, 27, paramsExc);
                }
                op2cvtID = 4;
                second_narrowing = true;
                break;
            }
            case 3: {
                Class<?> clazz = this.resType = op1Type != null ? op1Type.getComponentType() : null;
                if (this.resType == null) {
                    throw new CompilationException(-1, 18, null);
                }
                this.resID = TypesStack.typeID(this.resType);
                if (!TypesStack.isIntegral(TypesStack.unwrapType[op2ID])) {
                    Object[] paramsExc = new Object[]{opNames[opcode], op2Type};
                    throw new CompilationException(-1, 27, paramsExc);
                }
                op2cvtID = 4;
                this.opsIDX = TypesStack.baseType[this.resID];
                break;
            }
            case 4: {
                if (op1ID != 10 && op1ID != 11) {
                    throw new CompilationException(-1, 17, null);
                }
                this.opsIDX = TypesStack.baseType[op2ID];
                op1cvtID = 10;
                this.resID = 10;
                break;
            }
            default: {
                Debug.println("Wrong promotion type for binary OP " + promotionTypes[opcode]);
            }
        }
        if (ops[opcode][this.opsIDX] == 255) {
            Object[] paramsExc = new Object[]{opNames[opcode], op1Type, op2Type};
            throw new CompilationException(-1, 16, paramsExc);
        }
        if (op1ID != op1cvtID) {
            typesStk.pushID(op1ID);
            list.addAfter(p1CvtPlaceholder, new OPunary(typesStk, op1cvtID, null, false));
            typesStk.pop();
        }
        if (op2ID != op2cvtID) {
            typesStk.pushID(op2ID);
            list.addAfter(p2CvtPlaceholder, new OPunary(typesStk, op2cvtID, null, second_narrowing));
            typesStk.pop();
        }
        typesStk.pushID(this.resID, this.resType);
    }

    public int getNParams() {
        return 2;
    }

    protected void compile_par(ClassFile cf, int n) {
        if (this.code == 17 || this.code == 18) {
            if (n == 1) {
                cf.logical_param(this.code == 17);
            } else {
                cf.logical_end(this.code == 17);
            }
        } else {
            cf.ensure_value();
        }
    }

    protected void compile(ClassFile cf) {
        if (this.code != 17 && this.code != 18) {
            cf.code(ops[this.code][this.opsIDX]);
            cf.currJump = openjumps[this.code][this.opsIDX];
            cf.typesStk.pop();
            cf.typesStk.pop();
            if (cf.currJump == 0) {
                cf.typesStk.pushID(this.resID, this.resType);
            }
        }
    }

    protected void eval(OPlist list) {
        if (this.code == 19) {
            return;
        }
        try {
            OPload c2 = (OPload)this.prev;
            OPload c1 = (OPload)this.prev.prev;
            if (this.code == 20) {
                ((StringBuffer)c1.what).append(String.valueOf(c2.what));
            } else {
                Number n1 = TypesStack.widen(c1.what, c1.resID);
                Number n2 = TypesStack.widen(c2.what, c2.resID);
                boolean boolres = false;
                boolean resbool = false;
                if (this.opsIDX >= 6 && this.opsIDX <= 7) {
                    double d1 = n1.doubleValue();
                    double d2 = n2.doubleValue();
                    boolean wrop = false;
                    switch (this.code) {
                        case 0: {
                            d1 += d2;
                            break;
                        }
                        case 1: {
                            d1 -= d2;
                            break;
                        }
                        case 2: {
                            d1 *= d2;
                            break;
                        }
                        case 3: {
                            d1 /= d2;
                            break;
                        }
                        case 4: {
                            d1 %= d2;
                            break;
                        }
                        case 5: {
                            wrop = true;
                            break;
                        }
                        case 6: {
                            wrop = true;
                            break;
                        }
                        case 7: {
                            wrop = true;
                            break;
                        }
                        case 8: {
                            boolres = true;
                            resbool = d1 == d2;
                            break;
                        }
                        case 9: {
                            boolres = true;
                            resbool = d1 != d2;
                            break;
                        }
                        case 10: {
                            boolres = true;
                            resbool = d1 < d2;
                            break;
                        }
                        case 11: {
                            boolres = true;
                            resbool = d1 >= d2;
                            break;
                        }
                        case 12: {
                            boolres = true;
                            resbool = d1 > d2;
                            break;
                        }
                        case 13: {
                            boolres = true;
                            resbool = d1 <= d2;
                            break;
                        }
                        default: {
                            wrop = true;
                        }
                    }
                    if (wrop) {
                        Debug.println("Wrong operation on float (" + this.code + ").");
                    }
                    n1 = !boolres ? (Number)new Double(d1) : (Number)(resbool ? new Long(1L) : new Long(0L));
                } else {
                    long l1 = n1.longValue();
                    long l2 = n2.longValue();
                    switch (this.code) {
                        case 0: {
                            l1 += l2;
                            break;
                        }
                        case 1: {
                            l1 -= l2;
                            break;
                        }
                        case 2: {
                            l1 *= l2;
                            break;
                        }
                        case 3: {
                            l1 /= l2;
                            break;
                        }
                        case 4: {
                            l1 %= l2;
                            break;
                        }
                        case 5: 
                        case 17: {
                            l1 &= l2;
                            break;
                        }
                        case 6: 
                        case 18: {
                            l1 |= l2;
                            break;
                        }
                        case 7: {
                            l1 ^= l2;
                            break;
                        }
                        case 8: {
                            boolres = true;
                            l1 = l1 == l2 ? 1L : 0L;
                            break;
                        }
                        case 9: {
                            boolres = true;
                            l1 = l1 != l2 ? 1L : 0L;
                            break;
                        }
                        case 10: {
                            boolres = true;
                            l1 = l1 < l2 ? 1L : 0L;
                            break;
                        }
                        case 11: {
                            boolres = true;
                            l1 = l1 >= l2 ? 1L : 0L;
                            break;
                        }
                        case 12: {
                            boolres = true;
                            l1 = l1 > l2 ? 1L : 0L;
                            break;
                        }
                        case 13: {
                            boolres = true;
                            l1 = l1 <= l2 ? 1L : 0L;
                            break;
                        }
                        case 14: {
                            l1 <<= (int)l2;
                            break;
                        }
                        case 15: {
                            l1 >>= (int)l2;
                            break;
                        }
                        case 16: {
                            if (this.resID == 4) {
                                l1 = (int)l1 >>> (int)l2;
                                break;
                            }
                            l1 >>>= (int)l2;
                            break;
                        }
                        default: {
                            Debug.println("Wrong operation on integer (" + this.code + ").");
                        }
                    }
                    n1 = new Long(l1);
                }
                if (boolres) {
                    c1.what = TypesStack.narrow(n1, 0);
                    c1.resType = Boolean.TYPE;
                    c1.resID = 0;
                } else {
                    c1.what = TypesStack.narrow(n1, this.resID);
                }
            }
            list.remove(this.prev);
            list.remove(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        return opSymbols[this.code];
    }

    static {
        promotions = (byte[][])TableKeeper.getTable("promotions");
        ops = (int[][])TableKeeper.getTable("ops");
        openjumps = (char[][])TableKeeper.getTable("openjumps");
        promotionTypes = (byte[])TableKeeper.getTable("promotionTypes");
        opNames = (String[])TableKeeper.getTable("binOpNames");
        opSymbols = (String[])TableKeeper.getTable("binOpSymbols");
    }
}

